/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.xloader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.iterator.IteratorSlotted;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.atlas.lib.CacheSet;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.Hex;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.lib.Timer;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.dboe.base.file.BinaryDataFile;
import org.apache.jena.dboe.base.file.BufferChannel;
import org.apache.jena.dboe.base.file.FileFactory;
import org.apache.jena.dboe.base.file.FileSet;
import org.apache.jena.dboe.base.record.Record;
import org.apache.jena.dboe.base.record.RecordFactory;
import org.apache.jena.dboe.trans.bplustree.BPlusTree;
import org.apache.jena.dboe.trans.bplustree.BPlusTreeParams;
import org.apache.jena.dboe.trans.bplustree.rewriter.BPlusTreeRewriter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.irix.IRIProvider;
import org.apache.jena.irix.SystemIRIx;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.thrift.RiotThriftException;
import org.apache.jena.riot.thrift.TRDF;
import org.apache.jena.riot.thrift.ThriftConvert;
import org.apache.jena.riot.thrift.wire.RDF_Term;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.system.progress.ProgressIterator;
import org.apache.jena.system.progress.ProgressMonitorOutput;
import org.apache.jena.system.progress.ProgressStreamRDF;
import org.apache.jena.tdb2.DatabaseMgr;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.lib.NodeLib;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.store.Hash;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.NodeIdFactory;
import org.apache.jena.tdb2.store.nodetable.NodeTable;
import org.apache.jena.tdb2.store.nodetable.NodeTableTRDF;
import org.apache.jena.tdb2.store.nodetable.TReadAppendFileTransport;
import org.apache.jena.tdb2.sys.TDBInternal;
import org.apache.jena.tdb2.xloader.BulkLoaderX;
import org.apache.jena.tdb2.xloader.XLoaderFiles;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcBuildNodeTableX {
    private static Logger LOG1 = LoggerFactory.getLogger("Nodes");
    private static Logger LOG2 = LoggerFactory.getLogger("Terms");
    private static Hash hash = new Hash(16);

    public static void exec(String location, XLoaderFiles loaderFiles, int sortThreads, String sortNodeTableArgs, List<String> datafiles) {
        Timer timer = new Timer();
        timer.startTimer();
        FmtLog.info(LOG1, "Build node table", new Object[0]);
        Pair<Long, Long> buildCounts = ProcBuildNodeTableX.exec2(location, loaderFiles, sortThreads, sortNodeTableArgs, datafiles);
        long timeMillis = timer.endTimer();
        long items = buildCounts.getLeft();
        double xSec = (double)timeMillis / 1000.0;
        double rate = (double)items / xSec;
        String elapsedStr = BulkLoaderX.milliToHMS(timeMillis);
        String rateStr = BulkLoaderX.rateStr(items, timeMillis);
        FmtLog.info(LOG2, "%s NodeTable : %s seconds - %s at %s terms per second", "==-==-==", Timer.timeStr(timeMillis), elapsedStr, rateStr);
    }

    private static Pair<Long, Long> exec2(String DB, XLoaderFiles loaderFiles, int sortThreads, String sortNodeTableArgs, List<String> datafiles) {
        InputStream fromSortInputStream;
        OutputStream toSortOutputStream;
        Process proc2;
        IRIProvider provider = SystemIRIx.getProvider();
        DatasetGraph dsg = DatabaseMgr.connectDatasetGraph(DB);
        DatasetGraphTDB dsgtdb = TDBInternal.getDatasetGraphTDB(dsg);
        NodeTable nt = dsgtdb.getTripleTable().getNodeTupleTable().getNodeTable();
        NodeTableTRDF nodeTable = (NodeTableTRDF)nt.baseNodeTable();
        if (sortThreads <= 0) {
            sortThreads = 2;
        }
        try {
            ArrayList<String> sortCmd = new ArrayList<String>(Arrays.asList("sort", "--temporary-directory=" + loaderFiles.TMPDIR, "--buffer-size=50%", "--parallel=" + sortThreads, "--unique", "--key=1,1"));
            if (BulkLoaderX.CompressSortNodeTableFiles) {
                sortCmd.add("--compress-program=" + BulkLoaderX.gzipProgram());
            }
            ProcessBuilder pb2 = new ProcessBuilder(sortCmd);
            pb2.environment().put("LC_ALL", "C");
            proc2 = pb2.start();
            toSortOutputStream = proc2.getOutputStream();
            fromSortInputStream = proc2.getInputStream();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        AtomicLong countParseTicks = new AtomicLong(-1L);
        AtomicLong countIndexedNodes = new AtomicLong(-1L);
        long tickPoint = BulkLoaderX.DataTick;
        int superTick = BulkLoaderX.DataSuperTick;
        Runnable task1 = () -> {
            ProgressMonitorOutput monitor = ProgressMonitorOutput.create(LOG1, "Nodes", tickPoint, superTick);
            OutputStream output = IO.ensureBuffered(toSortOutputStream);
            NodeHashTmpStream worker = new NodeHashTmpStream(output);
            ProgressStreamRDF stream = new ProgressStreamRDF(worker, monitor);
            monitor.start();
            String label = monitor.getLabel();
            datafiles.forEach(datafile -> {
                String basename = FileOps.basename(datafile);
                monitor.setLabel(basename);
                stream.start();
                RDFParser.source(datafile).parse(stream);
                stream.finish();
            });
            monitor.finish();
            monitor.setLabel(label);
            IO.flush(output);
            IO.close(output);
            long x = monitor.getTime();
            long count = monitor.getTicks();
            countParseTicks.set(count);
            double xSec = (double)x / 1000.0;
            double rate = (double)count / xSec;
            FmtLog.info(LOG1, "%s Parse (nodes): %s seconds : %,d triples/quads %,.0f TPS", "==", Timer.timeStr(x), count, rate);
        };
        Thread thread1 = BulkLoaderX.async(task1, "AsyncParser");
        Runnable task3 = () -> {
            Timer timer = new Timer();
            InputStream input = IO.ensureBuffered(fromSortInputStream);
            FileSet fileSet = new FileSet(dsgtdb.getLocation(), "nodes");
            BufferChannel blkState = FileFactory.createBufferChannel(fileSet, "bpt");
            long idxTickPoint = BulkLoaderX.DataTick;
            int idxSuperTick = BulkLoaderX.DataSuperTick;
            ProgressMonitorOutput monitor = ProgressMonitorOutput.create(LOG2, "Index", idxTickPoint, idxSuperTick);
            dsg.executeWrite(() -> {
                BinaryDataFile objectFile = nodeTable.getData();
                Iterator<Record> rIter = ProcBuildNodeTableX.records(LOG2, input, objectFile);
                rIter = new ProgressIterator<Record>(rIter, monitor);
                BPlusTree bpt1 = (BPlusTree)nodeTable.getIndex();
                BPlusTreeParams bptParams = bpt1.getParams();
                RecordFactory factory = new RecordFactory(16, 8);
                rIter.hasNext();
                monitor.start();
                timer.startTimer();
                BPlusTree bpt2 = BPlusTreeRewriter.packIntoBPlusTree(rIter, bptParams, factory, blkState, bpt1.getNodeManager().getBlockMgr(), bpt1.getRecordsMgr().getBlockMgr());
                bpt2.sync();
                bpt1.sync();
                objectFile.sync();
                monitor.finish();
            });
            blkState.sync();
            IO.close(input);
            long x = timer.endTimer();
            long count = monitor.getTicks();
            countIndexedNodes.set(count);
            String rateStr = BulkLoaderX.rateStr(count, x);
            FmtLog.info(LOG2, "%s Index terms: %s seconds : %,d indexed RDF terms : %s PerSecond", "==", Timer.timeStr(x), count, rateStr);
        };
        Thread thread3 = BulkLoaderX.async(task3, "AsyncBuild");
        try {
            int exitCode = proc2.waitFor();
            if (exitCode != 0) {
                String msg = IO.readWholeFileAsUTF8(proc2.getErrorStream());
                String logMsg = String.format("Sort RC = %d : Error: %s", exitCode, msg);
                Log.error(LOG2, logMsg);
                System.exit(exitCode);
            } else {
                LOG2.info("Sort finished");
            }
        }
        catch (InterruptedException e2) {
            LOG1.error("Failed to cleanly wait-for the subprocess");
            throw new RuntimeException(e2);
        }
        finally {
            IO.close(toSortOutputStream);
            IO.close(fromSortInputStream);
        }
        BulkLoaderX.waitFor(thread1);
        BulkLoaderX.waitFor(thread3);
        return Pair.create(countParseTicks.get(), countIndexedNodes.get());
    }

    static Iterator<Record> records(Logger LOG, final InputStream input, final BinaryDataFile objectFile) {
        final RecordFactory factory = new RecordFactory(16, 8);
        final byte[] bHash = new byte[16];
        final byte[] bbNodeId = new byte[8];
        final RDF_Term term = new RDF_Term();
        try {
            TReadAppendFileTransport transport = new TReadAppendFileTransport(objectFile);
            if (!((TTransport)transport).isOpen()) {
                ((TTransport)transport).open();
            }
            TProtocol protocol = TRDF.protocol(transport);
        }
        catch (Exception ex) {
            throw new TDBException("NodeTableTRDF", ex);
        }
        return new IteratorSlotted<Record>(){
            long count = 0L;

            @Override
            protected Record moveToNext() {
                return this.calc();
            }

            @Override
            protected boolean hasMore() {
                return true;
            }

            private Record calc() {
                ++this.count;
                try {
                    int v;
                    for (int i = 0; i < 16; ++i) {
                        int x = ProcBuildNodeTableX.hexRead(input);
                        if (x < 0) {
                            return null;
                        }
                        bHash[i] = (byte)(x & 0xFF);
                    }
                    char ch0 = (char)input.read();
                    byte[] key = bHash;
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    while ((v = ProcBuildNodeTableX.hexRead(input)) >= 0) {
                        bout.write(v);
                    }
                    byte[] thrift = bout.toByteArray();
                    ThriftConvert.termFromBytes(term, thrift);
                    long x = objectFile.length();
                    NodeId nodeId = NodeIdFactory.createPtr(x);
                    objectFile.write(thrift);
                    Bytes.setLong(nodeId.getPtrLocation(), bbNodeId);
                    Record r = factory.create(key, bbNodeId);
                    return r;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
        };
    }

    public static int hexRead(InputStream input) throws IOException {
        int c1 = input.read();
        if (c1 < 0) {
            return -1;
        }
        if (c1 == 10 || c1 == 32) {
            return -1;
        }
        int c2 = input.read();
        int b1 = Hex.hexByteToInt(c1);
        int b2 = Hex.hexByteToInt(c2);
        int b = b1 << 4 | b2;
        return b;
    }

    public static void hexWrite(OutputStream output, int bits8) throws IOException {
        int x1 = bits8 >> 4 & 0xF;
        int x2 = bits8 & 0xF;
        byte ch1 = Bytes.hexDigitsUC[x1];
        byte ch2 = Bytes.hexDigitsUC[x2];
        output.write(ch1);
        output.write(ch2);
    }

    static byte[] hashNode(Node node) {
        NodeLib.setHash(hash, node);
        return hash.getBytes();
    }

    static class NodeHashTmpStream
    implements StreamRDF {
        private final OutputStream outputData;
        private CacheSet<Node> cache = CacheFactory.createCacheSet(500000);
        static TSerializer serializer;

        NodeHashTmpStream(OutputStream outputFile) {
            this.outputData = outputFile;
        }

        @Override
        public void start() {
        }

        @Override
        public void triple(Triple triple) {
            this.node(triple.getSubject());
            this.node(triple.getPredicate());
            this.node(triple.getObject());
        }

        @Override
        public void quad(Quad quad) {
            this.node(quad.getGraph());
            this.node(quad.getSubject());
            this.node(quad.getPredicate());
            this.node(quad.getObject());
        }

        private void node(Node node) {
            NodeId nid = NodeId.inline(node);
            if (nid != null) {
                return;
            }
            if (this.cache.contains(node)) {
                return;
            }
            this.cache.add(node);
            NodeLib.setHash(hash, node);
            try {
                byte[] k = hash.getBytes();
                RDF_Term term = ThriftConvert.convert(node, false);
                byte[] tBytes = serializer.serialize(term);
                NodeHashTmpStream.write(this.outputData, k);
                this.outputData.write(32);
                NodeHashTmpStream.write(this.outputData, tBytes);
                this.outputData.write(10);
            }
            catch (TException e2) {
                e2.printStackTrace();
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }

        private static void write(OutputStream outputData, byte[] bytes) throws IOException {
            for (byte bits8 : bytes) {
                ProcBuildNodeTableX.hexWrite(outputData, bits8);
            }
        }

        @Override
        public void base(String base) {
        }

        @Override
        public void prefix(String prefix, String iri2) {
        }

        @Override
        public void finish() {
            IO.flush(this.outputData);
        }

        static {
            try {
                serializer = new TSerializer(new TCompactProtocol.Factory());
            }
            catch (TException e2) {
                throw new RiotThriftException(e2);
            }
        }
    }
}

