/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.ItemTransform;
import org.apache.jena.sparql.sse.ItemVisitor;

public class ItemTransformer {
    public static Item transform(ItemTransform transform, Item item) {
        TransformerApply v = new TransformerApply(transform);
        item.visit(v);
        return v.result();
    }

    static class TransformerApply
    implements ItemVisitor {
        Deque<Item> stack = new ArrayDeque<Item>();
        private ItemTransform transform;

        private void push(Item item, Item newItem) {
            if (item == newItem) {
                this.stack.push(item);
            } else {
                this.stack.push(newItem);
            }
        }

        private Item pop() {
            return this.stack.pop();
        }

        TransformerApply(ItemTransform transform) {
            this.transform = transform;
        }

        Item result() {
            return this.stack.peek();
        }

        @Override
        public void visit(Item item, ItemList list) {
            Item newItemList;
            ItemList newList = new ItemList(item.getLine(), item.getColumn());
            boolean hasNewItems = false;
            for (Item subItem : list) {
                subItem.visit(this);
                Item newItem = this.pop();
                newList.add(newItem);
                if (newItem == subItem) continue;
                hasNewItems = true;
            }
            if (!hasNewItems) {
                newList = list;
                newItemList = item;
            } else {
                newItemList = Item.createList(newList, item.getLine(), item.getColumn());
            }
            Item newItem = this.transform.transform(newItemList, newList);
            this.push(item, newItem);
        }

        @Override
        public void visit(Item item, Node node) {
            Item newItem = this.transform.transform(item, node);
            this.push(item, newItem);
        }

        @Override
        public void visit(Item item, String symbol) {
            Item newItem = this.transform.transform(item, symbol);
            this.push(item, newItem);
        }

        @Override
        public void visitNil(Item item) {
            Item newItem = this.transform.transformNil(item);
            this.push(item, newItem);
        }
    }
}

