/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import org.apache.jena.shex.ShexException;

public enum NumRangeKind {
    MININCLUSIVE("MinInclusive"),
    MINEXCLUSIVE("MinExclusive"),
    MAXINCLUSIVE("MaxInclusive"),
    MAXEXCLUSIVE("MaxExclusive");

    private final String label;

    private NumRangeKind(String string2) {
        this.label = string2;
    }

    public static NumRangeKind create(String strlength) {
        switch (strlength.toLowerCase()) {
            case "mininclusive": {
                return MININCLUSIVE;
            }
            case "minexclusive": {
                return MINEXCLUSIVE;
            }
            case "maxinclusive": {
                return MAXINCLUSIVE;
            }
            case "maxexclusive": {
                return MAXEXCLUSIVE;
            }
        }
        throw new ShexException("NumRangeKind not recognized: '" + strlength + "'");
    }

    public String label() {
        return this.label;
    }

    public String toString() {
        return this.label;
    }
}

