/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.validation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.other.G;
import org.apache.jena.shacl.engine.ShaclPaths;
import org.apache.jena.shacl.engine.Target;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.NodeShape;
import org.apache.jena.shacl.parser.PropertyShape;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.sparql.path.Path;

public class VLib {
    private static IndentedWriter out = IndentedWriter.clone(IndentedWriter.stdout);

    public static void validateShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode) {
        Set<Node> vNodes;
        Path path;
        if (shape.deactivated()) {
            return;
        }
        if (vCxt.isVerbose()) {
            out.println("S: " + shape);
        }
        if (shape instanceof NodeShape) {
            path = null;
            vNodes = null;
        } else if (shape instanceof PropertyShape) {
            PropertyShape propertyShape = (PropertyShape)shape;
            path = propertyShape.getPath();
            vNodes = ShaclPaths.valueNodes(data, focusNode, propertyShape.getPath());
        } else {
            if (vCxt.isVerbose()) {
                out.println("Z: " + shape);
            }
            return;
        }
        for (Constraint c : shape.getConstraints()) {
            if (vCxt.isVerbose()) {
                out.println("C: " + c);
            }
            VLib.evalConstraint(vCxt, data, shape, focusNode, path, vNodes, c);
        }
        VLib.validationPropertyShapes(vCxt, data, shape.getPropertyShapes(), focusNode);
        if (vCxt.isVerbose()) {
            out.println();
        }
    }

    static void validationPropertyShapes(ValidationContext vCxt, Graph data, Collection<PropertyShape> propertyShapes, Node focusNode) {
        if (propertyShapes == null) {
            return;
        }
        for (PropertyShape propertyShape : propertyShapes) {
            VLib.validationPropertyShape(vCxt, data, propertyShape, focusNode);
        }
    }

    private static void validationPropertyShape(ValidationContext vCxt, Graph data, PropertyShape propertyShape, Node focusNode) {
        if (propertyShape.deactivated()) {
            return;
        }
        if (vCxt.isVerbose()) {
            out.println("P: " + propertyShape);
        }
        Path path = propertyShape.getPath();
        Set<Node> vNodes = ShaclPaths.valueNodes(data, focusNode, path);
        for (Constraint c : propertyShape.getConstraints()) {
            if (vCxt.isVerbose()) {
                out.println("C: " + focusNode + " :: " + c);
            }
            VLib.evalConstraint(vCxt, data, propertyShape, focusNode, path, vNodes, c);
        }
        vNodes.forEach(vNode -> VLib.validationPropertyShapes(vCxt, data, propertyShape.getPropertyShapes(), vNode));
    }

    public static Collection<Node> focusNodes(Graph data, Shape shape) {
        HashSet<Node> acc = new HashSet<Node>();
        shape.getTargets().forEach(target -> acc.addAll(VLib.focusNodes(data, target)));
        return acc;
    }

    public static Collection<Node> focusNodes(Graph data, Target target) {
        return target.getFocusNodes(data);
    }

    public static boolean isFocusNode(Shape shape, Node node, Graph data) {
        return shape.getTargets().stream().anyMatch(target -> VLib.isFocusNode(target, node, data));
    }

    public static boolean isFocusNode(Target target, Node node, Graph data) {
        Node targetObject = target.getObject();
        switch (target.getTargetType()) {
            case targetClass: 
            case implicitClass: {
                return G.isOfType(data, node, targetObject);
            }
            case targetNode: {
                return targetObject.equals(node);
            }
            case targetObjectsOf: {
                return data.contains(null, targetObject, node);
            }
            case targetSubjectsOf: {
                return data.contains(node, targetObject, null);
            }
            case targetExtension: {
                VLib.focusNodes(data, target).contains(node);
            }
        }
        return false;
    }

    public static void evalConstraint(ValidationContext vCxt, Graph data, Shape shape, Node focusNode, Path path, Set<Node> pathNodes, Constraint c) {
        if (path == null) {
            if (pathNodes != null) {
                throw new InternalErrorException("Path is null but pathNodes is not null");
            }
            c.validateNodeShape(vCxt, data, shape, focusNode);
            return;
        }
        if (pathNodes == null) {
            throw new InternalErrorException("Path is not null but pathNodes is null");
        }
        c.validatePropertyShape(vCxt, data, shape, focusNode, path, pathNodes);
    }
}

