/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.riot.system.PrefixEntry;
import org.apache.jena.riot.system.PrefixLib;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.Prefixes;
import org.apache.jena.shared.PrefixMapping;

public abstract class PrefixMapBase
implements PrefixMap {
    protected PrefixMapBase() {
    }

    protected boolean strSafeFor(String str2, char ch) {
        return str2.indexOf(ch) == -1;
    }

    @Override
    public Map<String, String> getMappingCopy() {
        return new HashMap<String, String>(this.getMapping());
    }

    @Override
    public void forEach(BiConsumer<String, String> action) {
        this.getMapping().forEach(action);
    }

    private Iterator<PrefixEntry> iterator() {
        return Iter.iter(this.getMapping().entrySet()).map(e2 -> PrefixEntry.create((String)e2.getKey(), (String)e2.getValue()));
    }

    @Override
    public Stream<PrefixEntry> stream() {
        return this.getMapping().entrySet().stream().map(e2 -> PrefixEntry.create((String)e2.getKey(), (String)e2.getValue()));
    }

    @Override
    public void putAll(PrefixMap pmap) {
        pmap.getMapping().forEach(this::add);
    }

    @Override
    public void putAll(PrefixMapping pmap) {
        this.putAll(pmap.getNsPrefixMap());
    }

    @Override
    public void putAll(Map<String, String> mapping) {
        mapping.forEach(this::add);
    }

    @Override
    public String abbreviate(String uriStr) {
        Objects.requireNonNull(uriStr);
        Pair<String, String> p = this.abbrev(uriStr);
        if (p == null) {
            return null;
        }
        return p.getLeft() + ":" + p.getRight();
    }

    @Override
    public String expand(String prefix, String localName) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(localName);
        return PrefixLib.expand(this, prefix, localName);
    }

    @Override
    public Pair<String, String> abbrev(String uriStr) {
        return PrefixLib.abbrev(this, uriStr);
    }

    protected Pair<String, String> abbrev(Map<String, String> prefixesMap, String uriStr, boolean turtleSafeLocalPart) {
        return PrefixLib.abbrev(prefixesMap, uriStr, turtleSafeLocalPart);
    }

    @Override
    public String expand(String prefixedName) {
        Objects.requireNonNull(prefixedName);
        return PrefixLib.expand(this, prefixedName);
    }

    public String toString() {
        return Prefixes.toString(this);
    }
}

