/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.jena.atlas.lib.Registry;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.metrics.FusekiRequestsMetrics;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.Operation;

public class DataAccessPointRegistry
extends Registry<String, DataAccessPoint> {
    private MeterRegistry meterRegistry;

    public DataAccessPointRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public DataAccessPointRegistry(DataAccessPointRegistry other) {
        other.forEach((name, accessPoint) -> this.register((String)name, (DataAccessPoint)accessPoint));
        this.meterRegistry = other.meterRegistry;
    }

    public void register(DataAccessPoint accessPt) {
        this.register(accessPt.getName(), accessPt);
    }

    private void register(String name, DataAccessPoint accessPt) {
        if (this.isRegistered(name)) {
            throw new FusekiException("Already registered: " + name);
        }
        super.put(name, accessPt);
        if (this.meterRegistry != null) {
            new FusekiRequestsMetrics(accessPt).bindTo(this.meterRegistry);
        }
    }

    public List<DataAccessPoint> accessPoints() {
        ArrayList<DataAccessPoint> accessPoints = new ArrayList<DataAccessPoint>(this.size());
        this.forEach((_name, accessPoint) -> accessPoints.add((DataAccessPoint)accessPoint));
        return accessPoints;
    }

    @Override
    @Deprecated
    public void put(String accessPointName, DataAccessPoint dap) {
        this.register(dap);
    }

    @Override
    public DataAccessPoint get(String key) {
        return (DataAccessPoint)super.get(key);
    }

    public void print() {
        this.print(null);
    }

    public void print(String string) {
        System.out.flush();
        if (string == null) {
            string = "DataAccessPointRegistry";
        }
        System.out.println("== " + string);
        this.forEach((k, ref) -> {
            System.out.printf("  (key=%s, ref=%s)\n", k, ref.getName());
            ref.getDataService().getOperations().forEach((? super T op) -> ref.getDataService().getEndpoints((Operation)op).forEach((? super T ep) -> System.out.printf("    %-10s @ \"%s\"\n", op, ep.getName())));
        });
    }

    public static DataAccessPointRegistry get(ServletContext cxt) {
        DataAccessPointRegistry registry = (DataAccessPointRegistry)cxt.getAttribute("org.apache.jena.fuseki:DataAccessPointRegistry");
        if (registry == null) {
            Log.warn(DataAccessPointRegistry.class, "No data access point registry for ServletContext");
        }
        return registry;
    }

    public static void set(ServletContext cxt, DataAccessPointRegistry registry) {
        cxt.setAttribute("org.apache.jena.fuseki:DataAccessPointRegistry", registry);
    }
}

