/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.shex.expressions.NodeConstraint;
import org.apache.jena.shex.expressions.ShapeExprVisitor;
import org.apache.jena.shex.expressions.StrLengthKind;
import org.apache.jena.shex.sys.ReportItem;
import org.apache.jena.shex.sys.ShexLib;
import org.apache.jena.shex.sys.ValidationContext;
import org.apache.jena.sparql.expr.nodevalue.NodeFunctions;

public class StrLengthConstraint
extends NodeConstraint {
    private final StrLengthKind lengthType;
    private final int length;

    public static StrLengthConstraint create(StrLengthKind lengthType, int len) {
        return new StrLengthConstraint(lengthType, len);
    }

    private StrLengthConstraint(StrLengthKind lengthType, int len) {
        Objects.requireNonNull(lengthType);
        this.lengthType = lengthType;
        this.length = len;
    }

    public StrLengthKind getLengthType() {
        return this.lengthType;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public ReportItem nodeSatisfies(ValidationContext vCxt, Node n) {
        if (!n.isLiteral() && !n.isURI()) {
            String msg = String.format("%s: Not a literal or URI: %s", this.lengthType.label(), ShexLib.displayStr(n));
            return new ReportItem(msg, n);
        }
        String str2 = NodeFunctions.str(n);
        switch (this.lengthType) {
            case LENGTH: {
                if (str2.length() != this.length) break;
                return null;
            }
            case MAXLENGTH: {
                if (str2.length() > this.length) break;
                return null;
            }
            case MINLENGTH: {
                if (str2.length() < this.length) break;
                return null;
            }
        }
        String msg = String.format("Expected %s %d : got = %d", this.lengthType.label(), this.length, str2.length());
        return new ReportItem(msg, n);
    }

    @Override
    public void visit(ShapeExprVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return "StrLength[" + this.lengthType.label() + " " + this.length + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.length, this.lengthType});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StrLengthConstraint other = (StrLengthConstraint)obj;
        return this.length == other.length && this.lengthType == other.lengthType;
    }
}

