/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shex.ShexShape;
import org.apache.jena.shex.expressions.ShapeExprVisitor;
import org.apache.jena.shex.expressions.ShapeExpression;
import org.apache.jena.shex.sys.ShexLib;
import org.apache.jena.shex.sys.ValidationContext;

public class ShapeExprRef
extends ShapeExpression {
    private final Node ref;

    public ShapeExprRef(Node ref) {
        this.ref = ref;
    }

    @Override
    public boolean satisfies(ValidationContext vCxt, Node data) {
        ShexShape shape = vCxt.getShape(this.ref);
        if (shape == null) {
            return false;
        }
        if (vCxt.cycle(shape, data)) {
            return true;
        }
        return shape.satisfies(vCxt, data);
    }

    @Override
    public void print(IndentedWriter out, NodeFormatter nFmt) {
        out.print("ShapeRef: ");
        out.print(ShexLib.displayStr(this.ref));
        out.println();
    }

    @Override
    public void visit(ShapeExprVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return "ShapeExprRef [ref=" + this.ref + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ref);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShapeExprRef other = (ShapeExprRef)obj;
        return Objects.equals(this.ref, other.ref);
    }
}

