/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexSorter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortFieldProvider;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.comparators.DoubleComparator;
import org.apache.lucene.search.comparators.FloatComparator;
import org.apache.lucene.search.comparators.IntComparator;
import org.apache.lucene.search.comparators.LongComparator;
import org.apache.lucene.search.comparators.NumericComparator;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.NumericUtils;

public class SortedNumericSortField
extends SortField {
    private final SortedNumericSelector.Type selector;
    private final SortField.Type type;

    public SortedNumericSortField(String field, SortField.Type type) {
        this(field, type, false);
    }

    public SortedNumericSortField(String field, SortField.Type type, boolean reverse) {
        this(field, type, reverse, SortedNumericSelector.Type.MIN);
    }

    public SortedNumericSortField(String field, SortField.Type type, boolean reverse, SortedNumericSelector.Type selector) {
        super(field, SortField.Type.CUSTOM, reverse);
        if (selector == null) {
            throw new NullPointerException();
        }
        if (type == null) {
            throw new NullPointerException();
        }
        this.selector = selector;
        this.type = type;
    }

    private static SortedNumericSelector.Type readSelectorType(DataInput in) throws IOException {
        int selectorType = in.readInt();
        if (selectorType >= SortedNumericSelector.Type.values().length) {
            throw new IllegalArgumentException("Can't deserialize SortedNumericSortField - unknown selector type " + selectorType);
        }
        return SortedNumericSelector.Type.values()[selectorType];
    }

    private void serialize(DataOutput out) throws IOException {
        out.writeString(this.getField());
        out.writeString(this.type.toString());
        out.writeInt(this.reverse ? 1 : 0);
        out.writeInt(this.selector.ordinal());
        if (this.missingValue == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            switch (this.type) {
                case INT: {
                    out.writeInt((Integer)this.missingValue);
                    break;
                }
                case LONG: {
                    out.writeLong((Long)this.missingValue);
                    break;
                }
                case FLOAT: {
                    out.writeInt(NumericUtils.floatToSortableInt(((Float)this.missingValue).floatValue()));
                    break;
                }
                case DOUBLE: {
                    out.writeLong(NumericUtils.doubleToSortableLong((Double)this.missingValue));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    public SortField.Type getNumericType() {
        return this.type;
    }

    public SortedNumericSelector.Type getSelector() {
        return this.selector;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.selector.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SortedNumericSortField other = (SortedNumericSortField)obj;
        if (this.selector != other.selector) {
            return false;
        }
        return this.type == other.type;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<sortednumeric: \"").append(this.getField()).append("\">");
        if (this.getReverse()) {
            buffer.append('!');
        }
        if (this.missingValue != null) {
            buffer.append(" missingValue=");
            buffer.append(this.missingValue);
        }
        buffer.append(" selector=");
        buffer.append((Object)this.selector);
        buffer.append(" type=");
        buffer.append((Object)this.type);
        return buffer.toString();
    }

    @Override
    public void setMissingValue(Object missingValue) {
        this.missingValue = missingValue;
    }

    @Override
    public FieldComparator<?> getComparator(int numHits, int sortPos) {
        NumericComparator fieldComparator;
        switch (this.type) {
            case INT: {
                fieldComparator = new IntComparator(numHits, this.getField(), (Integer)this.missingValue, this.reverse, sortPos){

                    @Override
                    public LeafFieldComparator getLeafComparator(LeafReaderContext context2) throws IOException {
                        return new IntComparator.IntLeafComparator(context2){

                            @Override
                            protected NumericDocValues getNumericDocValues(LeafReaderContext context2, String field) throws IOException {
                                return SortedNumericSelector.wrap(DocValues.getSortedNumeric(context2.reader(), field), SortedNumericSortField.this.selector, SortedNumericSortField.this.type);
                            }
                        };
                    }
                };
                break;
            }
            case FLOAT: {
                fieldComparator = new FloatComparator(numHits, this.getField(), (Float)this.missingValue, this.reverse, sortPos){

                    @Override
                    public LeafFieldComparator getLeafComparator(LeafReaderContext context2) throws IOException {
                        return new FloatComparator.FloatLeafComparator(context2){

                            @Override
                            protected NumericDocValues getNumericDocValues(LeafReaderContext context2, String field) throws IOException {
                                return SortedNumericSelector.wrap(DocValues.getSortedNumeric(context2.reader(), field), SortedNumericSortField.this.selector, SortedNumericSortField.this.type);
                            }
                        };
                    }
                };
                break;
            }
            case LONG: {
                fieldComparator = new LongComparator(numHits, this.getField(), (Long)this.missingValue, this.reverse, sortPos){

                    @Override
                    public LeafFieldComparator getLeafComparator(LeafReaderContext context2) throws IOException {
                        return new LongComparator.LongLeafComparator(context2){

                            @Override
                            protected NumericDocValues getNumericDocValues(LeafReaderContext context2, String field) throws IOException {
                                return SortedNumericSelector.wrap(DocValues.getSortedNumeric(context2.reader(), field), SortedNumericSortField.this.selector, SortedNumericSortField.this.type);
                            }
                        };
                    }
                };
                break;
            }
            case DOUBLE: {
                fieldComparator = new DoubleComparator(numHits, this.getField(), (Double)this.missingValue, this.reverse, sortPos){

                    @Override
                    public LeafFieldComparator getLeafComparator(LeafReaderContext context2) throws IOException {
                        return new DoubleComparator.DoubleLeafComparator(context2){

                            @Override
                            protected NumericDocValues getNumericDocValues(LeafReaderContext context2, String field) throws IOException {
                                return SortedNumericSelector.wrap(DocValues.getSortedNumeric(context2.reader(), field), SortedNumericSortField.this.selector, SortedNumericSortField.this.type);
                            }
                        };
                    }
                };
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (!this.getCanUsePoints()) {
            ((FieldComparator)fieldComparator).disableSkipping();
        }
        return fieldComparator;
    }

    private NumericDocValues getValue(LeafReader reader) throws IOException {
        return SortedNumericSelector.wrap(DocValues.getSortedNumeric(reader, this.getField()), this.selector, this.type);
    }

    @Override
    public IndexSorter getIndexSorter() {
        switch (this.type) {
            case INT: {
                return new IndexSorter.IntSorter("SortedNumericSortField", (Integer)this.missingValue, this.reverse, this::getValue);
            }
            case LONG: {
                return new IndexSorter.LongSorter("SortedNumericSortField", (Long)this.missingValue, this.reverse, this::getValue);
            }
            case DOUBLE: {
                return new IndexSorter.DoubleSorter("SortedNumericSortField", (Double)this.missingValue, this.reverse, this::getValue);
            }
            case FLOAT: {
                return new IndexSorter.FloatSorter("SortedNumericSortField", (Float)this.missingValue, this.reverse, this::getValue);
            }
        }
        throw new AssertionError();
    }

    public static final class Provider
    extends SortFieldProvider {
        public static final String NAME = "SortedNumericSortField";

        public Provider() {
            super(NAME);
        }

        @Override
        public SortField readSortField(DataInput in) throws IOException {
            SortedNumericSortField sf = new SortedNumericSortField(in.readString(), SortField.readType(in), in.readInt() == 1, SortedNumericSortField.readSelectorType(in));
            if (in.readInt() == 1) {
                switch (sf.type) {
                    case INT: {
                        sf.setMissingValue(in.readInt());
                        break;
                    }
                    case LONG: {
                        sf.setMissingValue(in.readLong());
                        break;
                    }
                    case FLOAT: {
                        sf.setMissingValue(Float.valueOf(NumericUtils.sortableIntToFloat(in.readInt())));
                        break;
                    }
                    case DOUBLE: {
                        sf.setMissingValue(NumericUtils.sortableLongToDouble(in.readLong()));
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            return sf;
        }

        @Override
        public void writeSortField(SortField sf, DataOutput out) throws IOException {
            assert (sf instanceof SortedNumericSortField);
            ((SortedNumericSortField)sf).serialize(out);
        }
    }
}

