/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.web;

import org.apache.http.auth.AuthScope;

public class AuthSetup {
    public final String host;
    public final int port;
    public final String user;
    public final String password;
    public final String realm;

    public AuthSetup(String host, Integer port, String user, String password, String realm) {
        this.host = this.any(host, AuthScope.ANY_HOST);
        this.port = port == null || port <= 0 ? -1 : port;
        this.user = user;
        this.password = password;
        this.realm = this.any(host, AuthScope.ANY_REALM);
    }

    public AuthScope authScope() {
        return new AuthScope(this.host, this.port, this.realm, AuthScope.ANY_SCHEME);
    }

    private <X> X any(X value, X anyVal) {
        if (value == null) {
            return anyVal;
        }
        return value;
    }

    public String toString() {
        return "AuthSetup [host=" + this.host + ", port=" + this.port + ", user=" + this.user + ", password=......, realm=" + this.realm + "]";
    }
}

