/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.transaction;

import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphWrapper;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.tdb.StoreConnection;
import org.apache.jena.tdb.TDB;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.store.DatasetGraphTDB;
import org.apache.jena.tdb.store.GraphTxnTDB;
import org.apache.jena.tdb.store.PrefixMapTDB1;
import org.apache.jena.tdb.transaction.DatasetGraphTxn;
import org.apache.jena.tdb.transaction.TDBTransactionException;
import org.apache.jena.tdb.transaction.Transaction;

public class DatasetGraphTransaction
extends DatasetGraphWrapper
implements Sync {
    private ThreadLocal<DatasetGraphTxn> dsgtxn = ThreadLocal.withInitial(() -> null);
    private ThreadLocal<Boolean> inTransaction = ThreadLocal.withInitial(() -> false);
    private final StoreConnection sConn;
    private boolean isClosed = false;
    private final PrefixMap prefixes;

    public DatasetGraphTransaction(Location location) {
        this(StoreConnection.make(location));
    }

    public DatasetGraphTransaction(StoreConnection sConn) {
        super(null);
        this.sConn = sConn;
        this.prefixes = new PrefixMapTDB1(this, () -> this.get());
    }

    public Location getLocation() {
        return this.sConn.getLocation();
    }

    public DatasetGraphTDB getDatasetGraphToQuery() {
        this.checkNotClosed();
        return this.get();
    }

    public DatasetGraphTDB getBaseDatasetGraph() {
        this.checkNotClosed();
        return this.sConn.getBaseDataset();
    }

    public void requireWrite() {
        if (!this.isInTransaction()) {
            return;
        }
        DatasetGraphTxn dsgTxn = this.dsgtxn.get();
        if (dsgTxn.getTransaction().isRead()) {
            Transactional.Promote promoteMode;
            TxnType txnType = dsgTxn.getTransaction().getTxnType();
            switch (txnType) {
                case READ: {
                    throw new JenaTransactionException("Attempt to update in a read transaction");
                }
                case WRITE: {
                    throw new TDBException("Internal inconsistency: read-mode write transaction");
                }
                case READ_PROMOTE: {
                    promoteMode = Transactional.Promote.ISOLATED;
                    break;
                }
                case READ_COMMITTED_PROMOTE: {
                    promoteMode = Transactional.Promote.READ_COMMITTED;
                    break;
                }
                default: {
                    throw new TDBException("Internal inconsistency: null transaction type");
                }
            }
            boolean b = this.promoteStep(dsgTxn, promoteMode);
            if (!b) {
                throw new JenaTransactionException("Can't promote " + txnType + "- dataset has been written to");
            }
        }
    }

    @Override
    public DatasetGraph getW() {
        this.requireWrite();
        return super.getW();
    }

    @Override
    protected DatasetGraphTDB get() {
        if (this.isInTransaction()) {
            DatasetGraphTxn dsgTxn = this.dsgtxn.get();
            if (dsgTxn == null) {
                throw new TDBTransactionException("In a transaction but no transactional DatasetGraph");
            }
            return dsgTxn.getView();
        }
        if (this.sConn.haveUsedInTransaction()) {
            throw new TDBTransactionException("Not in a transaction");
        }
        return this.sConn.getBaseDataset();
    }

    @Override
    public Graph getDefaultGraph() {
        return new GraphTxnTDB(this, null);
    }

    @Override
    public Graph getUnionGraph() {
        return this.getGraph(Quad.unionGraph);
    }

    @Override
    public Graph getGraph(Node graphNode) {
        return new GraphTxnTDB(this, graphNode);
    }

    @Override
    public PrefixMap prefixes() {
        return this.prefixes;
    }

    @Override
    public void begin(ReadWrite txnType) {
        this.begin(TxnType.convert(txnType));
    }

    @Override
    public void begin(TxnType txnType) {
        this.checkNotClosed();
        this.checkNotActive();
        DatasetGraphTxn dsgTxn = this.sConn.begin(txnType);
        this.dsgtxn.set(dsgTxn);
        this.inTransaction.set(true);
    }

    @Override
    public boolean promote() {
        Transactional.Promote promoteMode = Transactional.Promote.ISOLATED;
        TxnType txnType = this.transactionType();
        if (txnType == TxnType.READ_COMMITTED_PROMOTE) {
            promoteMode = Transactional.Promote.READ_COMMITTED;
        }
        return this.promote(promoteMode);
    }

    @Override
    public boolean promote(Transactional.Promote promoteMode) {
        this.checkNotClosed();
        DatasetGraphTxn dsgTxn = this.dsgtxn.get();
        return this.promoteStep(dsgTxn, promoteMode);
    }

    private boolean promoteStep(DatasetGraphTxn dsgTxn, Transactional.Promote promoteMode) {
        Transaction transaction = dsgTxn.getTransaction();
        DatasetGraphTxn dsgTxn2 = transaction.getTxnMgr().promote(dsgTxn, transaction.getTxnType(), promoteMode);
        if (dsgTxn2 == null) {
            return false;
        }
        this.dsgtxn.set(dsgTxn2);
        return true;
    }

    @Override
    public void commit() {
        this.checkNotClosed();
        this.checkActive();
        this.dsgtxn.get().commit();
        this.inTransaction.set(false);
    }

    @Override
    public void abort() {
        this.checkNotClosed();
        this.checkActive();
        this.dsgtxn.get().abort();
        this.inTransaction.set(false);
    }

    @Override
    public void end() {
        this.checkNotClosed();
        DatasetGraphTxn dsg = this.dsgtxn.get();
        if (dsg == null) {
            TDB.logInfo.warn("Transaction already ended");
            return;
        }
        try {
            this.dsgtxn.get().end();
        }
        finally {
            this.inTransaction.set(false);
            this.dsgtxn.set(null);
        }
    }

    @Override
    public boolean isInTransaction() {
        this.checkNotClosed();
        return this.inTransaction.get();
    }

    @Override
    public ReadWrite transactionMode() {
        this.checkNotClosed();
        if (!this.isInTransaction()) {
            return null;
        }
        return this.dsgtxn.get().getTransaction().getTxnMode();
    }

    @Override
    public TxnType transactionType() {
        this.checkNotClosed();
        if (!this.isInTransaction()) {
            return null;
        }
        return this.dsgtxn.get().getTransaction().getTxnType();
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionAbort() {
        return true;
    }

    @Override
    public String toString() {
        try {
            if (this.isInTransaction()) {
                return this.get().toString();
            }
            return this.getBaseDatasetGraph().toString();
        }
        catch (Throwable th) {
            return "DatasetGraphTransaction";
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        if (this.sConn.haveUsedInTransaction()) {
            if (this.isInTransaction()) {
                TDB.logInfo.warn("Attempt to close a DatasetGraphTransaction while a transaction is active - ignored close (" + this.getLocation() + ")");
                return;
            }
            return;
        }
        if (!this.sConn.isValid()) {
            return;
        }
        DatasetGraphTDB dsg = this.sConn.getBaseDataset();
        dsg.sync();
        dsg.close();
        StoreConnection.release(this.getLocation());
        this.dsgtxn.remove();
        this.inTransaction.remove();
        this.isClosed = true;
    }

    @Override
    public Context getContext() {
        return this.getBaseDatasetGraph().getContext();
    }

    public StoreConnection getStoreConnection() {
        return this.sConn;
    }

    public void syncIfNotTransactional() {
        if (!this.sConn.haveUsedInTransaction()) {
            this.sConn.getBaseDataset().sync();
        }
    }

    @Override
    public void sync() {
        if (!this.sConn.haveUsedInTransaction() && this.get() != null) {
            this.get().sync();
        }
    }

    private void checkActive() {
        if (!this.isInTransaction()) {
            throw new JenaTransactionException("Not in a transaction (" + this.getLocation() + ")");
        }
    }

    private void checkNotActive() {
        if (this.sConn.haveUsedInTransaction() && this.isInTransaction()) {
            throw new JenaTransactionException("Currently in a transaction (" + this.getLocation() + ")");
        }
    }

    private void checkNotClosed() {
        if (this.isClosed) {
            throw new JenaTransactionException("Already closed");
        }
    }
}

