/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.builtins;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.rulesys.BuiltinException;
import org.apache.jena.reasoner.rulesys.ClauseEntry;
import org.apache.jena.reasoner.rulesys.RuleContext;
import org.apache.jena.reasoner.rulesys.Util;
import org.apache.jena.reasoner.rulesys.builtins.BaseBuiltin;

public class Drop
extends BaseBuiltin {
    @Override
    public String getName() {
        return "drop";
    }

    @Override
    public void headAction(Node[] args, int length, RuleContext context2) {
        InfGraph inf = context2.getGraph();
        Graph raw = inf.getRawGraph();
        Graph deductions = inf.getDeductionsGraph();
        for (int i = 0; i < length; ++i) {
            ClauseEntry clause;
            Node clauseN = this.getArg(i, args, context2);
            if (Util.isNumeric(clauseN)) {
                int clauseIndex = Util.getIntValue(clauseN);
                clause = context2.getRule().getBodyElement(clauseIndex);
                if (!(clause instanceof TriplePattern)) {
                    throw new BuiltinException(this, context2, "illegal triple to remove non-triple clause");
                }
            } else {
                throw new BuiltinException(this, context2, "illegal arg to remove (" + clauseN + "), must be an integer");
            }
            Triple t = context2.getEnv().instantiate((TriplePattern)clause);
            raw.delete(t);
            deductions.delete(t);
        }
    }

    @Override
    public boolean isMonotonic() {
        return false;
    }
}

