/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.assembler;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.analyzer.Util;
import org.apache.jena.query.text.assembler.TextVocab;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class LocalizedAnalyzerAssembler
extends AssemblerBase {
    @Override
    public Analyzer open(Assembler a, Resource root2, Mode mode) {
        if (root2.hasProperty(TextVocab.pLanguage)) {
            RDFNode node = root2.getProperty(TextVocab.pLanguage).getObject();
            if (!node.isLiteral()) {
                throw new TextIndexException("text:language property must be a string : " + node);
            }
            String lang = node.toString();
            return Util.getLocalizedAnalyzer(lang);
        }
        return new StandardAnalyzer();
    }
}

