/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.base.module;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.base.module.SubsystemLifecycle;
import org.apache.jena.base.module.SubsystemRegistry;
import org.slf4j.LoggerFactory;

public class SubsystemRegistryServiceLoader<T extends SubsystemLifecycle>
implements SubsystemRegistry<T> {
    private List<T> registry = new ArrayList<T>();
    private Object registryLock = new Object();
    private Class<T> moduleClass;

    public SubsystemRegistryServiceLoader(Class<T> moduleClass) {
        this.moduleClass = moduleClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() {
        Object object = this.registryLock;
        synchronized (object) {
            ServiceLoader<T> sl;
            try {
                sl = ServiceLoader.load(this.moduleClass, this.getClass().getClassLoader());
            }
            catch (ServiceConfigurationError ex) {
                Log.error(this, "Problem with service loading for " + this.moduleClass.getName(), ex);
                throw ex;
            }
            sl.stream().forEach(provider -> {
                try {
                    SubsystemLifecycle module = (SubsystemLifecycle)provider.get();
                    this.add(module);
                }
                catch (ServiceConfigurationError ex) {
                    FmtLog.error(LoggerFactory.getLogger(this.getClass()), "Error instantiating class %s for %s", provider.type().getName(), this.moduleClass.getName(), ex);
                    throw ex;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(T module) {
        Object object = this.registryLock;
        synchronized (object) {
            if (!this.registry.contains(module)) {
                this.registry.add(module);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRegistered(T module) {
        Object object = this.registryLock;
        synchronized (object) {
            return this.registry.contains(module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(T module) {
        Object object = this.registryLock;
        synchronized (object) {
            this.registry.remove(module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.registryLock;
        synchronized (object) {
            return this.registry.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.registryLock;
        synchronized (object) {
            return this.registry.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> snapshot() {
        Object object = this.registryLock;
        synchronized (object) {
            return new ArrayList<T>(this.registry);
        }
    }
}

