/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader.main;

import org.apache.jena.dboe.transaction.txn.Transaction;
import org.apache.jena.dboe.transaction.txn.TransactionCoordinator;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.TxnType;
import org.apache.jena.riot.system.Prefixes;
import org.apache.jena.tdb2.loader.base.BulkStartFinish;
import org.apache.jena.tdb2.loader.base.CoLib;
import org.apache.jena.tdb2.loader.base.MonitorOutput;
import org.apache.jena.tdb2.loader.main.PrefixHandler;
import org.apache.jena.tdb2.store.StoragePrefixesTDB;
import org.apache.jena.tdb2.store.nodetupletable.NodeTupleTable;

public class PrefixHandlerBulk
implements BulkStartFinish {
    private Transaction transaction;
    private TransactionCoordinator coordinator;
    private final StoragePrefixesTDB prefixes;
    private final MonitorOutput output;
    private final NodeTupleTable nodeTupleTable;

    public PrefixHandlerBulk(StoragePrefixesTDB prefixes, MonitorOutput output) {
        this.prefixes = prefixes;
        this.output = output;
        this.nodeTupleTable = prefixes.getNodeTupleTable();
    }

    @Override
    public void startBulk() {
        this.coordinator = CoLib.newCoordinator();
        CoLib.add(this.coordinator, this.nodeTupleTable.getNodeTable());
        CoLib.add(this.coordinator, this.nodeTupleTable.getTupleTable().getIndexes());
        this.coordinator.start();
        this.transaction = this.coordinator.begin(TxnType.WRITE);
    }

    @Override
    public void finishBulk() {
        this.transaction.commit();
    }

    public PrefixHandler handler() {
        return (prefix, uriStr) -> {
            Node p = NodeFactory.createLiteral(prefix);
            Node u = NodeFactory.createURI(uriStr);
            this.prefixes.add_ext(Prefixes.nodeDataset, (String)prefix, (String)uriStr);
        };
    }
}

