/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store.nodetupletable;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.NullIterator;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.lib.TupleLib;
import org.apache.jena.tdb.store.NodeId;
import org.apache.jena.tdb.store.nodetable.NodeTable;
import org.apache.jena.tdb.store.nodetupletable.NodeTupleTable;
import org.apache.jena.tdb.store.tupletable.TupleIndex;
import org.apache.jena.tdb.store.tupletable.TupleTable;
import org.apache.jena.tdb.sys.DatasetControl;

public class NodeTupleTableConcrete
implements NodeTupleTable {
    protected final NodeTable nodeTable;
    protected final TupleTable tupleTable;
    private final DatasetControl dsPolicy;

    public NodeTupleTableConcrete(int N, TupleIndex[] indexes, NodeTable nodeTable, DatasetControl dsControl) {
        if (indexes.length == 0 || indexes[0] == null) {
            throw new TDBException("A primary index is required");
        }
        for (TupleIndex index : indexes) {
            if (N == index.getTupleLength()) continue;
            throw new TDBException(String.format("Inconsistent: TupleTable width is %d but index %s is %d", N, index.getMappingStr(), index.getTupleLength()));
        }
        this.dsPolicy = dsControl;
        this.tupleTable = new TupleTable(N, indexes);
        this.nodeTable = nodeTable;
    }

    private void startWrite() {
        this.dsPolicy.startUpdate();
    }

    private void finishWrite() {
        this.dsPolicy.finishUpdate();
    }

    private void startRead() {
        this.dsPolicy.startRead();
    }

    private void finishRead() {
        this.dsPolicy.finishRead();
    }

    @Override
    public DatasetControl getPolicy() {
        return this.dsPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addRow(Node ... nodes) {
        try {
            this.startWrite();
            NodeId[] n = new NodeId[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                n[i] = this.nodeTable.getAllocateNodeId(nodes[i]);
            }
            Tuple<NodeId> t = TupleFactory.tuple(n);
            boolean bl = this.tupleTable.add(t);
            return bl;
        }
        finally {
            this.finishWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteRow(Node ... nodes) {
        try {
            this.startWrite();
            NodeId[] n = new NodeId[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                NodeId id = this.idForNode(nodes[i]);
                if (NodeId.isDoesNotExist(id)) {
                    boolean bl = false;
                    return bl;
                }
                n[i] = id;
            }
            Tuple<NodeId> t = TupleFactory.tuple(n);
            boolean bl = this.tupleTable.delete(t);
            return bl;
        }
        finally {
            this.finishWrite();
        }
    }

    @Override
    public int getTupleLen() {
        return this.tupleTable.getTupleLen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Tuple<Node>> find(Node ... nodes) {
        try {
            Iterator<Tuple<Node>> iter2;
            this.startRead();
            Iterator<Tuple<NodeId>> iter1 = this.findAsNodeIds(nodes);
            if (iter1 == null) {
                NullIterator<Tuple<Node>> nullIterator = new NullIterator<Tuple<Node>>();
                return nullIterator;
            }
            Iterator<Tuple<Node>> iterator = iter2 = TupleLib.convertToNodes(this.nodeTable, iter1);
            return iterator;
        }
        finally {
            this.finishRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Tuple<NodeId>> findAsNodeIds(Node ... nodes) {
        NodeId[] n = new NodeId[nodes.length];
        try {
            this.startRead();
            for (int i = 0; i < nodes.length; ++i) {
                NodeId id = this.idForNode(nodes[i]);
                if (NodeId.isDoesNotExist(id)) {
                    Iterator<Tuple<NodeId>> iterator = Iter.nullIterator();
                    return iterator;
                }
                n[i] = id;
            }
            Iterator<Tuple<NodeId>> iterator = this.find(n);
            return iterator;
        }
        finally {
            this.finishRead();
        }
    }

    @Override
    public Iterator<Tuple<NodeId>> find(NodeId ... ids) {
        Tuple<NodeId> tuple = TupleFactory.tuple(ids);
        return this.find(tuple);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Tuple<NodeId>> find(Tuple<NodeId> tuple) {
        try {
            this.startRead();
            Iterator<Tuple<NodeId>> iter = this.tupleTable.find(tuple);
            Iterator<Tuple<NodeId>> iterator = this.iteratorControl(iter);
            return iterator;
        }
        finally {
            this.finishRead();
        }
    }

    @Override
    public Iterator<Tuple<NodeId>> findAll() {
        try {
            this.startRead();
            Iterator<Tuple<NodeId>> iterator = this.iteratorControl(this.tupleTable.getIndex(0).all());
            return iterator;
        }
        finally {
            this.finishRead();
        }
    }

    protected final NodeId idForNode(Node node) {
        if (node == null || node == Node.ANY) {
            return NodeId.NodeIdAny;
        }
        if (node.isVariable()) {
            throw new TDBException("Can't pass variables to NodeTupleTable.find*");
        }
        return this.nodeTable.getNodeIdForNode(node);
    }

    @Override
    public final TupleTable getTupleTable() {
        return this.tupleTable;
    }

    @Override
    public final NodeTable getNodeTable() {
        return this.nodeTable;
    }

    @Override
    public boolean isEmpty() {
        return this.tupleTable.isEmpty();
    }

    @Override
    public void clear() {
        try {
            this.startWrite();
            this.tupleTable.clear();
        }
        finally {
            this.finishWrite();
        }
    }

    @Override
    public long size() {
        return this.tupleTable.size();
    }

    @Override
    public final void close() {
        try {
            this.startWrite();
            this.tupleTable.close();
            this.nodeTable.close();
        }
        finally {
            this.finishWrite();
        }
    }

    @Override
    public final void sync() {
        try {
            this.startWrite();
            this.tupleTable.sync();
            this.nodeTable.sync();
        }
        finally {
            this.finishWrite();
        }
    }

    private <T> Iterator<T> iteratorControl(Iterator<T> iter) {
        return this.dsPolicy.iteratorControl(iter);
    }
}

