/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system;

import org.apache.jena.system.ThreadAction;
import org.apache.jena.system.ThreadTxn;
import org.apache.jena.system.Txn;
import org.apache.jena.system.TxnCounter;
import org.junit.Assert;
import org.junit.Test;

public class TestTxnThread {
    TxnCounter counter = new TxnCounter(0L);

    @Test
    public void txnThread_1() {
        ThreadAction t = ThreadTxn.threadTxnRead(this.counter, () -> {});
        t.run();
    }

    @Test
    public void txnThread_2() {
        ThreadAction t = ThreadTxn.threadTxnWrite(this.counter, () -> Assert.fail((String)""));
    }

    @Test(expected=AssertionError.class)
    public void txnThread_3() {
        ThreadAction t = ThreadTxn.threadTxnWrite(this.counter, () -> Assert.fail((String)""));
        t.run();
    }

    @Test
    public void txnThread_10() {
        long x1 = this.counter.get();
        ThreadAction t = ThreadTxn.threadTxnWrite(this.counter, () -> this.counter.inc());
        long x2 = this.counter.get();
        Assert.assertEquals((String)"x2", (long)x1, (long)x2);
        t.run();
        long x3 = this.counter.get();
        Assert.assertEquals((String)"x3", (long)(x1 + 1L), (long)x3);
    }

    @Test
    public void txnThread_11() {
        long x1 = this.counter.get();
        Txn.executeWrite(this.counter, () -> {
            this.counter.inc();
            ThreadAction t = ThreadTxn.threadTxnRead(this.counter, () -> {
                long z1 = this.counter.get();
                Assert.assertEquals((String)"Thread read", (long)x1, (long)z1);
            });
            this.counter.inc();
            t.run();
        });
        long x2 = this.counter.get();
        Assert.assertEquals((String)"after", (long)(x1 + 2L), (long)x2);
    }

    @Test
    public void txnThread_12() {
        long x1 = this.counter.get();
        ThreadAction t = ThreadTxn.threadTxnRead(this.counter, () -> {
            long z1 = this.counter.get();
            Assert.assertEquals((String)"Thread", (long)x1, (long)z1);
        });
        Txn.executeWrite(this.counter, () -> this.counter.inc());
        t.run();
        long x2 = this.counter.get();
        Assert.assertEquals((String)"after", (long)(x1 + 1L), (long)x2);
    }
}

