/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system;

import java.util.ArrayList;
import org.apache.jena.query.TxnType;
import org.apache.jena.system.TxnOp;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestTxnOp {
    private String name;
    private Boolean expected;
    private TxnType innerTxnType;
    private TxnType outerTxnType;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> data() {
        ArrayList<Object[]> tests = new ArrayList<Object[]>();
        tests.add(TestTxnOp.test(true, TxnType.READ, TxnType.WRITE));
        tests.add(TestTxnOp.test(true, TxnType.READ, TxnType.READ_COMMITTED_PROMOTE));
        tests.add(TestTxnOp.test(true, TxnType.READ, TxnType.READ_PROMOTE));
        tests.add(TestTxnOp.test(true, TxnType.READ, TxnType.READ));
        tests.add(TestTxnOp.test(true, TxnType.READ_PROMOTE, TxnType.WRITE));
        tests.add(TestTxnOp.test(false, TxnType.READ_PROMOTE, TxnType.READ_COMMITTED_PROMOTE));
        tests.add(TestTxnOp.test(true, TxnType.READ_PROMOTE, TxnType.READ_PROMOTE));
        tests.add(TestTxnOp.test(false, TxnType.READ_PROMOTE, TxnType.READ));
        tests.add(TestTxnOp.test(true, TxnType.READ_COMMITTED_PROMOTE, TxnType.WRITE));
        tests.add(TestTxnOp.test(true, TxnType.READ_COMMITTED_PROMOTE, TxnType.READ_COMMITTED_PROMOTE));
        tests.add(TestTxnOp.test(false, TxnType.READ_COMMITTED_PROMOTE, TxnType.READ_PROMOTE));
        tests.add(TestTxnOp.test(false, TxnType.READ_COMMITTED_PROMOTE, TxnType.READ));
        tests.add(TestTxnOp.test(true, TxnType.WRITE, TxnType.WRITE));
        tests.add(TestTxnOp.test(false, TxnType.WRITE, TxnType.READ_COMMITTED_PROMOTE));
        tests.add(TestTxnOp.test(false, TxnType.WRITE, TxnType.READ_PROMOTE));
        tests.add(TestTxnOp.test(false, TxnType.WRITE, TxnType.READ));
        return tests;
    }

    private static Object[] test(boolean expected, TxnType innerTxnType, TxnType outerTxnType) {
        String name = innerTxnType.name() + " < " + outerTxnType.name();
        return new Object[]{name, expected, innerTxnType, outerTxnType};
    }

    public TestTxnOp(String name, Boolean expected, TxnType innerTxnType, TxnType outerTxnType) {
        this.name = name;
        this.expected = expected;
        this.innerTxnType = innerTxnType;
        this.outerTxnType = outerTxnType;
    }

    @Test
    public void test() {
        Assert.assertEquals((String)this.name, (Object)this.expected, (Object)TxnOp.isTxnTypeCompatible(this.innerTxnType, this.outerTxnType));
    }
}

