/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalLock;
import org.apache.jena.system.ExceptionFromTest;
import org.apache.jena.system.Txn;
import org.junit.Assert;
import org.junit.Test;

public class TestTxnLifecycle {
    private AtomicLong counter = new AtomicLong(0L);
    private Transactional trans = TransactionalLock.createMRSW();

    @Test
    public void txn_lifecycle_01() {
        Txn.executeRead(this.trans, () -> {});
    }

    @Test
    public void txn_lifecycle_02() {
        Txn.executeWrite(this.trans, () -> {});
    }

    @Test
    public void txn_lifecycle_03() {
        int x = Txn.calculateRead(this.trans, () -> 4);
        Assert.assertEquals((long)4L, (long)x);
    }

    @Test
    public void txn_lifecycle_04() {
        int x = Txn.calculateWrite(this.trans, () -> 5);
        Assert.assertEquals((long)5L, (long)x);
    }

    @Test
    public void txn_lifecycle_05() {
        int x = Txn.calculateWrite(this.trans, () -> Txn.calculateWrite(this.trans, () -> 56));
        Assert.assertEquals((long)56L, (long)x);
    }

    @Test(expected=JenaTransactionException.class)
    public void txn_lifecycle_05a() {
        int x = Txn.calculateRead(this.trans, () -> Txn.calculateWrite(this.trans, () -> 56));
        Assert.assertEquals((long)56L, (long)x);
    }

    @Test
    public void txn_lifecycle_05b() {
        int x = Txn.calculateWrite(this.trans, () -> Txn.calculateRead(this.trans, () -> 56));
        Assert.assertEquals((long)56L, (long)x);
    }

    @Test(expected=ExceptionFromTest.class)
    public void txn_lifecycle_06() {
        int x = Txn.calculateWrite(this.trans, () -> {
            Txn.calculateWrite(this.trans, () -> {
                throw new ExceptionFromTest();
            });
            return 45;
        });
        Assert.fail((String)"Should not be here!");
    }

    @Test
    public void txn_lifecycle_07() {
        Txn.executeWrite(this.trans, () -> this.trans.commit());
    }

    @Test
    public void txn_lifecycle_08() {
        Txn.executeWrite(this.trans, () -> this.trans.abort());
    }

    @Test
    public void txn_lifecycle_09() {
        Txn.executeRead(this.trans, () -> this.trans.commit());
    }

    @Test
    public void txn_lifecycle_10() {
        Txn.executeRead(this.trans, () -> this.trans.abort());
    }

    static void async(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.start();
    }

    static void debug(String message) {
    }
}

