/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system;

import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.system.ExceptionFromTest;
import org.apache.jena.system.ThreadAction;
import org.apache.jena.system.ThreadTxn;
import org.apache.jena.system.Txn;
import org.apache.jena.system.TxnCounter;
import org.junit.Assert;
import org.junit.Test;

public class TestTxn {
    TxnCounter counter = new TxnCounter(0L);

    @Test
    public void txn_basic_01() {
        long v1 = this.counter.get();
        Assert.assertEquals((long)0L, (long)v1);
        Txn.executeRead(this.counter, () -> Assert.assertEquals((long)0L, (long)this.counter.get()));
    }

    @Test
    public void txn_basic_02() {
        long x = Txn.calculateRead(this.counter, () -> {
            Assert.assertEquals((String)"In R, value()", (long)0L, (long)this.counter.value());
            Assert.assertEquals((String)"In R, get()", (long)0L, (long)this.counter.get());
            return this.counter.get();
        });
        Assert.assertEquals((String)"Outside R", (long)0L, (long)x);
    }

    @Test
    public void txn_basic_03() {
        Txn.executeWrite(this.counter, this.counter::inc);
        long x = Txn.calculateRead(this.counter, () -> {
            Assert.assertEquals((String)"In R, value()", (long)1L, (long)this.counter.value());
            Assert.assertEquals((String)"In R, get()", (long)1L, (long)this.counter.get());
            return this.counter.get();
        });
        Assert.assertEquals((String)"Outside R", (long)1L, (long)x);
    }

    @Test
    public void txn_basic_05() {
        long x = Txn.calculateWrite(this.counter, () -> {
            this.counter.inc();
            Assert.assertEquals((String)"In W, value()", (long)0L, (long)this.counter.value());
            Assert.assertEquals((String)"In W, get()", (long)1L, (long)this.counter.get());
            return this.counter.get();
        });
        Assert.assertEquals((String)"Outside W", (long)1L, (long)x);
    }

    @Test
    public void txn_write_01() {
        long x = Txn.calculateWrite(this.counter, () -> {
            this.counter.inc();
            Assert.assertEquals((String)"In W, value()", (long)0L, (long)this.counter.value());
            Assert.assertEquals((String)"In W, get()", (long)1L, (long)this.counter.get());
            long z = this.counter.get();
            this.counter.commit();
            return z;
        });
        Assert.assertEquals((String)"Outside W", (long)1L, (long)x);
    }

    @Test
    public void txn_write_02() {
        long x = Txn.calculateWrite(this.counter, () -> {
            this.counter.inc();
            Assert.assertEquals((String)"In W, value()", (long)0L, (long)this.counter.value());
            Assert.assertEquals((String)"In W, get()", (long)1L, (long)this.counter.get());
            long z = this.counter.get();
            this.counter.abort();
            return z;
        });
        Assert.assertEquals((String)"Outside W", (long)1L, (long)x);
    }

    @Test
    public void txn_write_03() {
        Txn.executeWrite(this.counter, () -> {
            this.counter.inc();
            Assert.assertEquals((String)"In W, value()", (long)0L, (long)this.counter.value());
            Assert.assertEquals((String)"In W, get()", (long)1L, (long)this.counter.get());
            this.counter.commit();
        });
        Assert.assertEquals((String)"Outside W", (long)1L, (long)this.counter.value());
    }

    @Test
    public void txn_write_04() {
        Txn.executeWrite(this.counter, () -> {
            this.counter.inc();
            Assert.assertEquals((String)"In W, value()", (long)0L, (long)this.counter.value());
            Assert.assertEquals((String)"In W, get()", (long)1L, (long)this.counter.get());
            this.counter.abort();
        });
        Assert.assertEquals((String)"Outside W", (long)0L, (long)this.counter.value());
    }

    @Test
    public void txn_rw_1() {
        Assert.assertEquals((long)0L, (long)this.counter.get());
        Txn.executeWrite(this.counter, () -> {
            this.counter.inc();
            Assert.assertEquals((String)"In W, value()", (long)0L, (long)this.counter.value());
            Assert.assertEquals((String)"In W, get()", (long)1L, (long)this.counter.get());
        });
        Assert.assertEquals((String)"Direct value()", (long)1L, (long)this.counter.value());
        Assert.assertEquals((String)"Direct get()", (long)1L, (long)this.counter.get());
        Txn.executeRead(this.counter, () -> {
            Assert.assertEquals((String)"In R, value()", (long)1L, (long)this.counter.value());
            Assert.assertEquals((String)"In R, get()", (long)1L, (long)this.counter.get());
        });
    }

    @Test
    public void txn_rw_2() {
        Txn.executeRead(this.counter, () -> {
            Assert.assertEquals((String)"In R, value()", (long)0L, (long)this.counter.value());
            Assert.assertEquals((String)"In R, get()", (long)0L, (long)this.counter.get());
        });
        Txn.executeWrite(this.counter, () -> {
            this.counter.inc();
            Assert.assertEquals((String)"In W, value()", (long)0L, (long)this.counter.value());
            Assert.assertEquals((String)"In W, get()", (long)1L, (long)this.counter.get());
        });
        Assert.assertEquals((String)"Direct value()", (long)1L, (long)this.counter.get());
        Assert.assertEquals((String)"Direct get()", (long)1L, (long)this.counter.get());
        Txn.executeRead(this.counter, () -> {
            Assert.assertEquals((String)"In R, value()", (long)1L, (long)this.counter.value());
            Assert.assertEquals((String)"In R, get()", (long)1L, (long)this.counter.get());
        });
    }

    @Test
    public void txn_continue_1() {
        Txn.executeWrite(this.counter, () -> this.counter.set(91L));
        Txn.executeWrite(this.counter, () -> {
            Assert.assertEquals((String)"In txn, value()", (long)91L, (long)this.counter.value());
            Assert.assertEquals((String)"In txn, read()", (long)91L, (long)this.counter.read());
            this.counter.inc();
            Txn.executeWrite(this.counter, () -> {
                Assert.assertEquals((String)"In txn, value()", (long)91L, (long)this.counter.value());
                Assert.assertEquals((String)"In txn, get()", (long)92L, (long)this.counter.read());
            });
        });
        Assert.assertEquals((long)92L, (long)this.counter.value());
    }

    @Test
    public void txn_continue_2() {
        Txn.executeWrite(this.counter, () -> this.counter.set(91L));
        Txn.executeWrite(this.counter, () -> {
            Assert.assertEquals((String)"In txn, value()", (long)91L, (long)this.counter.value());
            Assert.assertEquals((String)"In txn, read()", (long)91L, (long)this.counter.read());
            this.counter.inc();
            Txn.executeWrite(this.counter, () -> {
                Assert.assertEquals((String)"In txn, value()", (long)91L, (long)this.counter.value());
                Assert.assertEquals((String)"In txn, get()", (long)92L, (long)this.counter.read());
                this.counter.inc();
            });
            Assert.assertEquals((String)"In txn, value()", (long)91L, (long)this.counter.value());
            Assert.assertEquals((String)"In txn, read()", (long)93L, (long)this.counter.read());
            this.counter.inc();
        });
        Assert.assertEquals((long)94L, (long)this.counter.value());
    }

    @Test(expected=ExceptionFromTest.class)
    public void txn_exception_01() {
        Txn.executeWrite(this.counter, this.counter::inc);
        Txn.executeWrite(this.counter, () -> {
            this.counter.inc();
            Assert.assertEquals((String)"In W, value()", (long)1L, (long)this.counter.value());
            Assert.assertEquals((String)"In W, get()", (long)2L, (long)this.counter.get());
            throw new ExceptionFromTest();
        });
    }

    @Test
    public void txn_exception_02() {
        Txn.executeWrite(this.counter, () -> this.counter.set(8L));
        try {
            Txn.executeWrite(this.counter, () -> {
                this.counter.inc();
                Assert.assertEquals((String)"In W, value()", (long)8L, (long)this.counter.value());
                Assert.assertEquals((String)"In W, get()", (long)9L, (long)this.counter.get());
                throw new ExceptionFromTest();
            });
        }
        catch (ExceptionFromTest exceptionFromTest) {
            // empty catch block
        }
        Assert.assertEquals((String)"After W/abort, get()", (long)8L, (long)this.counter.get());
    }

    @Test
    public void txn_exception_03() {
        Txn.executeWrite(this.counter, () -> this.counter.set(9L));
        try {
            Txn.executeRead(this.counter, () -> {
                Assert.assertEquals((String)"In W, value()", (long)9L, (long)this.counter.value());
                Assert.assertEquals((String)"In W, get()", (long)9L, (long)this.counter.get());
                throw new ExceptionFromTest();
            });
        }
        catch (ExceptionFromTest exceptionFromTest) {
            // empty catch block
        }
        Assert.assertEquals((String)"After W/abort, get()", (long)9L, (long)this.counter.get());
    }

    @Test
    public void txn_nested_01() {
        Txn.exec(this.counter, TxnType.READ, () -> Txn.exec(this.counter, TxnType.READ, () -> {}));
    }

    @Test
    public void txn_nested_02() {
        Txn.exec(this.counter, TxnType.WRITE, () -> Txn.exec(this.counter, TxnType.READ, () -> {}));
    }

    @Test
    public void txn_nested_03() {
        Txn.exec(this.counter, TxnType.READ_PROMOTE, () -> Txn.exec(this.counter, TxnType.READ, () -> {}));
    }

    @Test
    public void txn_nested_04() {
        Txn.exec(this.counter, TxnType.READ_COMMITTED_PROMOTE, () -> Txn.exec(this.counter, TxnType.READ, () -> {}));
    }

    @Test(expected=JenaTransactionException.class)
    public void txn_nested_05() {
        Txn.exec(this.counter, TxnType.READ, () -> Txn.exec(this.counter, TxnType.WRITE, () -> {}));
    }

    @Test
    public void txn_nested_06() {
        Txn.exec(this.counter, TxnType.READ_PROMOTE, () -> {
            boolean b = this.counter.promote();
            Assert.assertTrue((boolean)b);
            Txn.exec(this.counter, TxnType.READ_PROMOTE, () -> {});
        });
    }

    @Test
    public void txn_nested_07() {
        Txn.exec(this.counter, TxnType.READ_COMMITTED_PROMOTE, () -> {
            boolean b = this.counter.promote();
            Assert.assertTrue((boolean)b);
            Txn.exec(this.counter, TxnType.READ_COMMITTED_PROMOTE, () -> {});
        });
    }

    @Test
    public void txn_nested_08() {
        Txn.exec(this.counter, TxnType.READ_COMMITTED_PROMOTE, () -> {
            boolean b = this.counter.promote();
            Assert.assertTrue((boolean)b);
            Assert.assertEquals((Object)((Object)ReadWrite.WRITE), (Object)((Object)this.counter.transactionMode()));
            Txn.exec(this.counter, TxnType.READ_COMMITTED_PROMOTE, () -> {});
        });
    }

    @Test
    public void txn_nested_09() {
        Txn.exec(this.counter, TxnType.READ_PROMOTE, () -> {
            boolean b = this.counter.promote();
            Assert.assertTrue((boolean)b);
            Assert.assertEquals((Object)((Object)ReadWrite.WRITE), (Object)((Object)this.counter.transactionMode()));
            Txn.exec(this.counter, TxnType.READ_PROMOTE, () -> {});
        });
    }

    @Test
    public void txn_nested_10() {
        Txn.exec(this.counter, TxnType.READ_PROMOTE, () -> Txn.exec(this.counter, TxnType.WRITE, () -> {}));
    }

    @Test
    public void txn_nested_11() {
        Txn.exec(this.counter, TxnType.READ_COMMITTED_PROMOTE, () -> Txn.exec(this.counter, TxnType.WRITE, () -> {}));
    }

    @Test(expected=JenaTransactionException.class)
    public void txn_nested_12() {
        Txn.exec(this.counter, TxnType.READ_PROMOTE, () -> {
            ThreadAction.create(() -> Txn.executeWrite(this.counter, () -> this.counter.inc())).run();
            Txn.exec(this.counter, TxnType.WRITE, () -> {});
        });
    }

    @Test
    public void txn_nested_13() {
        Txn.exec(this.counter, TxnType.READ_COMMITTED_PROMOTE, () -> {
            ThreadAction.create(() -> Txn.executeWrite(this.counter, () -> this.counter.inc())).run();
            Txn.exec(this.counter, TxnType.WRITE, () -> {});
        });
    }

    @Test
    public void txn_threaded_01() {
        Txn.exec(this.counter, TxnType.READ_PROMOTE, () -> {
            ThreadAction a = ThreadTxn.threadTxnWrite(this.counter, () -> {});
            a.run();
            boolean b = this.counter.promote();
            Assert.assertFalse((boolean)b);
            Assert.assertEquals((Object)((Object)ReadWrite.READ), (Object)((Object)this.counter.transactionMode()));
        });
    }

    @Test
    public void txn_threaded_02() {
        TxnCounter tx = this.counter;
        ThreadAction a = ThreadTxn.threadTxnWrite(tx, () -> {});
        Txn.exec(tx, TxnType.READ_PROMOTE, () -> {
            a.run();
            boolean b = tx.promote();
            Assert.assertFalse((boolean)b);
            Assert.assertEquals((Object)((Object)ReadWrite.READ), (Object)((Object)tx.transactionMode()));
        });
    }

    @Test
    public void txn_threaded_03() {
        DatasetGraph tx = DatasetGraphFactory.createTxnMem();
        ThreadAction a = ThreadTxn.threadTxnWriteAbort(tx, () -> {});
        Txn.exec(tx, TxnType.READ_PROMOTE, () -> {
            a.run();
            boolean b = tx.promote();
            Assert.assertTrue((boolean)b);
            Assert.assertEquals((Object)((Object)ReadWrite.WRITE), (Object)((Object)tx.transactionMode()));
        });
    }
}

