/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util.compose;

import java.util.List;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.compose.AbstractTestDatasetCollector;
import org.apache.jena.sparql.util.compose.DatasetCollector;
import org.apache.jena.sparql.util.compose.DatasetLib;
import org.junit.Assert;
import org.junit.Test;

public class TestUnionDatasetCollector
extends AbstractTestDatasetCollector {
    @Override
    public DatasetCollector testInstance() {
        return DatasetLib.collectors().union();
    }

    @Test
    public void testUnion() {
        Graph g1 = SSE.parseGraph("(graph (triple <s1> <p1> <o1> ))");
        Model m1 = ModelFactory.createModelForGraph(g1);
        Dataset dsg1 = DatasetFactory.create(m1);
        String graphName1 = NodeFactory.createBlankNode().toString();
        dsg1.addNamedModel(graphName1, m1);
        Graph g2 = SSE.parseGraph("(graph (triple <s2> <p2> <o2> ))");
        Dataset dsg2 = DatasetFactory.create(ModelFactory.createModelForGraph(g2));
        Model m2 = ModelFactory.createModelForGraph(g2);
        String graphName2 = NodeFactory.createBlankNode().toString();
        dsg2.addNamedModel(graphName2, m2);
        Stream<Dataset> stream = Stream.builder().add(dsg1).add(dsg2).build();
        Dataset dataset = stream.collect(this.testInstance());
        Assert.assertEquals((long)2L, (long)Iter.count(dataset.listNames()));
        Assert.assertTrue((boolean)m1.isIsomorphicWith(dataset.getNamedModel(graphName1)));
        Assert.assertTrue((boolean)m2.isIsomorphicWith(dataset.getNamedModel(graphName2)));
        m1.listStatements().mapWith(dataset.getDefaultModel()::contains).forEachRemaining(Assert::assertTrue);
        m2.listStatements().mapWith(dataset.getDefaultModel()::contains).forEachRemaining(Assert::assertTrue);
        List<Statement> leftovers = dataset.getDefaultModel().listStatements().filterDrop(m1::contains).filterDrop(m2::contains).toList();
        Assert.assertTrue((boolean)leftovers.isEmpty());
    }
}

