/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util.compose;

import java.util.stream.Stream;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.compose.AbstractTestDatasetCollector;
import org.apache.jena.sparql.util.compose.DatasetCollector;
import org.apache.jena.sparql.util.compose.DatasetLib;
import org.junit.Assert;
import org.junit.Test;

public class TestIntersectionDatasetCollector
extends AbstractTestDatasetCollector {
    @Override
    public DatasetCollector testInstance() {
        return DatasetLib.collectors().intersect();
    }

    @Test
    public void testIntersection() {
        Model m1 = ModelFactory.createModelForGraph(SSE.parseGraph("(graph (triple <s1> <p1> <o1> ))"));
        Dataset ds1 = DatasetFactory.create(m1);
        String graphName1 = NodeFactory.createBlankNode().toString();
        ds1.addNamedModel(graphName1, m1);
        Model m2 = ModelFactory.createModelForGraph(SSE.parseGraph("(graph (triple <s2> <p2> <o2> ))"));
        Dataset ds2 = DatasetFactory.create(m2);
        String graphName2 = NodeFactory.createBlankNode().toString();
        ds2.addNamedModel(graphName2, m2);
        Model m3 = ModelFactory.createModelForGraph(SSE.parseGraph("(graph (triple <s3> <p3> <o3> ))"));
        String graphName3 = NodeFactory.createBlankNode().toString();
        ds1.addNamedModel(graphName3, m3);
        ds2.addNamedModel(graphName3, m3);
        Stream<Dataset> stream = Stream.builder().add(ds1).add(ds2).build();
        Dataset ds = stream.collect(this.testInstance());
        Assert.assertTrue((boolean)ds.getDefaultModel().isEmpty());
        Assert.assertTrue((boolean)ds.getNamedModel(graphName1).isEmpty());
        Assert.assertTrue((boolean)ds.getNamedModel(graphName2).isEmpty());
        Assert.assertTrue((boolean)m3.isIsomorphicWith(ds.getNamedModel(graphName3)));
    }
}

