/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.AbstractTestDyadicDatasetGraph;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.UnionDatasetGraph;
import org.junit.Assert;
import org.junit.Test;

public class TestUnionDatasetGraph
extends AbstractTestDyadicDatasetGraph {
    @Override
    public DatasetGraph testInstance(DatasetGraph left, DatasetGraph right, Context c) {
        return new UnionDatasetGraph(left, right, c);
    }

    @Test
    public void testUnion() {
        Graph g1 = SSE.parseGraph("(graph (triple <s1> <p1> <o1> ))");
        DatasetGraph dsg1 = DatasetGraphFactory.create(g1);
        Node graphName1 = NodeFactory.createBlankNode();
        dsg1.addGraph(graphName1, g1);
        Graph g2 = SSE.parseGraph("(graph (triple <s2> <p2> <o2> ))");
        DatasetGraph dsg2 = DatasetGraphFactory.create(g2);
        Node graphName2 = NodeFactory.createBlankNode();
        dsg2.addGraph(graphName2, g2);
        DatasetGraph dsg = this.testInstance(dsg1, dsg2, Context.emptyContext);
        Assert.assertEquals((long)2L, (long)dsg.size());
        Assert.assertTrue((boolean)g1.isIsomorphicWith(dsg.getGraph(graphName1)));
        Assert.assertTrue((boolean)g2.isIsomorphicWith(dsg.getGraph(graphName2)));
        g1.find().mapWith(dsg.getDefaultGraph()::contains).forEachRemaining(Assert::assertTrue);
        g2.find().mapWith(dsg.getDefaultGraph()::contains).forEachRemaining(Assert::assertTrue);
    }
}

