/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.io.StringReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.junit.AssertExtra;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Factory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.other.G;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.graph.GNode;
import org.apache.jena.sparql.util.graph.GraphList;
import org.apache.jena.vocabulary.RDF;
import org.junit.Assert;
import org.junit.Test;

public class TestList {
    private GNode emptyList = TestList.parse(listStr_1);
    private GNode list4 = TestList.parse(listStr_2);
    private GNode list22 = TestList.parse(listStr_3);
    private Node NIL = RDF.nil.asNode();
    private static Node node1 = NodeFactory.createLiteral("1", XSDDatatype.XSDinteger);
    private static Node node2 = NodeFactory.createLiteral("2", XSDDatatype.XSDinteger);
    private static Node node3 = NodeFactory.createLiteral("3", XSDDatatype.XSDinteger);
    private static Node node4 = NodeFactory.createLiteral("4", XSDDatatype.XSDinteger);
    private static Node node0 = NodeFactory.createLiteral("0", XSDDatatype.XSDinteger);
    private static Node r = NodeFactory.createURI("http://example/r");
    private static Node p = NodeFactory.createURI("http://example/p");
    private static String preamble = "@prefix : <http://example/> . :r :p ";
    private static String listStr_1 = preamble + "() .";
    private static String listStr_2 = preamble + "(1 2 3 4) .";
    private static String listStr_3 = preamble + "(1 2 1 2) .";
    private static String data = "prefix : <http://example/>\n:s1 :p (1 2 3) .\n:s2 :p () .\n:s3 :p (8) .\n";
    private static Node s1 = NodeFactory.createURI("http://example/s1");
    private static Node s2 = NodeFactory.createURI("http://example/s2");
    private static Node s3 = NodeFactory.createURI("http://example/s3");
    private static Graph graph = Factory.createDefaultGraph();

    @Test
    public void testListLength_1() {
        Assert.assertEquals((long)0L, (long)GraphList.length(this.emptyList));
    }

    @Test
    public void testListLength_2() {
        Assert.assertEquals((long)4L, (long)GraphList.length(this.list4));
    }

    @Test
    public void testListLength_3() {
        Assert.assertEquals((long)4L, (long)GraphList.length(this.list22));
    }

    @Test
    public void testListIndex_1() {
        Assert.assertEquals((long)0L, (long)GraphList.index(this.list4, node1));
    }

    @Test
    public void testListIndex_2() {
        Assert.assertEquals((long)1L, (long)GraphList.index(this.list4, node2));
    }

    @Test
    public void testListIndex_3() {
        Assert.assertEquals((long)2L, (long)GraphList.index(this.list4, node3));
    }

    @Test
    public void testListIndex_4() {
        Assert.assertEquals((long)3L, (long)GraphList.index(this.list4, node4));
    }

    @Test
    public void testListIndex_5() {
        Assert.assertEquals((long)-1L, (long)GraphList.index(this.list4, node0));
    }

    @Test
    public void testListIndex_6() {
        Assert.assertEquals((long)-1L, (long)GraphList.index(this.emptyList, node1));
    }

    @Test
    public void testListIndex_7() {
        Assert.assertEquals((long)0L, (long)GraphList.index(this.list22, node1));
    }

    @Test
    public void testListIndex_8() {
        Assert.assertEquals((long)1L, (long)GraphList.index(this.list22, node2));
    }

    @Test
    public void testListIndexes_1() {
        List<Integer> x = GraphList.indexes(this.emptyList, node0);
        Assert.assertEquals((long)0L, (long)x.size());
    }

    @Test
    public void testListIndexes_2() {
        List<Integer> x = GraphList.indexes(this.list4, node0);
        Assert.assertEquals((long)0L, (long)x.size());
    }

    @Test
    public void testListIndexes_3() {
        List<Integer> x = GraphList.indexes(this.list4, node1);
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertEquals((long)0L, (long)x.get(0).intValue());
    }

    @Test
    public void testListIndexes_4() {
        List<Integer> x = GraphList.indexes(this.list4, node2);
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertEquals((long)1L, (long)x.get(0).intValue());
    }

    @Test
    public void testListIndexes_5() {
        List<Integer> x = GraphList.indexes(this.list4, node4);
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertEquals((long)3L, (long)x.get(0).intValue());
    }

    @Test
    public void testListIndexes_6() {
        List<Integer> x = GraphList.indexes(this.list22, node1);
        Assert.assertEquals((long)2L, (long)x.size());
        Assert.assertEquals((long)0L, (long)x.get(0).intValue());
        Assert.assertEquals((long)2L, (long)x.get(1).intValue());
    }

    @Test
    public void testListTriples_1() {
        Assert.assertEquals((long)0L, (long)GraphList.allTriples(this.emptyList).size());
    }

    @Test
    public void testListTriples_2() {
        Assert.assertEquals((long)8L, (long)GraphList.allTriples(this.list4).size());
    }

    @Test
    public void testListContains_1() {
        Assert.assertFalse((boolean)GraphList.contains(this.emptyList, node0));
    }

    @Test
    public void testListContains_2() {
        Assert.assertFalse((boolean)GraphList.contains(this.emptyList, node1));
    }

    @Test
    public void testListContains_3() {
        Assert.assertTrue((boolean)GraphList.contains(this.list4, node1));
    }

    @Test
    public void testListContains_4() {
        Assert.assertTrue((boolean)GraphList.contains(this.list4, node2));
    }

    @Test
    public void testListContains_5() {
        Assert.assertTrue((boolean)GraphList.contains(this.list4, node4));
    }

    @Test
    public void testListOccurs_1() {
        Assert.assertEquals((long)0L, (long)GraphList.occurs(this.emptyList, node0));
    }

    @Test
    public void testListOccurs_2() {
        Assert.assertEquals((long)0L, (long)GraphList.occurs(this.emptyList, node1));
    }

    @Test
    public void testListOccurs_3() {
        Assert.assertEquals((long)0L, (long)GraphList.occurs(this.list4, node0));
    }

    @Test
    public void testListOccurs_4() {
        Assert.assertEquals((long)0L, (long)GraphList.occurs(this.emptyList, node1));
    }

    @Test
    public void testListOccurs_5() {
        Assert.assertEquals((long)0L, (long)GraphList.occurs(this.emptyList, this.NIL));
    }

    @Test
    public void testListOccurs_6() {
        Assert.assertEquals((long)0L, (long)GraphList.occurs(this.list4, this.NIL));
    }

    @Test
    public void testListOccurs_7() {
        Assert.assertEquals((long)1L, (long)GraphList.occurs(this.list4, node1));
    }

    @Test
    public void testListOccurs_8() {
        Assert.assertEquals((long)1L, (long)GraphList.occurs(this.list4, node2));
    }

    @Test
    public void testListOccurs_9() {
        Assert.assertEquals((long)1L, (long)GraphList.occurs(this.list4, node3));
    }

    @Test
    public void testListOccurs_10() {
        Assert.assertEquals((long)1L, (long)GraphList.occurs(this.list4, node4));
    }

    @Test
    public void testListOccurs_11() {
        Assert.assertEquals((long)2L, (long)GraphList.occurs(this.list22, node1));
    }

    @Test
    public void testListOccurs_12() {
        Assert.assertEquals((long)2L, (long)GraphList.occurs(this.list22, node2));
    }

    @Test
    public void testListGet_1() {
        Assert.assertNull((Object)GraphList.get(this.emptyList, 0));
    }

    @Test
    public void testListGet_2() {
        Assert.assertNull((Object)GraphList.get(this.emptyList, -1));
    }

    @Test
    public void testListGet_3() {
        Assert.assertNull((Object)GraphList.get(this.list4, -1));
    }

    @Test
    public void testListGet_4() {
        Assert.assertNull((Object)GraphList.get(this.list4, 9));
    }

    @Test
    public void testListGet_5() {
        Assert.assertEquals((Object)node1, (Object)GraphList.get(this.list4, 0));
    }

    @Test
    public void testListGet_6() {
        Assert.assertEquals((Object)node1, (Object)GraphList.get(this.list4, 0));
        Assert.assertEquals((Object)node2, (Object)GraphList.get(this.list4, 1));
        Assert.assertEquals((Object)node3, (Object)GraphList.get(this.list4, 2));
        Assert.assertEquals((Object)node4, (Object)GraphList.get(this.list4, 3));
    }

    @Test
    public void testListGet_7() {
        Assert.assertEquals((Object)node1, (Object)GraphList.get(this.list22, 0));
        Assert.assertEquals((Object)node2, (Object)GraphList.get(this.list22, 1));
        Assert.assertEquals((Object)node1, (Object)GraphList.get(this.list22, 2));
        Assert.assertEquals((Object)node2, (Object)GraphList.get(this.list22, 3));
    }

    private static GNode gnode(Node n) {
        return new GNode(Factory.createDefaultGraph(), n);
    }

    private static GNode parse(String str2) {
        Model m = ModelFactory.createDefaultModel();
        m.read(new StringReader(str2), null, "TTL");
        Graph graph = m.getGraph();
        Triple t = (Triple)graph.find(r, p, Node.ANY).next();
        return new GNode(graph, t.getObject());
    }

    @Test
    public void testGraphListMember_01() {
        TestList.testGraphListMember(s1, node1, node2, node3);
    }

    @Test
    public void testGraphListMember_02() {
        TestList.testGraphListMember(s2, new Node[0]);
    }

    @Test
    public void testGraphListMember_03() {
        TestList.testGraphListMember(s3, SSE.parseNode("8"));
    }

    private static void testGraphListMember(Node s, Node ... expected) {
        Node list = TestList.listOf(graph, s);
        Iterator<Triple> iter = GraphList.listMember(graph, list, Node.ANY);
        Iterator<Node> x = G.triple2object(iter);
        List<Node> z = Iter.toList(x);
        TestList.check(z, expected);
    }

    private static Node listOf(Graph graph, Node node) {
        return ((Triple)graph.find(node, p, Node.ANY).next()).getObject();
    }

    private static void check(List<Node> z, Node ... expected) {
        List<Node> x = Arrays.asList(expected);
        AssertExtra.assertEqualsUnordered(x, z);
    }

    static {
        RDFDataMgr.read(graph, new StringReader(data), null, Lang.TTL);
    }
}

