/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.io.ByteArrayOutputStream;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Node_Literal;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.impl.LiteralImpl;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.FmtUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestFmtUtils {
    public static final String aUri = "http://www.zz.org/xx#";

    @Test
    public void stringForTripleEncoding() {
        Assert.assertEquals((Object)"<n1> <n2> \"l3\"", (Object)FmtUtils.stringForTriple(this.getTriple()));
    }

    @Test
    public void stringForTriple_WithPrefixMapping() {
        Assert.assertEquals((Object)"zz:abs <n2> \"l3\"", (Object)FmtUtils.stringForTriple(this.getPrefixedTriple(), this.getPrefixMapping()));
    }

    @Test
    public void stringForQuadEncoding() {
        Node n1 = NodeFactory.createURI("q1");
        Quad quad = new Quad(n1, this.getTriple());
        Assert.assertEquals((Object)"<q1> <n1> <n2> \"l3\"", (Object)FmtUtils.stringForQuad(quad));
    }

    @Test
    public void stringForQuad_WithPrefixMapping() {
        Node n1 = NodeFactory.createURI("q1");
        Quad quad = new Quad(n1, this.getPrefixedTriple());
        Assert.assertEquals((Object)"<q1> zz:abs <n2> \"l3\"", (Object)FmtUtils.stringForQuad(quad, this.getPrefixMapping()));
    }

    @Test
    public void formatPattern_2_triples() {
        BasicPattern basicPattern = new BasicPattern();
        basicPattern.add(this.getTriple());
        basicPattern.add(this.getTriple2());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (IndentedWriter iw = new IndentedWriter(os);){
            SerializationContext sc = new SerializationContext();
            FmtUtils.formatPattern(iw, basicPattern, sc);
        }
        Assert.assertEquals((Object)"<n1> <n2> \"l3\" .\n<nb1> <nb2> \"lb3\" .", (Object)new String(os.toByteArray()));
    }

    @Test
    public void stringForObject_misc_versions() {
        Assert.assertEquals((Object)"<<null>>", (Object)FmtUtils.stringForObject(null));
        Assert.assertEquals((Object)"<n1>", (Object)FmtUtils.stringForObject(new LiteralImpl(this.aNode(), null)));
        Assert.assertEquals((Object)"<nzz1>", (Object)FmtUtils.stringForObject(new ResourceImpl(NodeFactory.createURI("nzz1"), null)));
        Assert.assertEquals((Object)"abc", (Object)FmtUtils.stringForObject("abc"));
    }

    @Test
    public void stringForRDFNode_literal() {
        Assert.assertEquals((Object)"<n1>", (Object)FmtUtils.stringForRDFNode(new LiteralImpl(this.aNode(), null)));
    }

    @Test
    public void stringLiteral() throws Exception {
        Node_Literal nl = (Node_Literal)NodeFactory.createLiteral("abc", "no", new XSDDatatype("string"));
        Assert.assertEquals((Object)"\"abc\"@no", (Object)FmtUtils.stringForLiteral(nl, this.getContext()));
    }

    @Test
    public void integerLiteral() throws Exception {
        Node_Literal nl = (Node_Literal)NodeFactory.createLiteral("2", new XSDDatatype("int"));
        Assert.assertEquals((Object)"\"2\"^^<http://www.w3.org/2001/XMLSchema#int>", (Object)FmtUtils.stringForLiteral(nl, this.getContext()));
    }

    @Test
    public void doubleLiteral() throws Exception {
        Node_Literal nl = (Node_Literal)NodeFactory.createLiteral("2.1e2", new XSDDatatype("double"));
        Assert.assertEquals((Object)"2.1e2", (Object)FmtUtils.stringForLiteral(nl, this.getContext()));
    }

    @Test
    public void decimalLiteral() throws Exception {
        Node_Literal nl = (Node_Literal)NodeFactory.createLiteral("2.4", new XSDDatatype("decimal"));
        Assert.assertEquals((Object)"2.4", (Object)FmtUtils.stringForLiteral(nl, this.getContext()));
    }

    @Test
    public void booleanLiteral() throws Exception {
        Node_Literal nl = (Node_Literal)NodeFactory.createLiteral("false", new XSDDatatype("boolean"));
        Assert.assertEquals((Object)"false", (Object)FmtUtils.stringForLiteral(nl, this.getContext()));
    }

    @Test
    public void stringForRDFNode_resource() {
        ResourceImpl rdfNod = new ResourceImpl(this.aUriRemappableNode(), null);
        Assert.assertEquals((Object)"zz:abs", (Object)FmtUtils.stringForRDFNode(rdfNod, this.getContext()));
    }

    @Test
    public void anonNode1() {
        FmtUtils.resetBNodeLabels();
        Assert.assertEquals((Object)"_:b0", (Object)FmtUtils.stringForNode(NodeFactory.createBlankNode()));
    }

    @Test
    public void anonNode2() {
        FmtUtils.resetBNodeLabels();
        Assert.assertEquals((Object)"_:b0", (Object)FmtUtils.stringForNode(NodeFactory.createBlankNode()));
        Assert.assertEquals((Object)"_:b1", (Object)FmtUtils.stringForNode(NodeFactory.createBlankNode()));
        Assert.assertEquals((Object)"_:b2", (Object)FmtUtils.stringForNode(NodeFactory.createBlankNode()));
    }

    @Test
    public void variableNode() {
        Assert.assertEquals((Object)"?tt", (Object)FmtUtils.stringForNode(NodeFactory.createVariable("tt")));
    }

    @Test
    public void anyNode() {
        Assert.assertEquals((Object)"ANY", (Object)FmtUtils.stringForNode(Node.ANY));
    }

    @Test
    public void testStringForURI() {
        String s = FmtUtils.stringForURI("zz:\u00fc_fe-zz");
        Assert.assertEquals((Object)"<zz:\u00fc_fe-zz>", (Object)s);
    }

    @Test
    public void stringForURI_colonInLocalname_shouldCompact() {
        String uri = "http://www.zz.org/xx#local:name";
        String result = FmtUtils.stringForURI(uri, this.getPrefixMapping());
        Assert.assertEquals((Object)"zz:local:name", (Object)result);
    }

    @Test
    public void testStringEsc() {
        Assert.assertEquals((Object)"\\\\\\r\\n", (Object)FmtUtils.stringEsc("\\\r\n"));
    }

    @Test
    public void stringForString() {
        Assert.assertEquals((Object)"\"a\\rbt\"", (Object)FmtUtils.stringForString("a\rbt"));
    }

    @Test
    public void testFormatBGP_1() {
        IndentedLineBuffer b = new IndentedLineBuffer();
        BasicPattern bgp = SSE.parseBGP("(prefix ((zz: <http://www.zz.org/xx#>)) (bgp (zz:s zz:p zz:o)))");
        FmtUtils.formatPattern(b, bgp, this.getContext());
        Assert.assertEquals((Object)"zz:s zz:p zz:o .", (Object)b.toString());
    }

    @Test
    public void testFormatBGP_2() {
        IndentedLineBuffer b = new IndentedLineBuffer();
        BasicPattern bgp = SSE.parseBGP("(prefix ((zz: <http://www.zz.org/xx#>)) (bgp (zz:s zz:p zz:o) (zz:s zz:p 123) ))");
        FmtUtils.formatPattern(b, bgp, this.getContext());
        Assert.assertEquals((Object)"zz:s zz:p zz:o .\nzz:s zz:p 123 .", (Object)b.toString());
    }

    private Triple getTriple() {
        Node n1 = this.aNode();
        Node n2 = NodeFactory.createURI("n2");
        Node l3 = NodeFactory.createLiteral("l3");
        return new Triple(n1, n2, l3);
    }

    private Node aNode() {
        return NodeFactory.createURI("n1");
    }

    private Triple getTriple2() {
        Node n1 = NodeFactory.createURI("nb1");
        Node n2 = NodeFactory.createURI("nb2");
        Node l3 = NodeFactory.createLiteral("lb3");
        return new Triple(n1, n2, l3);
    }

    private Triple getPrefixedTriple() {
        Node n1 = this.aUriRemappableNode();
        Node n2 = NodeFactory.createURI("n2");
        Node l3 = NodeFactory.createLiteral("l3");
        return new Triple(n1, n2, l3);
    }

    private Node aUriRemappableNode() {
        return NodeFactory.createURI("http://www.zz.org/xx#abs");
    }

    private PrefixMapping getPrefixMapping() {
        PrefixMappingImpl pmap = new PrefixMappingImpl();
        pmap.setNsPrefix("zz", aUri);
        return pmap;
    }

    private SerializationContext getContext() {
        return new SerializationContext(this.getPrefixMapping());
    }
}

