/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import org.apache.jena.sparql.util.DateTimeStruct;
import org.junit.Assert;
import org.junit.Test;

public class TestDateTimeParsing {
    @Test
    public void testDT_1() {
        TestDateTimeParsing.dateTimeTest("2007-08-31T12:34:56Z");
    }

    @Test
    public void testDT_2() {
        TestDateTimeParsing.dateTimeTest("2007-08-31T12:34:56");
    }

    @Test
    public void testDT_3() {
        TestDateTimeParsing.dateTimeTest("2007-08-31T12:34:56.003");
    }

    @Test
    public void testDT_4() {
        TestDateTimeParsing.dateTimeTest("2007-08-31T12:34:56.003+05:00");
    }

    @Test
    public void testDT_5() {
        TestDateTimeParsing.dateTimeTest("-2007-08-31T12:34:56.003-05:00");
    }

    @Test
    public void testDT_6() {
        TestDateTimeParsing.dateTimeTest("-2007-08-31T12:34:56");
    }

    @Test
    public void testDT_7() {
        TestDateTimeParsing.dateTimeBad("+2007-08-31T12:34:56");
    }

    @Test
    public void testDT_8() {
        TestDateTimeParsing.dateTimeBad("2007-08-31");
    }

    @Test
    public void testDT_10() {
        DateTimeStruct dt = DateTimeStruct.parseDateTime("2007-08-31T12:34:56");
        TestDateTimeParsing.check(dt, null, "2007", "08", "31", "12", "34", "56", null);
    }

    @Test
    public void testDT_11() {
        DateTimeStruct dt = DateTimeStruct.parseDateTime("2007-08-31T12:34:56Z");
        TestDateTimeParsing.check(dt, null, "2007", "08", "31", "12", "34", "56", "Z");
    }

    @Test
    public void testDT_12() {
        DateTimeStruct dt = DateTimeStruct.parseDateTime("-2007-08-31T12:34:56.003-05:00");
        TestDateTimeParsing.check(dt, "-", "2007", "08", "31", "12", "34", "56.003", "-05:00");
    }

    @Test
    public void testD_1() {
        TestDateTimeParsing.dateTest("2007-08-31Z");
    }

    @Test
    public void testD_2() {
        TestDateTimeParsing.dateTest("2007-08-31");
    }

    @Test
    public void testD_10() {
        DateTimeStruct dt = DateTimeStruct.parseDate("2007-08-31");
        TestDateTimeParsing.check(dt, null, "2007", "08", "31", null);
    }

    @Test
    public void testGYear_1() {
        DateTimeStruct dt = DateTimeStruct.parseGYear("2007");
        TestDateTimeParsing.check(dt, null, "2007", null, null, null);
    }

    @Test
    public void testGYear_2() {
        DateTimeStruct dt = DateTimeStruct.parseGYear("2007Z");
        TestDateTimeParsing.check(dt, null, "2007", null, null, "Z");
    }

    @Test
    public void testGYear_3() {
        DateTimeStruct dt = DateTimeStruct.parseGYear("2007+08:00");
        TestDateTimeParsing.check(dt, null, "2007", null, null, "+08:00");
    }

    @Test
    public void testGYearMonth_1() {
        DateTimeStruct dt = DateTimeStruct.parseGYearMonth("2007-10");
        TestDateTimeParsing.check(dt, null, "2007", "10", null, null);
    }

    @Test
    public void testGYearMonth_2() {
        DateTimeStruct dt = DateTimeStruct.parseGYearMonth("2007-10Z");
        TestDateTimeParsing.check(dt, null, "2007", "10", null, "Z");
    }

    @Test
    public void testGYearMonth_3() {
        DateTimeStruct dt = DateTimeStruct.parseGYearMonth("2007-10-08:00");
        TestDateTimeParsing.check(dt, null, "2007", "10", null, "-08:00");
    }

    @Test
    public void testGMonth_1() {
        DateTimeStruct dt = DateTimeStruct.parseGMonth("--10");
        TestDateTimeParsing.check(dt, null, null, "10", null, null);
    }

    @Test
    public void testGMonth_2() {
        DateTimeStruct dt = DateTimeStruct.parseGMonth("--10Z");
        TestDateTimeParsing.check(dt, null, null, "10", null, "Z");
    }

    @Test
    public void testGMonth_3() {
        DateTimeStruct dt = DateTimeStruct.parseGMonth("--10-08:00");
        TestDateTimeParsing.check(dt, null, null, "10", null, "-08:00");
    }

    @Test
    public void testGMonthDay_1() {
        DateTimeStruct dt = DateTimeStruct.parseGMonthDay("--10-31");
        TestDateTimeParsing.check(dt, null, null, "10", "31", null);
    }

    @Test
    public void testGMonthDay_2() {
        DateTimeStruct dt = DateTimeStruct.parseGMonthDay("--10-31Z");
        TestDateTimeParsing.check(dt, null, null, "10", "31", "Z");
    }

    @Test
    public void testGMonthDay_3() {
        DateTimeStruct dt = DateTimeStruct.parseGMonthDay("--10-31-08:00");
        TestDateTimeParsing.check(dt, null, null, "10", "31", "-08:00");
    }

    @Test
    public void testGDay_1() {
        DateTimeStruct dt = DateTimeStruct.parseGDay("---31");
        TestDateTimeParsing.check(dt, null, null, null, "31", null);
    }

    @Test
    public void testGDay_2() {
        DateTimeStruct dt = DateTimeStruct.parseGDay("---31Z");
        TestDateTimeParsing.check(dt, null, null, null, "31", "Z");
    }

    @Test
    public void testGDay_3() {
        DateTimeStruct dt = DateTimeStruct.parseGDay("---31-08:00");
        TestDateTimeParsing.check(dt, null, null, null, "31", "-08:00");
    }

    private static void dateTimeTest(String str2) {
        DateTimeStruct dt = DateTimeStruct.parseDateTime(str2);
        Assert.assertTrue((boolean)dt.isDateTime());
        TestDateTimeParsing.check(dt);
        Assert.assertEquals((Object)str2, (Object)dt.toString());
    }

    private static void dateTimeBad(String str2) {
        try {
            DateTimeStruct dt = DateTimeStruct.parseDateTime(str2);
            Assert.fail((String)("No exception; " + str2));
        }
        catch (DateTimeStruct.DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
    }

    private static void dateTest(String str2) {
        DateTimeStruct dt = DateTimeStruct.parseDate(str2);
        Assert.assertTrue((boolean)dt.isDate());
        Assert.assertFalse((boolean)dt.isDateTime());
        TestDateTimeParsing.check(dt);
        Assert.assertEquals((Object)str2, (Object)dt.toString());
    }

    private static void dateBad(String str2) {
        try {
            DateTimeStruct dt = DateTimeStruct.parseDateTime(str2);
            Assert.fail((String)("No exception; " + str2));
        }
        catch (DateTimeStruct.DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
    }

    private static void check(DateTimeStruct dt) {
        Assert.assertTrue((dt.neg == null || dt.neg.equals("-") ? 1 : 0) != 0);
        if (dt.year != null) {
            Assert.assertEquals((long)4L, (long)dt.year.length());
        }
        if (dt.month != null) {
            Assert.assertEquals((long)2L, (long)dt.month.length());
        }
        if (dt.day != null) {
            Assert.assertEquals((long)2L, (long)dt.day.length());
        }
        if (dt.isDateTime()) {
            Assert.assertNotNull((Object)dt.hour);
            Assert.assertEquals((long)2L, (long)dt.hour.length());
            Assert.assertNotNull((Object)dt.minute);
            Assert.assertEquals((long)2L, (long)dt.minute.length());
            Assert.assertNotNull((Object)dt.second);
            Assert.assertTrue((dt.hour.length() >= 0 ? 1 : 0) != 0);
        } else {
            Assert.assertNull((Object)dt.hour);
            Assert.assertNull((Object)dt.minute);
            Assert.assertNull((Object)dt.second);
        }
        Assert.assertTrue((dt.timezone == null || dt.timezone.equals("Z") || dt.timezone.length() == 6 ? 1 : 0) != 0);
    }

    private static void check(DateTimeStruct dt, String neg, String year, String month, String day, String hour, String minute, String second, String timezone2) {
        TestDateTimeParsing.check(dt);
        Assert.assertEquals((Object)neg, (Object)dt.neg);
        Assert.assertEquals((Object)year, (Object)dt.year);
        Assert.assertEquals((Object)month, (Object)dt.month);
        Assert.assertEquals((Object)day, (Object)dt.day);
        Assert.assertEquals((Object)hour, (Object)dt.hour);
        Assert.assertEquals((Object)minute, (Object)dt.minute);
        Assert.assertEquals((Object)second, (Object)dt.second);
        Assert.assertEquals((Object)timezone2, (Object)dt.timezone);
    }

    private static void check(DateTimeStruct dt, String neg, String year, String month, String day, String timezone2) {
        TestDateTimeParsing.check(dt, neg, year, month, day, null, null, null, timezone2);
    }
}

