/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.transaction;

import java.util.ArrayList;
import org.apache.jena.atlas.lib.Creator;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.DatasetGraphSink;
import org.apache.jena.sparql.core.DatasetGraphZero;
import org.apache.jena.sparql.graph.GraphFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestTransactionSupport {
    private final Creator<DatasetGraph> maker;
    private final boolean supportsTxn;
    private final boolean supportsAbort;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> data() {
        ArrayList<Object[]> x = new ArrayList<Object[]>();
        x.add(new Object[]{"createTxnMem", () -> DatasetGraphFactory.createTxnMem(), true, true});
        x.add(new Object[]{"createGeneral", () -> DatasetGraphFactory.createGeneral(), true, false});
        x.add(new Object[]{"create", () -> DatasetGraphFactory.create(), true, false});
        x.add(new Object[]{"wrap(Graph)", () -> DatasetGraphFactory.wrap(GraphFactory.createDefaultGraph()), true, false});
        x.add(new Object[]{"zero", () -> new DatasetGraphZero(), true, true});
        x.add(new Object[]{"sink", () -> new DatasetGraphSink(), true, true});
        x.add(new Object[]{"create(Graph)", () -> DatasetGraphFactory.create(GraphFactory.createDefaultGraph()), true, false});
        return x;
    }

    public TestTransactionSupport(String name, Creator<DatasetGraph> maker, boolean supportsTxn, boolean supportsAbort) {
        this.maker = maker;
        this.supportsTxn = supportsTxn;
        this.supportsAbort = supportsAbort;
    }

    @Test
    public void txn_support() {
        DatasetGraph dsg = this.maker.create();
        TestTransactionSupport.test(dsg, this.supportsTxn, this.supportsAbort);
    }

    private static void test(DatasetGraph dsg, boolean supportsTxn, boolean supportsAbort) {
        Assert.assertEquals((String)"supports", (Object)supportsTxn, (Object)dsg.supportsTransactions());
        Assert.assertEquals((String)"supportsAbort", (Object)supportsAbort, (Object)dsg.supportsTransactionAbort());
    }
}

