/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.transaction;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.Transactional;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public abstract class AbstractTestTransactionLifecycle {
    protected abstract Dataset create();

    protected boolean supportsAbort() {
        return true;
    }

    protected boolean supportsPromote() {
        return true;
    }

    @Test
    public void transaction_00() {
        Dataset ds = this.create();
        Assert.assertTrue((boolean)ds.supportsTransactions());
    }

    @Test
    public void transaction_r01() {
        Dataset ds = this.create();
        ds.begin(TxnType.READ);
        Assert.assertTrue((boolean)ds.isInTransaction());
        ds.end();
        Assert.assertFalse((boolean)ds.isInTransaction());
    }

    @Test
    public void transaction_r02() {
        Dataset ds = this.create();
        ds.begin(TxnType.READ);
        Assert.assertTrue((boolean)ds.isInTransaction());
        ds.commit();
        Assert.assertFalse((boolean)ds.isInTransaction());
        ds.end();
        Assert.assertFalse((boolean)ds.isInTransaction());
    }

    @Test
    public void transaction_r03() {
        Dataset ds = this.create();
        ds.begin(TxnType.READ);
        Assert.assertTrue((boolean)ds.isInTransaction());
        ds.abort();
        Assert.assertFalse((boolean)ds.isInTransaction());
        ds.end();
        Assert.assertFalse((boolean)ds.isInTransaction());
    }

    @Test
    public void transaction_r04() {
        Dataset ds = this.create();
        ds.begin(ReadWrite.READ);
        Assert.assertTrue((boolean)ds.isInTransaction());
        ds.end();
        Assert.assertFalse((boolean)ds.isInTransaction());
    }

    @Test
    public void transaction_w01() {
        Dataset ds = this.create();
        ds.begin(TxnType.WRITE);
        Assert.assertTrue((boolean)ds.isInTransaction());
        ds.commit();
        Assert.assertFalse((boolean)ds.isInTransaction());
    }

    @Test
    public void transaction_w02() {
        Dataset ds = this.create();
        ds.begin(ReadWrite.WRITE);
        Assert.assertTrue((boolean)ds.isInTransaction());
        ds.commit();
        Assert.assertFalse((boolean)ds.isInTransaction());
    }

    @Test
    public void transaction_w03() {
        Assume.assumeTrue((boolean)this.supportsAbort());
        Dataset ds = this.create();
        ds.begin(TxnType.WRITE);
        Assert.assertTrue((boolean)ds.isInTransaction());
        ds.abort();
        Assert.assertFalse((boolean)ds.isInTransaction());
    }

    @Test
    public void transaction_w04() {
        Dataset ds = this.create();
        ds.begin(TxnType.WRITE);
        Assert.assertTrue((boolean)ds.isInTransaction());
        ds.commit();
        Assert.assertFalse((boolean)ds.isInTransaction());
        ds.end();
        Assert.assertFalse((boolean)ds.isInTransaction());
    }

    @Test
    public void transaction_w05() {
        Assume.assumeTrue((boolean)this.supportsAbort());
        Dataset ds = this.create();
        ds.begin(TxnType.WRITE);
        Assert.assertTrue((boolean)ds.isInTransaction());
        ds.abort();
        Assert.assertFalse((boolean)ds.isInTransaction());
        ds.end();
        Assert.assertFalse((boolean)ds.isInTransaction());
    }

    @Test
    public void transaction_w06() {
        Assume.assumeTrue((boolean)this.supportsAbort());
        Dataset ds = this.create();
        ds.begin(TxnType.WRITE);
        Assert.assertTrue((boolean)ds.isInTransaction());
        ds.abort();
        Assert.assertFalse((boolean)ds.isInTransaction());
        ds.begin(TxnType.WRITE);
        Assert.assertTrue((boolean)ds.isInTransaction());
        ds.abort();
        Assert.assertFalse((boolean)ds.isInTransaction());
    }

    @Test
    public void transaction_p01() {
        Assume.assumeTrue((boolean)this.supportsPromote());
        Dataset ds = this.create();
        ds.begin(TxnType.READ_PROMOTE);
        Assert.assertEquals((Object)((Object)TxnType.READ_PROMOTE), (Object)((Object)ds.transactionType()));
        Assert.assertTrue((boolean)ds.isInTransaction());
        Assert.assertEquals((Object)((Object)ReadWrite.READ), (Object)((Object)ds.transactionMode()));
        ds.promote();
        Assert.assertEquals((Object)((Object)ReadWrite.WRITE), (Object)((Object)ds.transactionMode()));
        ds.commit();
        ds.end();
    }

    @Test
    public void transaction_p02() {
        Assume.assumeTrue((boolean)this.supportsPromote());
        Dataset ds = this.create();
        ds.begin(TxnType.READ_COMMITTED_PROMOTE);
        Assert.assertEquals((Object)((Object)TxnType.READ_COMMITTED_PROMOTE), (Object)((Object)ds.transactionType()));
        Assert.assertTrue((boolean)ds.isInTransaction());
        Assert.assertEquals((Object)((Object)ReadWrite.READ), (Object)((Object)ds.transactionMode()));
        boolean b = ds.promote();
        Assert.assertTrue((boolean)b);
        Assert.assertEquals((Object)((Object)ReadWrite.WRITE), (Object)((Object)ds.transactionMode()));
        ds.commit();
        ds.end();
    }

    @Test
    public void transaction_p03() {
        Assume.assumeTrue((boolean)this.supportsPromote());
        Dataset ds = this.create();
        ds.begin(TxnType.READ_PROMOTE);
        Assert.assertTrue((boolean)ds.isInTransaction());
        Assert.assertEquals((Object)((Object)ReadWrite.READ), (Object)((Object)ds.transactionMode()));
        boolean b = ds.promote();
        Assert.assertTrue((boolean)b);
        Assert.assertEquals((Object)((Object)ReadWrite.WRITE), (Object)((Object)ds.transactionMode()));
        ds.abort();
        ds.end();
        Assert.assertFalse((boolean)ds.isInTransaction());
    }

    @Test
    public void transaction_p04() {
        Assume.assumeTrue((boolean)this.supportsPromote());
        Dataset ds = this.create();
        ds.begin(TxnType.READ_COMMITTED_PROMOTE);
        Assert.assertTrue((boolean)ds.isInTransaction());
        Assert.assertEquals((Object)((Object)ReadWrite.READ), (Object)((Object)ds.transactionMode()));
        boolean b = ds.promote();
        Assert.assertTrue((boolean)b);
        Assert.assertEquals((Object)((Object)ReadWrite.WRITE), (Object)((Object)ds.transactionMode()));
        ds.abort();
        ds.end();
        Assert.assertFalse((boolean)ds.isInTransaction());
    }

    @Test
    public void transaction_p05() {
        Assume.assumeTrue((boolean)this.supportsPromote());
        Dataset ds = this.create();
        ds.begin(TxnType.READ_COMMITTED_PROMOTE);
        Assert.assertTrue((boolean)ds.isInTransaction());
        boolean b1 = ds.promote();
        Assert.assertTrue((boolean)b1);
        boolean b2 = ds.promote();
        Assert.assertTrue((boolean)b2);
        ds.commit();
        ds.end();
    }

    @Test
    public void transaction_p06_err() {
        Assume.assumeTrue((boolean)this.supportsPromote());
        Dataset ds = this.create();
        ds.begin(TxnType.READ);
        Assert.assertTrue((boolean)ds.isInTransaction());
        boolean b1 = ds.promote();
        Assert.assertFalse((boolean)b1);
        boolean b2 = ds.promote();
        Assert.assertFalse((boolean)b2);
        ds.end();
    }

    @Test
    public void transaction_p10() {
        this.transaction_promote_write(TxnType.READ_COMMITTED_PROMOTE);
    }

    @Test
    public void transaction_p11() {
        this.transaction_promote_write(TxnType.READ_PROMOTE);
    }

    private void testPromote(TxnType txnType, Transactional.Promote promoteMode, boolean succeeds) {
        Dataset ds = this.create();
        ds.begin(txnType);
        Assert.assertTrue((boolean)ds.isInTransaction());
        boolean b1 = ds.promote(promoteMode);
        Assert.assertEquals((Object)succeeds, (Object)b1);
        boolean b2 = ds.promote(promoteMode);
        Assert.assertEquals((String)"Try same promote again", (Object)b1, (Object)b2);
        ds.commit();
        ds.end();
    }

    @Test
    public void transaction_promote_write_isolated() {
        Assume.assumeTrue((boolean)this.supportsPromote());
        this.testPromote(TxnType.WRITE, Transactional.Promote.ISOLATED, true);
    }

    @Test
    public void transaction_promote_write_readCommitted() {
        Assume.assumeTrue((boolean)this.supportsPromote());
        this.testPromote(TxnType.WRITE, Transactional.Promote.READ_COMMITTED, true);
    }

    @Test
    public void transaction_promote_read_isolated() {
        Assume.assumeTrue((boolean)this.supportsPromote());
        this.testPromote(TxnType.READ, Transactional.Promote.ISOLATED, false);
    }

    @Test
    public void transaction_promote_read_readCommitted() {
        Assume.assumeTrue((boolean)this.supportsPromote());
        this.testPromote(TxnType.READ, Transactional.Promote.READ_COMMITTED, false);
    }

    @Test
    public void transaction_promote_readPromote_isolated() {
        Assume.assumeTrue((boolean)this.supportsPromote());
        this.testPromote(TxnType.READ_PROMOTE, Transactional.Promote.ISOLATED, true);
    }

    @Test
    public void transaction_promote_readPromote_committed() {
        Assume.assumeTrue((boolean)this.supportsPromote());
        this.testPromote(TxnType.READ_PROMOTE, Transactional.Promote.READ_COMMITTED, true);
    }

    @Test
    public void transaction_promote_readCommitted_isolated() {
        Assume.assumeTrue((boolean)this.supportsPromote());
        this.testPromote(TxnType.READ_COMMITTED_PROMOTE, Transactional.Promote.ISOLATED, true);
    }

    @Test
    public void transaction_promote_readCommitted_readCommitted() {
        Assume.assumeTrue((boolean)this.supportsPromote());
        this.testPromote(TxnType.READ_COMMITTED_PROMOTE, Transactional.Promote.READ_COMMITTED, true);
    }

    @Test
    public void transaction_read_promote() {
        Assume.assumeTrue((boolean)this.supportsPromote());
        Dataset ds = this.create();
        ds.begin(TxnType.READ);
        boolean b = ds.promote();
        Assert.assertFalse((boolean)b);
        ds.commit();
        ds.end();
    }

    private void transaction_promote_write(TxnType txnType) {
        Dataset ds = this.create();
        ds.begin(txnType);
        ds.promote();
        ds.commit();
        ds.end();
        ds.begin(TxnType.WRITE);
        ds.commit();
        ds.end();
    }

    @Test
    public void transaction_pattern_01() {
        Dataset ds = this.create();
        this.read1(ds);
        this.read1(ds);
    }

    @Test
    public void transaction_pattern_02() {
        Dataset ds = this.create();
        this.read2(ds);
        this.read2(ds);
    }

    @Test
    public void transaction_pattern_03() {
        Dataset ds = this.create();
        this.write(ds);
        this.write(ds);
    }

    @Test
    public void transaction_pattern_04() {
        Dataset ds = this.create();
        this.write(ds);
        this.read2(ds);
        this.read2(ds);
        this.write(ds);
        this.read2(ds);
    }

    @Test(expected=JenaTransactionException.class)
    public void transaction_err_nontxn_commit_1() {
        Dataset ds = this.create();
        ds.commit();
    }

    @Test(expected=JenaTransactionException.class)
    public void transaction_err_nontxn_commit_2() {
        Dataset ds = this.create();
        ds.begin(TxnType.READ);
        ds.end();
        ds.commit();
    }

    @Test(expected=JenaTransactionException.class)
    public void transaction_err_nontxn_commit_3() {
        Dataset ds = this.create();
        ds.begin(TxnType.WRITE);
        ds.end();
        ds.commit();
    }

    @Test(expected=JenaTransactionException.class)
    public void transaction_err_nontxn_abort_1() {
        Dataset ds = this.create();
        ds.abort();
    }

    @Test(expected=JenaTransactionException.class)
    public void transaction_err_nontxn_abort_2() {
        Dataset ds = this.create();
        ds.begin(TxnType.READ);
        ds.end();
        ds.abort();
    }

    @Test(expected=JenaTransactionException.class)
    public void transaction_err_nontxn_abort_3() {
        Dataset ds = this.create();
        ds.begin(TxnType.WRITE);
        ds.end();
        ds.abort();
    }

    @Test
    public void transaction_err_01() {
        this.testBeginBegin(TxnType.WRITE, TxnType.WRITE);
    }

    @Test
    public void transaction_err_02() {
        this.testBeginBegin(TxnType.WRITE, TxnType.READ);
    }

    @Test
    public void transaction_err_03() {
        this.testBeginBegin(TxnType.READ, TxnType.READ);
    }

    @Test
    public void transaction_err_04() {
        this.testBeginBegin(TxnType.READ, TxnType.WRITE);
    }

    @Test
    public void transaction_err_05() {
        this.testCommitCommit(TxnType.READ);
    }

    @Test
    public void transaction_err_06() {
        this.testCommitCommit(TxnType.WRITE);
    }

    @Test
    public void transaction_err_07() {
        this.testCommitAbort(TxnType.READ);
    }

    @Test
    public void transaction_err_08() {
        this.testCommitAbort(TxnType.WRITE);
    }

    @Test
    public void transaction_err_09() {
        this.testAbortAbort(TxnType.READ);
    }

    @Test
    public void transaction_err_10() {
        this.testAbortAbort(TxnType.WRITE);
    }

    @Test
    public void transaction_err_11() {
        this.testAbortCommit(TxnType.READ);
    }

    @Test
    public void transaction_err_12() {
        this.testAbortCommit(TxnType.WRITE);
    }

    private void read1(Dataset ds) {
        ds.begin(TxnType.READ);
        Assert.assertTrue((boolean)ds.isInTransaction());
        ds.commit();
        Assert.assertFalse((boolean)ds.isInTransaction());
        ds.end();
    }

    private void read2(Dataset ds) {
        ds.begin(TxnType.READ);
        Assert.assertTrue((boolean)ds.isInTransaction());
        ds.end();
        Assert.assertFalse((boolean)ds.isInTransaction());
    }

    private void write(Dataset ds) {
        ds.begin(TxnType.WRITE);
        Assert.assertTrue((boolean)ds.isInTransaction());
        ds.commit();
        Assert.assertFalse((boolean)ds.isInTransaction());
        ds.end();
    }

    private static void safeEnd(Dataset ds) {
        try {
            ds.end();
        }
        catch (JenaTransactionException jenaTransactionException) {
            // empty catch block
        }
    }

    private void testBeginBegin(TxnType txnType1, TxnType txnType2) {
        Dataset ds = this.create();
        ds.begin(txnType1);
        try {
            ds.begin(txnType2);
            Assert.fail((String)("Expected transaction exception - begin-begin (" + txnType1 + ", " + txnType2 + ")"));
        }
        catch (JenaTransactionException ex) {
            AbstractTestTransactionLifecycle.safeEnd(ds);
        }
    }

    private void testCommitCommit(TxnType txnType) {
        Dataset ds = this.create();
        ds.begin(txnType);
        ds.commit();
        try {
            ds.commit();
            Assert.fail((String)("Expected transaction exception - commit-commit(" + txnType + ")"));
        }
        catch (JenaTransactionException ex) {
            AbstractTestTransactionLifecycle.safeEnd(ds);
        }
    }

    private void testCommitAbort(TxnType txnType) {
        Assume.assumeTrue((boolean)this.supportsAbort());
        Dataset ds = this.create();
        ds.begin(txnType);
        ds.commit();
        try {
            ds.abort();
            Assert.fail((String)("Expected transaction exception - commit-abort(" + txnType + ")"));
        }
        catch (JenaTransactionException ex) {
            AbstractTestTransactionLifecycle.safeEnd(ds);
        }
    }

    private void testAbortAbort(TxnType txnType) {
        Assume.assumeTrue((boolean)this.supportsAbort());
        Dataset ds = this.create();
        ds.begin(txnType);
        ds.abort();
        try {
            ds.abort();
            Assert.fail((String)("Expected transaction exception - abort-abort(" + txnType + ")"));
        }
        catch (JenaTransactionException ex) {
            ds.end();
        }
    }

    private void testAbortCommit(TxnType txnType) {
        Assume.assumeTrue((boolean)this.supportsAbort());
        Dataset ds = this.create();
        ds.begin(txnType);
        ds.abort();
        try {
            ds.commit();
            Assert.fail((String)("Expected transaction exception - abort-commit(" + txnType + ")"));
        }
        catch (JenaTransactionException ex) {
            AbstractTestTransactionLifecycle.safeEnd(ds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public synchronized void transaction_concurrency_writer() throws InterruptedException, ExecutionException, TimeoutException {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        final AtomicLong counter = new AtomicLong(0L);
        try {
            final Dataset ds = this.create();
            Callable<Boolean> callable = new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    ds.begin(TxnType.WRITE);
                    long x = counter.incrementAndGet();
                    Lib.sleep(500);
                    long x1 = counter.get();
                    Assert.assertEquals((String)"Two writers in the transaction", (long)x, (long)x1);
                    ds.commit();
                    return true;
                }
            };
            Future<Boolean> f1 = executor.submit(callable);
            Future<Boolean> f2 = executor.submit(callable);
            Assert.assertTrue((boolean)f1.get(10L, TimeUnit.SECONDS));
            Assert.assertTrue((boolean)f2.get(1L, TimeUnit.SECONDS));
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public synchronized void transaction_concurrency_reader() throws InterruptedException, ExecutionException, TimeoutException {
        ExecutorService executor = Executors.newCachedThreadPool();
        final AtomicLong counter = new AtomicLong(0L);
        try {
            final Dataset ds = this.create();
            Callable<Boolean> callable = new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    ds.begin(TxnType.READ);
                    long x = counter.incrementAndGet();
                    Lib.sleep(1000);
                    ds.commit();
                    return true;
                }
            };
            ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
            for (int i = 0; i < 25; ++i) {
                futures.add(executor.submit(callable));
            }
            for (Future future : futures) {
                Assert.assertTrue((boolean)((Boolean)future.get(4L, TimeUnit.SECONDS)));
            }
        }
        finally {
            executor.shutdownNow();
        }
    }
}

