/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax.syntaxtransform;

import java.util.HashMap;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.syntax.syntaxtransform.QueryTransformOps;
import org.apache.jena.sparql.syntax.syntaxtransform.UpdateTransformOps;
import org.apache.jena.sparql.util.ModelUtils;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.junit.Assert;
import org.junit.Test;

public class TestSyntaxTransform {
    static final String PREFIX = "";

    @Test
    public void subst_query_01() {
        this.testQuery("SELECT * { }", "SELECT * {}", "o", "1");
    }

    @Test
    public void subst_query_02() {
        this.testQuery("SELECT ?x { }", "SELECT ?x {}", "o", "1");
    }

    @Test
    public void subst_query_03() {
        this.testQuery("SELECT ?o { }", "SELECT (1 as ?o) {}", "o", "1");
    }

    @Test
    public void subst_query_04() {
        this.testQuery("SELECT (?o AS ?z) { }", "SELECT (1 AS ?z) {}", "o", "1");
    }

    @Test
    public void subst_query_05() {
        this.testQuery("SELECT (?o+2 AS ?z) { }", "SELECT (1+2 AS ?z) {}", "o", "1");
    }

    @Test
    public void subst_query_09() {
        this.testQuery("SELECT * {?s ?p ?o}", "SELECT * {?s ?p 1}", "o", "1");
    }

    @Test
    public void subst_query_10() {
        this.testQuery("SELECT * { SELECT ?o {} }", "SELECT * { SELECT (1 as ?o) {}}", "o", "1");
    }

    @Test
    public void subst_query_11() {
        this.testQuery("SELECT * { ?s ?p ?o { SELECT ?x { ?x ?p ?o } } }", "SELECT * { ?s ?p 1  { SELECT ?x { ?x ?p 1 } } }", "o", "1");
    }

    @Test
    public void subst_query_20() {
        this.testQuery("SELECT * { ?s ?p ?g GRAPH ?g { ?s ?p ?g } }", "SELECT * { ?s ?p <urn:ex:graph> GRAPH <urn:ex:graph> { ?s ?p <urn:ex:graph> } }", "g", "<urn:ex:graph>");
    }

    @Test
    public void subst_query_21() {
        this.testQuery("SELECT * { ?s ?p ?srv SERVICE ?srv { ?s ?p ?srv}}", "SELECT * { ?s ?p <urn:ex:service> SERVICE <urn:ex:service> { ?s ?p <urn:ex:service>}}", "srv", "<urn:ex:service>");
    }

    @Test
    public void subst_query_30() {
        this.testQuery("CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o }", "CONSTRUCT { ?s ?p 1 } WHERE { ?s ?p 1 } ", "o", "1");
    }

    @Test
    public void subst_query_31() {
        this.testQuery("CONSTRUCT { GRAPH ?g { ?s ?p ?g } } WHERE { ?s ?p ?g }", "CONSTRUCT { GRAPH <urn:x:g> { ?s ?p <urn:x:g>} } WHERE { ?s ?p <urn:x:g> }", "g", "<urn:x:g>");
    }

    @Test
    public void subst_query_40() {
        this.testQuery("DESCRIBE ?o ?x", "DESCRIBE ?x <urn:x:obj>", "o", "<urn:x:obj>");
    }

    @Test
    public void subst_query_41() {
        this.testQuery("DESCRIBE ?o ?x WHERE { ?s ?p ?o } ", "DESCRIBE ?x <urn:x:obj> WHERE { ?s ?p <urn:x:obj> } ", "o", "<urn:x:obj>");
    }

    @Test
    public void subst_query_50() {
        this.testQuery("ASK { ?s ?p ?o } ", "ASK { ?s ?p <urn:x:obj> } ", "o", "<urn:x:obj>");
    }

    @Test
    public void subst_query_model_1() {
        this.testQuery("SELECT * { ?s ?p ?o } ORDER BY ?s", "SELECT * { <urn:ex:z> ?p ?o } ORDER BY (<urn:ex:z>)", "s", "<urn:ex:z>");
    }

    @Test
    public void subst_query_model_2() {
        this.testQueryModel("SELECT * { ?s ?p ?o } ORDER BY ?s", "SELECT * { <urn:ex:z> ?p ?o } ORDER BY (<urn:ex:z>)", "s", "<urn:ex:z>");
    }

    @Test
    public void subst_update_01() {
        this.testUpdate("DELETE { ?s <urn:ex:p> ?x } WHERE {}", "DELETE { ?s <urn:ex:p> <urn:ex:z> } WHERE {}", "x", "<urn:ex:z>");
    }

    @Test
    public void subst_update_02() {
        this.testUpdate("DELETE { ?s <urn:ex:p> ?x } WHERE { ?s <urn:ex:p> ?x }", "DELETE { ?s <urn:ex:p> <urn:ex:z> } WHERE { ?s <urn:ex:p> <urn:ex:z> }", "x", "<urn:ex:z>");
    }

    @Test
    public void subst_update_03() {
        this.testUpdate("DELETE { ?s <urn:ex:p> ?x } INSERT { ?s <urn:ex:p> ?x } WHERE { ?s <urn:ex:p> ?x }", "DELETE { ?s <urn:ex:p> <urn:ex:z> } INSERT { ?s <urn:ex:p> <urn:ex:z> } WHERE { ?s <urn:ex:p> <urn:ex:z> }", "x", "<urn:ex:z>");
    }

    @Test
    public void subst_update_09() {
        this.testUpdate("DELETE WHERE { ?s <urn:ex:p> ?x }", "DELETE WHERE { ?s <urn:ex:p> <urn:ex:z> }", "x", "<urn:ex:z>");
    }

    @Test
    public void subst_update_10() {
        this.testUpdateModel("DELETE WHERE { ?s <urn:ex:p> ?x }", "DELETE WHERE { ?s <urn:ex:p> <urn:ex:z> }", "x", "<urn:ex:z>");
    }

    private void testQuery(String input, String output, String varStr, String valStr) {
        Query q1 = QueryFactory.create(input);
        Query qExpected = QueryFactory.create(output);
        HashMap<Var, Node> map = new HashMap<Var, Node>();
        map.put(Var.alloc(varStr), SSE.parseNode(valStr));
        Query qTrans = QueryTransformOps.transform(q1, map);
        if (!qExpected.equals(qTrans)) {
            System.out.println(qExpected.getProject());
            System.out.print(qExpected);
            System.out.println(qTrans.getProject());
            System.out.print(qTrans);
        }
        Assert.assertEquals((Object)qExpected, (Object)qTrans);
    }

    private void testQueryModel(String input, String output, String varStr, String valStr) {
        Query q1 = QueryFactory.create(input);
        Query qExpected = QueryFactory.create(output);
        HashMap<String, RDFNode> map = new HashMap<String, RDFNode>();
        Node n = SSE.parseNode(valStr);
        RDFNode x = ModelUtils.convertGraphNodeToRDFNode(n);
        map.put(varStr, x);
        Query qTrans = QueryTransformOps.transformQuery(q1, map);
        Assert.assertEquals((Object)qExpected, (Object)qTrans);
    }

    private void testUpdate(String input, String output, String varStr, String valStr) {
        UpdateRequest req1 = UpdateFactory.create(input);
        UpdateRequest reqExpected = UpdateFactory.create(output);
        HashMap<Var, Node> map = new HashMap<Var, Node>();
        map.put(Var.alloc(varStr), SSE.parseNode(valStr));
        UpdateRequest reqTrans = UpdateTransformOps.transform(req1, map);
        String x1 = reqExpected.toString().replaceAll("[ \n\t]", PREFIX);
        String x2 = reqTrans.toString().replaceAll("[ \n\t]", PREFIX);
        Assert.assertEquals((Object)x1, (Object)x2);
    }

    private void testUpdateModel(String input, String output, String varStr, String valStr) {
        UpdateRequest req1 = UpdateFactory.create(input);
        UpdateRequest reqExpected = UpdateFactory.create(output);
        HashMap<String, RDFNode> map = new HashMap<String, RDFNode>();
        Node n = SSE.parseNode(valStr);
        RDFNode x = ModelUtils.convertGraphNodeToRDFNode(n);
        map.put(varStr, x);
        UpdateRequest reqTrans = UpdateTransformOps.transformUpdate(req1, map);
        String x1 = reqExpected.toString().replaceAll("[ \n\t]", PREFIX);
        String x2 = reqTrans.toString().replaceAll("[ \n\t]", PREFIX);
        Assert.assertEquals((Object)x1, (Object)x2);
    }
}

