/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax.syntaxtransform;

import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformCleanGroupsOfOne;
import org.apache.jena.sparql.syntax.syntaxtransform.QueryTransformOps;
import org.junit.Assert;
import org.junit.Test;

public class TestFlattenSyntax {
    static String PRE = "PREFIX : <http://example/>\n";

    @Test
    public void test_flatten_basic_01() {
        TestFlattenSyntax.test(":s0 :p :o .", null);
    }

    @Test
    public void test_flatten_basic_02() {
        TestFlattenSyntax.test("{ :s1 :p :o }", ":s1 :p :o");
    }

    @Test
    public void test_flatten_basic_03() {
        TestFlattenSyntax.test("{{ :s2 :p :o }}", ":s2 :p :o");
    }

    @Test
    public void test_flatten_basic_04() {
        TestFlattenSyntax.test("{{{ :s3 :p :o }}}", ":s3 :p :o");
    }

    @Test
    public void test_flatten_filter_01() {
        TestFlattenSyntax.test(":s0 :p :o .{FILTER(?x)}", null);
    }

    @Test
    public void test_flatten_fileter_02() {
        TestFlattenSyntax.test("{ :s1 :p :o {FILTER(?x)} }", ":s1 :p :o {FILTER(?x)}");
    }

    @Test
    public void test_flatten_filter_03() {
        TestFlattenSyntax.test("{{ :s1 :p :o {FILTER(?x)}}}", " :s1 :p :o {FILTER(?x)}");
    }

    @Test
    public void test_flatten_optional_01() {
        TestFlattenSyntax.test("OPTIONAL{ ?s1 :q ?z }", null);
    }

    @Test
    public void test_flatten_optional_02() {
        TestFlattenSyntax.test("OPTIONAL{{?s2 :q ?z}}", "OPTIONAL{?s2 :q ?z}");
    }

    @Test
    public void test_flatten_optional_03() {
        TestFlattenSyntax.test("OPTIONAL{?s1f :q ?z FILTER(?z) }", null);
    }

    @Test
    public void test_flatten_optional_04() {
        TestFlattenSyntax.test("OPTIONAL{{?S2 :q ?z FILTER(?z) }}", null);
    }

    @Test
    public void test_flatten_optional_05() {
        TestFlattenSyntax.test("OPTIONAL{{{?S3 :q ?z FILTER(?z) }}}", "OPTIONAL{{?S3 :q ?z FILTER(?z) }}");
    }

    @Test
    public void test_flatten_optional_06() {
        TestFlattenSyntax.test("OPTIONAL{?sx :q ?z {FILTER(?z)} }", null);
    }

    @Test
    public void test_flatten_pattern_01() {
        TestFlattenSyntax.test("{?s :q ?z } UNION {?s :q ?z }", null);
    }

    @Test
    public void test_flatten_pattern_02() {
        TestFlattenSyntax.test("{{?s :q ?z}} UNION {?s :q ?z }", "{?s :q ?z} UNION {?s :q ?z }");
    }

    @Test
    public void test_flatten_pattern_03() {
        TestFlattenSyntax.test("{ ?s :q ?z} UNION {{?s :q ?z}}", "{?s :q ?z} UNION {?s :q ?z }");
    }

    @Test
    public void test_flatten_pattern_04() {
        TestFlattenSyntax.test("{{ ?s :q ?z } UNION {{?s :q ?z}}}", "{?s :q ?z} UNION {?s :q ?z }");
    }

    @Test
    public void test_flatten_expr_01() {
        TestFlattenSyntax.test("FILTER EXISTS { :s :p :o }", null);
    }

    @Test
    public void test_flatten_expr_02() {
        TestFlattenSyntax.test("FILTER EXISTS {{ :s :p :o }}", "FILTER EXISTS { :s :p :o }");
    }

    @Test
    public void test_flatten_arq_01() {
        TestFlattenSyntax.test("NOT EXISTS {{ :s :p :o FILTER(1) }}", "NOT EXISTS { :s :p :o  FILTER(1)}");
    }

    @Test
    public void test_flatten_arq_02() {
        TestFlattenSyntax.test("EXISTS {{ :s :p :o }}", "EXISTS { :s :p :o }");
    }

    private static void test(String input, String expected) {
        if (expected == null) {
            expected = input;
        }
        String qs = TestFlattenSyntax.gen(PRE, input);
        String qsExpected = TestFlattenSyntax.gen(PRE, expected);
        Query query2 = QueryFactory.create(qs, Syntax.syntaxARQ);
        Query query22 = QueryTransformOps.transform(query2, new ElementTransformCleanGroupsOfOne());
        Query queryExpected = QueryFactory.create(qsExpected, Syntax.syntaxARQ);
        Op op1 = Algebra.compile(query2);
        Op op2 = Algebra.compile(query22);
        Assert.assertEquals((String)"Algebra different", (Object)op1, (Object)op2);
        boolean modified = !query2.equals(query22);
        boolean expectModification = !queryExpected.equals(query2);
        Assert.assertEquals((String)"Expect query modifed?", (Object)expectModification, (Object)modified);
    }

    private static String gen(String PRE, String string) {
        return PRE + "\nSELECT * { " + string + "\n}";
    }
}

