/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse;

import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.TableFactory;
import org.apache.jena.sparql.algebra.op.OpLabel;
import org.apache.jena.sparql.algebra.op.OpNull;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_IsNumeric;
import org.apache.jena.sparql.expr.E_SameTerm;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.builders.BuilderNode;
import org.apache.jena.sparql.sse.builders.ExprBuildException;
import org.apache.jena.vocabulary.XSD;
import org.junit.Assert;
import org.junit.Test;

public class TestSSE_Builder {
    @Test
    public void test_01() {
        SSE.parseTriple("[triple ?s ?p ?o]");
    }

    @Test
    public void test_02() {
        SSE.parseTriple("[?s ?p ?o]");
    }

    @Test
    public void test_03() {
        SSE.parseTriple("[?s ?p ?o]");
    }

    @Test
    public void test_04() {
        SSE.parseTriple("(?s ?p ?o)");
    }

    @Test
    public void test_05() {
        SSE.parseQuad("(_ ?s ?p ?o)");
    }

    @Test
    public void test_06() {
        SSE.parseQuad("(quad _ ?s ?p ?o)");
    }

    @Test
    public void test_10() {
        SSE.parseExpr("1");
    }

    @Test
    public void test_11() {
        SSE.parseExpr("(+ 1 2)");
    }

    @Test
    public void testOp_01() {
        TestSSE_Builder.opSame("(null)");
    }

    @Test
    public void testOp_02() {
        TestSSE_Builder.opSame("(null)", OpNull.create());
    }

    @Test
    public void testOp_03() {
        TestSSE_Builder.opSame("(bgp [triple ?s ?p ?o])");
    }

    @Test
    public void testOp_04() {
        TestSSE_Builder.opSame("(label 'ABC' (table unit))", OpLabel.create("ABC", OpTable.unit()));
    }

    private static void opSame(String str2) {
        TestSSE_Builder.opSame(str2, SSE.parseOp(str2));
    }

    private static void opSame(String str2, Op other) {
        Op op = SSE.parseOp(str2);
        Assert.assertEquals((Object)op, (Object)other);
    }

    @Test
    public void testBuildInt_01() {
        Item item = SSE.parseItem("1");
        int i = BuilderNode.buildInt(item);
        Assert.assertEquals((long)1L, (long)i);
    }

    @Test
    public void testBuildInt_02() {
        Item item = SSE.parseItem("1");
        int i = BuilderNode.buildInt(item, 23);
        Assert.assertEquals((long)1L, (long)i);
    }

    @Test
    public void testBuildInt_03() {
        Item item = SSE.parseItem("_");
        int i = BuilderNode.buildInt(item, 23);
        Assert.assertEquals((long)23L, (long)i);
    }

    @Test
    public void testBuildNode_01() {
        Item item = SSE.parseItem("ANY");
        Node n = BuilderNode.buildNode(item);
        Assert.assertSame((Object)Node.ANY, (Object)n);
    }

    @Test
    public void testBuildNode_02() {
        Item item = SSE.parseItem("_");
        Node n = BuilderNode.buildNode(item);
        Assert.assertSame((Object)Node.ANY, (Object)n);
    }

    @Test
    public void testBuildNode_03() {
        Item item = SSE.parseItem("<http://example/>");
        Node n = BuilderNode.buildNode(item);
        Assert.assertTrue((boolean)n.isURI());
        Assert.assertEquals((Object)"http://example/", (Object)n.getURI());
    }

    @Test
    public void testBuildNode_04() {
        Item item = SSE.parseItem("<_:cba>");
        Node n = BuilderNode.buildNode(item);
        Assert.assertTrue((boolean)n.isBlank());
        Assert.assertEquals((Object)"cba", (Object)n.getBlankNodeLabel());
    }

    @Test
    public void testBuildNode_05() {
        Item item = SSE.parseItem("?variable");
        Node n = BuilderNode.buildNode(item);
        Assert.assertTrue((boolean)Var.isVar(n));
        Assert.assertEquals((Object)"variable", (Object)((Var)n).getVarName());
    }

    @Test
    public void testBuildNode_06() {
        Item item = SSE.parseItem("true");
        Node n = BuilderNode.buildNode(item);
        Assert.assertTrue((boolean)n.isLiteral());
        Assert.assertEquals((Object)"true", (Object)n.getLiteralLexicalForm());
        Assert.assertEquals((Object)XSD.xboolean.getURI(), (Object)n.getLiteralDatatype().getURI());
    }

    @Test
    public void testBuildLong_01() {
        Item item = SSE.parseItem("100000000000");
        long i = BuilderNode.buildLong(item);
        Assert.assertEquals((long)100000000000L, (long)i);
    }

    @Test
    public void testBuildLong_02() {
        Item item = SSE.parseItem("100000000000");
        long i = BuilderNode.buildLong(item, 23);
        Assert.assertEquals((long)100000000000L, (long)i);
    }

    @Test
    public void testBuildLong_03() {
        Item item = SSE.parseItem("_");
        long i = BuilderNode.buildLong(item, 23);
        Assert.assertEquals((long)23L, (long)i);
    }

    @Test
    public void testBuildExpr_01() {
        Expr e2 = SSE.parseExpr("(sameTerm (?x) (?y))");
        Assert.assertTrue((boolean)(e2 instanceof E_SameTerm));
    }

    @Test
    public void testBuildExpr_02() {
        Expr e2 = SSE.parseExpr("(isNumeric ?x)");
        Assert.assertTrue((boolean)(e2 instanceof E_IsNumeric));
    }

    private static void testExprForms(String str1, String str2) {
        Expr e1 = SSE.parseExpr(str1);
        Expr e2 = SSE.parseExpr(str2);
        Assert.assertEquals((String)(str1 + " " + str2), (Object)e1, (Object)e2);
    }

    @Test
    public void testBuildExpr_03() {
        TestSSE_Builder.testExprForms("(add ?x ?y)", "(+ ?x ?y)");
    }

    @Test
    public void testBuildExpr_04() {
        TestSSE_Builder.testExprForms("(subtract ?x ?y)", "(- ?x ?y)");
    }

    @Test
    public void testBuildExpr_05() {
        TestSSE_Builder.testExprForms("(multiply ?x ?y)", "(* ?x ?y)");
    }

    @Test
    public void testBuildExpr_06() {
        TestSSE_Builder.testExprForms("(divide ?x ?y)", "(/ ?x ?y)");
    }

    @Test
    public void testBuildExpr_07() {
        TestSSE_Builder.testExprForms("(lt ?x ?y)", "(< ?x ?y)");
    }

    @Test
    public void testBuildExpr_08() {
        TestSSE_Builder.testExprForms("(le ?x ?y)", "(<= ?x ?y)");
    }

    @Test
    public void testBuildExpr_09() {
        TestSSE_Builder.testExprForms("(gt ?x ?y)", "(> ?x ?y)");
    }

    @Test
    public void testBuildExpr_10() {
        TestSSE_Builder.testExprForms("(ge ?x ?y)", "(>= ?x ?y)");
    }

    @Test
    public void testBuildExpr_11() {
        TestSSE_Builder.testExprForms("(unaryplus ?x)", "(+ ?x)");
    }

    @Test
    public void testBuildExpr_12() {
        TestSSE_Builder.testExprForms("(unaryminus ?x)", "(- ?x)");
    }

    @Test
    public void testBuildExpr_13() {
        TestSSE_Builder.testExprForms("(eq ?x ?y)", "(= ?x ?y)");
    }

    @Test
    public void testBuildExpr_14() {
        TestSSE_Builder.testExprForms("(ne ?x ?y)", "(!= ?x ?y)");
    }

    @Test
    public void testBuildTable_01() {
        OpTable expected = OpTable.unit();
        Op actual = SSE.parseOp("(table unit)");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testBuildTable_02() {
        OpTable expected = OpTable.empty();
        Op actual = SSE.parseOp("(table empty)");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testBuildTable_03() {
        OpTable expected = OpTable.create(TableFactory.create(Var.alloc("x"), NodeConst.nodeTrue));
        Op actual = SSE.parseOp("(table (vars ?x) (row (?x true)))");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testBuildTable_04() {
        SSE.parseOp("(table (vars ?x) (row (?x _:test)))");
    }

    @Test(expected=ExprBuildException.class)
    public void testBuildTableBad_01() {
        SSE.parseOp("(table (vars ?x) (row (?x (table unit))))");
    }

    @Test(expected=ExprBuildException.class)
    public void testBuildTableBad_02() {
        SSE.parseOp("(table (vars ?x) (row (?x _)))");
    }
}

