/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse;

import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemException;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.junit.Assert;
import org.junit.Test;

public class TestSSE_Basic {
    static Node int1 = NodeFactory.createLiteral("1", XSDDatatype.XSDinteger);
    static Node int2 = NodeFactory.createLiteral("2", XSDDatatype.XSDinteger);
    static Node int3 = NodeFactory.createLiteral("3", XSDDatatype.XSDinteger);
    static Node strLangEN = NodeFactory.createLiteral("xyz", "en");
    static Node typeLit1 = NodeFactoryExtra.createLiteralNode("123", null, "http://example/type");
    static Item int1i = Item.createNode(int1);
    static Item int2i = Item.createNode(int2);
    static Item int3i = Item.createNode(int3);

    @Test
    public void testParseTerm_01() {
        this.parse("'xyz'");
    }

    @Test
    public void testParseTerm_02() {
        this.parse("'xyz'@en");
    }

    @Test
    public void testParseTerm_03() {
        this.parseBad("'xyz' @en");
    }

    @Test
    public void testParseSymbol_01() {
        this.parse("a");
    }

    @Test
    public void testParseSymbol_02() {
        this.parseBad("'a");
    }

    @Test
    public void testParseSymbol_04() {
        this.parse("a@");
    }

    @Test
    public void testParseList_01() {
        this.parse("()");
    }

    @Test
    public void testParseList_02() {
        this.parse("(a)");
    }

    @Test
    public void testParseList_03() {
        this.parse(" (a)");
    }

    @Test
    public void testParseList_04() {
        this.parse("( a)");
    }

    @Test
    public void testParseList_05() {
        this.parse("(a )");
    }

    @Test
    public void testParseList_06() {
        this.parse("(a) ");
    }

    @Test
    public void testParseList_07() {
        this.parse("('a') ");
    }

    @Test
    public void testParseList_08() {
        this.parse("(<a>) ");
    }

    @Test
    public void testParse_10() {
        this.parseBad("'foo' @en");
    }

    @Test
    public void testLit_01() {
        this.testNode("'foo'");
    }

    @Test
    public void testLit_02() {
        this.testNode("\"foo\"");
    }

    @Test
    public void testLit_03() {
        this.testNode("''");
    }

    @Test
    public void testLit_04() {
        this.testNode("\"\"");
    }

    @Test
    public void testLit_05() {
        this.testNode("'foo'@en");
    }

    @Test
    public void testLit_06() {
        this.parseBad("'foo' @en");
    }

    @Test
    public void testLit_07() {
        this.parseBad("'");
    }

    @Test
    public void testLit_08() {
        this.parseBad("'\"");
    }

    @Test
    public void testLit_09() {
        this.parseBad("'''");
    }

    @Test
    public void testLit_10() {
        this.parseBad("''@");
    }

    @Test
    public void testLit_11() {
        this.testNode("'''abc\\ndef'''");
    }

    @Test
    public void testLit_12() {
        Node n = NodeFactory.createLiteral("A\tB");
        this.testNode("'''A\\tB'''", n);
    }

    @Test
    public void testLit_13() {
        this.testNode("'abc\\ndef'");
    }

    @Test
    public void testNum_1() {
        this.testNode("1");
    }

    @Test
    public void testNum_2() {
        this.testNode("1.1");
    }

    @Test
    public void testNum_3() {
        this.testNode("1.0e6");
    }

    @Test
    public void testNum_4() {
        this.parseBadNode("1 ");
    }

    @Test
    public void testNum_5() {
        this.parseBadNode("1 1");
    }

    @Test
    public void testURI_1() {
        this.testNode("<http://example/base>");
    }

    @Test
    public void testURI_2() {
        this.parseBadNode("http://example/baseNoDelimiters");
    }

    @Test
    public void testURI_3() {
        this.parseBadNode("<http://example/ space>");
    }

    @Test
    public void testVar_01() {
        this.testVar("?x");
    }

    @Test
    public void testVar_02() {
        this.testVar("?");
    }

    @Test
    public void testVar_03() {
        this.testVar("?0");
    }

    @Test
    public void testVar_04() {
        this.testVar("??x");
    }

    @Test
    public void testVar_05() {
        this.testVar("??");
    }

    @Test
    public void testVar_06() {
        this.testVar("??0");
    }

    @Test
    public void testVar_07() {
        this.testVar("?.0");
    }

    @Test
    public void testVar_08() {
        this.testVar("?.");
    }

    @Test
    public void testVar_09() {
        Node v = this.parseNode("?");
        Assert.assertTrue((boolean)(v instanceof Var));
        String vn = ((Var)v).getVarName();
        Assert.assertFalse((boolean)vn.equals(""));
    }

    @Test
    public void testVar_10() {
        Node v = this.parseNode("??");
        Assert.assertTrue((boolean)(v instanceof Var));
        String vn = ((Var)v).getVarName();
        Assert.assertFalse((boolean)vn.equals("?"));
    }

    @Test
    public void testVar_11() {
        Node v = this.parseNode("?.");
        Assert.assertTrue((boolean)(v instanceof Var));
        String vn = ((Var)v).getVarName();
        Assert.assertFalse((boolean)vn.equals("."));
    }

    @Test
    public void testWS_1() {
        this.parseBadNode("?x ");
    }

    @Test
    public void testWS_2() {
        this.parseBadNode(" ?x");
    }

    @Test
    public void testNode_1() {
        this.testNode("3", int3);
    }

    @Test
    public void testNode_2() {
        this.testNode("<http://example/node1>", NodeFactory.createURI("http://example/node1"));
    }

    @Test
    public void testTypedLit_1() {
        this.testNode("\"123\"^^<http://example/type>", typeLit1);
    }

    @Test
    public void testTypedLit_2() {
        this.testNode("'123'^^<http://example/type>", typeLit1);
    }

    @Test
    public void testTypedLit_3() {
        this.testNode("'3'^^<" + XSDDatatype.XSDinteger.getURI() + ">", int3);
    }

    @Test
    public void testSymbol_1() {
        this.testSymbol("word");
    }

    @Test
    public void testSymbol_2() {
        this.testSymbol("+");
    }

    @Test
    public void testNil_1() {
        this.testItem("nil", Item.nil);
    }

    @Test
    public void testNil_2() {
        this.testNotItem("null", Item.nil);
    }

    @Test
    public void testNil_3() {
        this.testNotItem("()", Item.nil);
    }

    @Test
    public void testNil_4() {
        Item x = Item.createList();
        x.getList().add(Item.nil);
        this.testItem("(nil)", x);
    }

    @Test
    public void testList_1() {
        Item item = this.parse("()");
        Assert.assertTrue((boolean)item.isList());
        Assert.assertEquals((long)item.getList().size(), (long)0L);
    }

    @Test
    public void testList_2() {
        this.testList("(1)", int1i);
    }

    @Test
    public void testList_3() {
        this.testList("(1 2)", int1i, int2i);
    }

    @Test
    public void testList_4() {
        this.testList("(1 a)", int1i, Item.createSymbol("a"));
    }

    @Test
    public void testList_5() {
        Item list = Item.createList();
        list.getList().add(int1i);
        this.testList("((1) a)", list, Item.createSymbol("a"));
    }

    @Test
    public void testList_6() {
        this.testList("(+ 1)", Item.createSymbol("+"), int1i);
    }

    @Test
    public void testList_7() {
        this.testList("[+ 1]", Item.createSymbol("+"), int1i);
    }

    @Test
    public void testNum_01() {
        Item item = SSE.parse("1");
        Assert.assertEquals((long)1L, (long)item.getInt());
    }

    @Test
    public void testNum_02() {
        Item item = SSE.parse("3");
        Assert.assertEquals((double)3.0, (double)item.getDouble(), (double)0.0);
    }

    @Test
    public void testNum_03() {
        Item item = SSE.parse("2.5");
        Assert.assertEquals((double)2.5, (double)item.getDouble(), (double)0.0);
    }

    @Test
    public void testNum_04() {
        Item item = SSE.parse("abc");
        try {
            item.getInt();
            Assert.fail((String)"Succeeded where exceptiSSE.on expected");
        }
        catch (ItemException itemException) {
            // empty catch block
        }
    }

    @Test
    public void testNum_05() {
        Item item = SSE.parse("<x>");
        try {
            item.getInt();
            Assert.fail((String)"Succeeded where exception expected");
        }
        catch (ItemException itemException) {
            // empty catch block
        }
    }

    @Test
    public void testMisc_01() {
        this.testEquals("()");
    }

    @Test
    public void testMisc_02() {
        this.testEquals("(a)");
    }

    @Test
    public void testMisc_10() {
        this.testNotEquals("(a)", "a");
    }

    @Test
    public void testMisc_11() {
        this.testNotEquals("(a)", "()");
    }

    @Test
    public void testMisc_12() {
        this.testNotEquals("(a)", "(<a>)");
    }

    @Test
    public void testTripleTerm_1() {
        this.testNode("<< :s :p :o >>");
    }

    @Test
    public void testTripleTerm_2() {
        this.testNode("<<:s :p :o>>");
    }

    @Test
    public void testTripleTerm_3() {
        this.testNode("<< ?s ?p ?o >>");
    }

    @Test
    public void testTripleTerm_4() {
        this.testNode("<<<< :s :p :o >> :q << :s :p :o >>>>");
    }

    @Test
    public void testTripleTerm_10() {
        this.parseBad("<< :s :p :o ");
    }

    @Test
    public void testTripleTerm_11() {
        this.parseBad("<< :s >>");
    }

    @Test
    public void testTripleTerm_12() {
        this.parseBad("<< :s :p >>");
    }

    @Test
    public void testTripleTerm_13() {
        this.parseBad("<< <<:s :p :o >> :q >> ");
    }

    @Test
    public void testTaggedList_1() {
        Item x = Item.createTagged("TAG");
        Assert.assertTrue((boolean)x.isTagged());
        Assert.assertTrue((boolean)x.isTagged("TAG"));
    }

    @Test
    public void testTaggedList_2() {
        Item x = Item.createTagged("TAG");
        Item.addPair(x.getList(), "KEY", "VALUE");
        Item y = Item.find(x.getList(), "KEY");
        Assert.assertNotNull((Object)y);
        Item z = Item.find(x.getList(), "KEYKEY");
        Assert.assertNull((Object)z);
    }

    private void testEquals(String x) {
        Item item1 = this.parse(x);
        Item item2 = this.parse(x);
        Assert.assertTrue((boolean)item1.equals(item2));
        Assert.assertTrue((boolean)item2.equals(item1));
    }

    private void testNotEquals(String x1, String x2) {
        Item item1 = this.parse(x1);
        Item item2 = this.parse(x2);
        Assert.assertFalse((boolean)item1.equals(item2));
        Assert.assertFalse((boolean)item2.equals(item1));
    }

    private Item parse(String str2) {
        Item item = SSE.parse(str2);
        return item;
    }

    private void testSymbol(String str2) {
        Item item = this.parse(str2);
        Assert.assertTrue((boolean)item.isSymbol());
        Assert.assertEquals((Object)item.getSymbol(), (Object)str2);
    }

    private void testList(String str2, Item item1) {
        Item item = this.parse(str2);
        Assert.assertTrue((boolean)item.isList());
        Item i = item.getList().get(0);
        Assert.assertEquals((long)1L, (long)item.getList().size());
        Assert.assertEquals((Object)item.getList().get(0), (Object)item1);
    }

    private void testList(String str2, Item item1, Item item2) {
        Item item = this.parse(str2);
        Assert.assertTrue((boolean)item.isList());
        Assert.assertEquals((long)2L, (long)item.getList().size());
        Assert.assertEquals((Object)item.getList().get(0), (Object)item1);
        Assert.assertEquals((Object)item.getList().get(1), (Object)item2);
    }

    private void testList(String str2, Item item1, Item item2, Item item3) {
        Item item = this.parse(str2);
        Assert.assertTrue((boolean)item.isList());
        Assert.assertEquals((long)3L, (long)item.getList().size());
        Assert.assertEquals((Object)item.getList().get(0), (Object)item1);
        Assert.assertEquals((Object)item.getList().get(1), (Object)item2);
        Assert.assertEquals((Object)item.getList().get(2), (Object)item3);
    }

    private void testItem(String str2, Item result) {
        Item item = this.parse(str2);
        Assert.assertEquals((Object)result, (Object)item);
    }

    private void testNotItem(String str2, Item result) {
        Item item = this.parse(str2);
        Assert.assertFalse((boolean)result.equals(item));
    }

    private void testNode(String str2) {
        Node node = this.parseNode(str2);
    }

    private void testVar(String str2) {
        Node node = this.parseNode(str2);
        Assert.assertTrue((boolean)(node instanceof Var));
    }

    private void testNode(String str2, Node result) {
        Node node = this.parseNode(str2);
        Assert.assertEquals((Object)result, (Object)node);
    }

    private Node parseNode(String str2) {
        return SSE.parseNode(str2);
    }

    private void parseBad(String str2) {
        try {
            Item item = SSE.parse(str2);
            Assert.fail((String)"Did not get a parse failure");
        }
        catch (ARQException aRQException) {
            // empty catch block
        }
    }

    private void parseBadNode(String str2) {
        try {
            Node node = this.parseNode(str2);
            Assert.fail((String)"Did not get a parse failure");
        }
        catch (ARQException aRQException) {
            // empty catch block
        }
    }
}

