/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.sparql.resultset.ResultSetCompare;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.builders.BuilderResultSet;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestResultSetFormat1 {
    static String[] $rs0 = new String[]{"(resultset ())"};
    static String[] $rs1 = new String[]{"(resultset () (row))"};
    static String[] $rs2 = new String[]{"(resultset (?a ?b ?c)", "  (row (?a 1) (?b 2)       )", "  (row (?a 1) (?b 4) (?c 3))", ")"};
    static String[] $rs3 = new String[]{"(resultset (?a ?b ?c)", "  (row (?a 1) (?b 4) (?c 3))", "  (row (?a 1) (?b 2)       )", ")"};
    static String[] $rs4 = new String[]{"(resultset (?a ?b ?c)", "  (row (?a 1)        (?c 4))", "  (row (?a 1) (?b 2) (?c 3))", ")"};
    static String[] $rs5 = new String[]{"(resultset (?a ?b)", " (row (?a 1)       )", " (row        (?b 2))", ")"};
    static String[] $rs6 = new String[]{"(resultset (?x)", " (row (?x <" + RDF.type.toString() + ">))", " (row (?x <" + RDFS.label.toString() + ">))", " (row (?x <" + XSD.integer.toString() + ">))", " (row (?x <" + OWL.sameAs.toString() + ">))", " (row )", ")"};
    static String[] $rs7 = new String[]{"(resultset (?x) (row))"};
    static String[] $rs8 = new String[]{"(resultset (?x)", " (row (?x \"has \\t tab character\"))", ")"};
    static String[] $rs9 = new String[]{"(resultset (?x)", " (row (?x _:bnode))", ")"};
    static String[] $rs10 = new String[]{"(resultset (?x)", " (row (?x \"Includes a raw\ttab character\"))", ")"};
    static String[] $rs11 = new String[]{"(resultset (?x)", " (row (?x \"Includes \\n new line\"))", ")"};
    private final String[] $rs;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({$rs0}, {$rs1}, {$rs2}, {$rs3}, {$rs4}, {$rs5}, {$rs6}, {$rs7}, {$rs8}, {$rs9}, {$rs10}, {$rs11});
    }

    public TestResultSetFormat1(String[] rs) {
        this.$rs = rs;
    }

    static ResultSet make(String ... strings) {
        if (strings.length == 0) {
            throw new IllegalArgumentException();
        }
        String x = StrUtils.strjoinNL(strings);
        Item item = SSE.parse(x);
        return ResultSetFactory.makeRewindable(BuilderResultSet.build(item));
    }

    @Test
    public void resultset_01() {
        ResultSet rs = TestResultSetFormat1.make(this.$rs);
        ResultSetFormatter.asText(rs);
    }

    @Test
    public void resultset_02() {
        ResultSet rs = TestResultSetFormat1.make(this.$rs);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsXML((OutputStream)out, rs);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ResultSet rs2 = ResultSetFactory.fromXML(in);
        TestResultSetFormat1.areIsomorphic(rs, rs2);
    }

    @Test
    public void resultset_03() {
        ResultSet rs = TestResultSetFormat1.make(this.$rs);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON((OutputStream)out, rs);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ResultSet rs2 = ResultSetFactory.fromJSON(in);
        TestResultSetFormat1.areIsomorphic(rs, rs2);
    }

    @Test
    public void resultset_04() {
        ResultSet rs = TestResultSetFormat1.make(this.$rs);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsTSV((OutputStream)out, rs);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ResultSet rs2 = ResultSetFactory.fromTSV(in);
        TestResultSetFormat1.areIsomorphic(rs, rs2);
    }

    @Test
    public void resultset_05() {
        ResultSet rs = TestResultSetFormat1.make(this.$rs);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsCSV((OutputStream)out, rs);
    }

    private static void areIsomorphic(ResultSet x, ResultSet y) {
        ResultSetRewindable rs1 = x.rewindable();
        ResultSetRewindable rs2 = y.rewindable();
        Assert.assertTrue((boolean)ResultSetCompare.isomorphic(rs1, rs2));
    }
}

