/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.rw.ResultsReader;
import org.apache.jena.riot.resultset.rw.ResultsWriter;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.ResultSetStream;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.resultset.RDFInput;
import org.apache.jena.sparql.resultset.RDFOutput;
import org.apache.jena.sparql.resultset.ResultSetCompare;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.resultset.ResultSetMem;
import org.apache.jena.sparql.resultset.ResultSetPeekable;
import org.apache.jena.sparql.resultset.ResultSetPeeking;
import org.apache.jena.sparql.resultset.ResultsFormat;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.builders.BuilderResultSet;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.sparql.util.ResultSetUtils;
import org.apache.jena.sys.JenaSystem;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestResultSet {
    private static String DIR;
    private static String[] rs1$;
    private static String[] rs2$;
    static Context cxt;

    @BeforeClass
    public static void setup() {
        ResultSetPeeking.warnOnSyncErrors = false;
    }

    @AfterClass
    public static void teardown() {
        ResultSetPeeking.warnOnSyncErrors = true;
    }

    @Test
    public void test_RS_1() {
        ResultSetMem rs1 = new ResultSetMem();
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsXML((OutputStream)arr, rs1);
        rs1.reset();
        ByteArrayInputStream ins = new ByteArrayInputStream(arr.toByteArray());
        ResultSet rs2 = ResultSetFactory.fromXML(ins);
        Assert.assertTrue((boolean)ResultSetCompare.equalsByTerm(rs1, rs2));
    }

    @Test
    public void test_RS_1_str() {
        ResultSetMem rs1 = new ResultSetMem();
        String x = ResultSetFormatter.asXMLString(rs1);
        rs1.reset();
        ByteArrayInputStream in = new ByteArrayInputStream(StrUtils.asUTF8bytes(x));
        ResultSet rs2 = ResultSetFactory.fromXML(in);
        Assert.assertTrue((boolean)ResultSetCompare.equalsByTerm(rs1, rs2));
    }

    @Test
    public void test_RS_2() {
        ResultSetRewindable rs1 = this.makeRewindable("x", NodeFactory.createURI("tag:local"));
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsXML((OutputStream)arr, rs1);
        rs1.reset();
        ByteArrayInputStream ins = new ByteArrayInputStream(arr.toByteArray());
        ResultSet rs2 = ResultSetFactory.fromXML(ins);
        Assert.assertTrue((boolean)ResultSetCompare.equalsByTerm(rs1, rs2));
    }

    @Test
    public void test_RS_2_str() {
        ResultSetRewindable rs1 = this.makeRewindable("x", NodeFactory.createURI("tag:local"));
        String x = ResultSetFormatter.asXMLString(rs1);
        rs1.reset();
        ByteArrayInputStream in = new ByteArrayInputStream(StrUtils.asUTF8bytes(x));
        ResultSet rs2 = ResultSetFactory.fromXML(in);
        Assert.assertTrue((boolean)ResultSetCompare.equalsByTerm(rs1, rs2));
    }

    @Test
    public void test_RS_3() {
        ResultSetMem rs1 = new ResultSetMem();
        Model model = RDFOutput.encodeAsModel(rs1);
        rs1.reset();
        ResultSet rs2 = RDFInput.fromRDF(model);
        Assert.assertTrue((boolean)ResultSetCompare.equalsByTerm(rs1, rs2));
    }

    @Test
    public void test_RS_4() {
        ResultSetRewindable rs1 = this.makeRewindable("x", NodeFactory.createURI("tag:local"));
        Model model = RDFOutput.encodeAsModel(rs1);
        rs1.reset();
        ResultSetRewindable rs2 = ResultSetFactory.makeRewindable(RDFInput.fromRDF(model));
        boolean b = ResultSetCompare.equalsByTerm(rs1, rs2);
        if (!b) {
            rs1.reset();
            rs2.reset();
            ResultSetFormatter.out(rs1);
            ResultSetFormatter.out(rs2);
        }
        Assert.assertTrue((boolean)b);
    }

    @Test
    public void test_RS_5() {
        ResultSetMem rs1 = new ResultSetMem();
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON((OutputStream)arr, rs1);
        rs1.reset();
        ByteArrayInputStream ins = new ByteArrayInputStream(arr.toByteArray());
        ResultSet rs2 = ResultSetFactory.fromJSON(ins);
        Assert.assertTrue((boolean)ResultSetCompare.equalsByTerm(rs1, rs2));
    }

    @Test
    public void test_RS_6() {
        ResultSetRewindable rs1 = this.make2Rewindable("x", NodeFactory.createURI("tag:local"));
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON((OutputStream)arr, rs1);
        rs1.reset();
        ByteArrayInputStream ins = new ByteArrayInputStream(arr.toByteArray());
        ResultSet rs2 = ResultSetFactory.fromJSON(ins);
        Assert.assertTrue((boolean)ResultSetCompare.equalsByTerm(rs1, rs2));
    }

    @Test
    public void test_RS_7() {
        ResultSet rs = ResultSetFactory.load(DIR + "output.srx");
        this.test_RS_fmt(rs, ResultsFormat.FMT_RS_XML, true);
    }

    @Test
    public void test_RS_8() {
        ResultSet rs = ResultSetFactory.load(DIR + "output.srx");
        this.test_RS_fmt(rs, ResultsFormat.FMT_RS_JSON, true);
    }

    @Test
    public void test_RS_9() {
        ResultSet rs = ResultSetFactory.load(DIR + "output.srx");
        this.test_RS_fmt(rs, ResultsFormat.FMT_RDF_XML, false);
    }

    @Test
    public void test_RS_10() {
        ResultSet rs = ResultSetFactory.load(DIR + "output.srx");
        while (rs.hasNext()) {
            rs.next();
        }
        Assert.assertFalse((boolean)rs.hasNext());
    }

    @Test
    public void rs_xmllang_datatype_1() {
        ResultSetFactory.load(DIR + "rs-xmllang-datatype-1.srj");
    }

    @Test(expected=ResultSetException.class)
    public void rs_xmllang_datatype_2() {
        ResultSetFactory.load(DIR + "rs-xmllang-datatype-2.srj");
    }

    @Test
    public void rs_datatype_string() {
        ResultSet rs = ResultSetFactory.load(DIR + "rs-datatype-string.srj");
    }

    @Test
    public void test_RS_union_1() {
        ResultSet rs1 = this.make("x", NodeFactory.createURI("tag:local"));
        ResultSet rs2 = this.make("x", NodeFactory.createURI("tag:local"));
        ResultSet rs3 = this.make2("x", NodeFactory.createURI("tag:local"));
        Assert.assertTrue((boolean)ResultSetCompare.equalsByTerm(rs3, ResultSetUtils.union(rs1, rs2)));
    }

    @Test(expected=ResultSetException.class)
    public void test_RS_union_2() {
        ResultSet rs1 = this.make("x", NodeFactory.createURI("tag:local"));
        ResultSet rs2 = this.make("y", NodeFactory.createURI("tag:local"));
        ResultSetUtils.union(rs1, rs2);
    }

    private void test_RS_fmt(ResultSet rs, ResultsFormat fmt, boolean ordered) {
        ResultSetRewindable rs1 = ResultSetFactory.makeRewindable(rs);
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ResultSetFormatter.output((OutputStream)arr, (ResultSet)rs1, fmt);
        byte[] bytes = arr.toByteArray();
        rs1.reset();
        ByteArrayInputStream ins = new ByteArrayInputStream(bytes);
        ResultSetRewindable rs2 = ResultSetFactory.makeRewindable(ResultSetFactory.load(ins, fmt));
        boolean b = ResultSetCompare.equalsByTerm(rs1, rs2);
        if (ordered) {
            rs1.reset();
            rs2.reset();
            b &= ResultSetCompare.equalsByTerm(rs1, rs2);
        }
        if (!b) {
            System.out.println(new String(bytes));
            rs1.reset();
            rs2.reset();
            ResultSetFormatter.out(rs1);
            ResultSetFormatter.out(rs2);
        }
        Assert.assertTrue((boolean)b);
    }

    @Test
    public void test_RS_cmp_1() {
        ResultSetMem rs1 = new ResultSetMem();
        ResultSetMem rs2 = new ResultSetMem();
        Assert.assertTrue((boolean)ResultSetCompare.equalsByTerm(rs1, rs2));
        rs1.reset();
        rs2.reset();
        Assert.assertTrue((boolean)ResultSetCompare.equalsByTerm(rs1, rs2));
    }

    @Test
    public void test_RS_cmp_2() {
        ResultSet rs1 = this.make("x", NodeFactory.createURI("tag:local"));
        ResultSetMem rs2 = new ResultSetMem();
        Assert.assertFalse((boolean)ResultSetCompare.equalsByTerm(rs1, rs2));
    }

    @Test
    public void test_RS_cmp_3() {
        ResultSet rs1 = this.make("x", NodeFactory.createURI("tag:local"));
        ResultSetMem rs2 = new ResultSetMem();
        Assert.assertFalse((boolean)ResultSetCompare.equalsByTerm(rs1, rs2));
    }

    @Test
    public void test_RS_cmp_4() {
        ResultSet rs1 = this.make("x", NodeFactory.createURI("tag:local"));
        ResultSet rs2 = this.make("x", NodeFactory.createURI("tag:local"));
        Assert.assertTrue((boolean)ResultSetCompare.equalsByTerm(rs1, rs2));
        Assert.assertTrue((boolean)ResultSetCompare.equalsByTerm(rs1, rs2));
    }

    @Test
    public void test_RS_cmp_5() {
        ResultSetRewindable rs1 = this.makeRewindable("x", NodeFactory.createURI("tag:local:1"));
        ResultSetRewindable rs2 = this.makeRewindable("x", NodeFactory.createURI("tag:local:2"));
        Assert.assertFalse((boolean)ResultSetCompare.equalsByTerm(rs1, rs2));
        rs1.reset();
        rs2.reset();
        Assert.assertFalse((boolean)ResultSetCompare.equalsByTerm(rs1, rs2));
    }

    @Test
    public void test_RS_cmp_6() {
        ResultSetRewindable rs1 = this.makeRewindable("x", NodeFactory.createURI("tag:local"));
        ResultSetRewindable rs2 = this.makeRewindable("y", NodeFactory.createURI("tag:local"));
        Assert.assertFalse((boolean)ResultSetCompare.equalsByTermAndOrder(rs1, rs2));
        rs1.reset();
        rs2.reset();
        Assert.assertFalse((boolean)ResultSetCompare.equalsByTerm(rs1, rs2));
    }

    @Test
    public void test_RS_cmp_value_1() {
        ResultSetRewindable rs1 = this.makeRewindable("x", NodeFactoryExtra.parseNode("123"));
        ResultSetRewindable rs2 = this.makeRewindable("x", NodeFactoryExtra.parseNode("0123"));
        Assert.assertFalse((boolean)ResultSetCompare.equalsByTerm(rs1, rs2));
        Assert.assertTrue((boolean)ResultSetCompare.equalsByValue(rs1, rs2));
    }

    @Test
    public void test_RS_peeking_1() {
        ResultSetPeekable rs = this.makePeekable("x", NodeFactory.createURI("tag:local"));
        Assert.assertTrue((boolean)rs.hasNext());
        Assert.assertNotNull((Object)rs.peek());
        Assert.assertTrue((boolean)rs.hasNext());
        Assert.assertNotNull((Object)rs.next());
        Assert.assertFalse((boolean)rs.hasNext());
    }

    @Test(expected=NoSuchElementException.class)
    public void test_RS_peeking_2() {
        ResultSetPeekable rs = this.makePeekable("x", NodeFactory.createURI("tag:local"));
        Assert.assertTrue((boolean)rs.hasNext());
        Assert.assertNotNull((Object)rs.peek());
        Assert.assertTrue((boolean)rs.hasNext());
        Assert.assertNotNull((Object)rs.next());
        Assert.assertFalse((boolean)rs.hasNext());
        rs.peek();
    }

    @Test
    public void test_RS_peeking_3() {
        ResultSetPeekable rs = (ResultSetPeekable)((Object)this.makeRewindable("x", NodeFactory.createURI("tag:local")));
        Assert.assertTrue((boolean)rs.hasNext());
        Assert.assertNotNull((Object)rs.peek());
        Assert.assertTrue((boolean)rs.hasNext());
        Assert.assertNotNull((Object)rs.next());
        Assert.assertFalse((boolean)rs.hasNext());
    }

    @Test(expected=NoSuchElementException.class)
    public void test_RS_peeking_4() {
        ResultSetPeekable rs = (ResultSetPeekable)((Object)this.makeRewindable("x", NodeFactory.createURI("tag:local")));
        Assert.assertTrue((boolean)rs.hasNext());
        Assert.assertNotNull((Object)rs.peek());
        Assert.assertTrue((boolean)rs.hasNext());
        Assert.assertNotNull((Object)rs.next());
        Assert.assertFalse((boolean)rs.hasNext());
        rs.peek();
    }

    @Test
    public void test_RS_peeking_5() {
        ResultSetMem inner = new ResultSetMem(this.make("x", NodeFactory.createURI("tag:local")), this.make("x", NodeFactory.createURI("tag:local")));
        ResultSetPeekable rs = ResultSetFactory.makePeekable(inner);
        Assert.assertTrue((boolean)rs.hasNext());
        Assert.assertNotNull((Object)rs.peek());
        inner.next();
        Assert.assertFalse((boolean)rs.hasNext());
    }

    @Test
    public void test_RS_peeking_6() {
        ResultSetMem inner = new ResultSetMem(this.make("x", NodeFactory.createURI("tag:local")), this.make("x", NodeFactory.createURI("tag:local")), this.make("x", NodeFactory.createURI("tag:local")));
        ResultSetPeekable rs = ResultSetFactory.makePeekable(inner);
        Assert.assertTrue((boolean)rs.hasNext());
        Assert.assertNotNull((Object)rs.peek());
        inner.next();
        Assert.assertTrue((boolean)rs.hasNext());
    }

    @Test
    public void test_RS_peeking_7() {
        ResultSetRewindable inner = this.makeRewindable("x", NodeFactory.createURI("tag:local"));
        ResultSetPeekable rs = ResultSetFactory.makePeekable(inner);
        Assert.assertTrue((boolean)rs.hasNext());
        Assert.assertNotNull((Object)rs.peek());
        inner.reset();
        Assert.assertTrue((boolean)rs.hasNext());
    }

    @Test(expected=IllegalStateException.class)
    public void test_RS_peeking_8() {
        ResultSetMem inner = new ResultSetMem(this.make("x", NodeFactory.createURI("tag:local")), this.make("x", NodeFactory.createURI("tag:local")));
        ResultSetPeekable rs = ResultSetFactory.makePeekable(inner);
        Assert.assertTrue((boolean)rs.hasNext());
        Assert.assertNotNull((Object)rs.peek());
        Assert.assertNotNull((Object)rs.next());
        inner.reset();
        rs.hasNext();
    }

    @Test
    public void test_RS_peeking_9() {
        Node first = NodeFactory.createURI("tag:first");
        Node second = NodeFactory.createURI("tag:second");
        Var x = Var.alloc("x");
        ResultSetMem inner = new ResultSetMem(this.make("x", first), this.make("x", second));
        ResultSetPeekable rs = ResultSetFactory.makePeekable(inner);
        Assert.assertTrue((boolean)rs.hasNext());
        Binding peeked = rs.peekBinding();
        Assert.assertNotNull((Object)peeked);
        Assert.assertTrue((boolean)first.equals(peeked.get(x)));
        Binding next = rs.nextBinding();
        Assert.assertNotNull((Object)next);
        Assert.assertTrue((boolean)first.equals(next.get(x)));
        peeked = rs.peekBinding();
        Assert.assertNotNull((Object)peeked);
        Assert.assertTrue((boolean)second.equals(peeked.get(x)));
        next = rs.nextBinding();
        Assert.assertNotNull((Object)next);
        Assert.assertTrue((boolean)second.equals(next.get(x)));
    }

    @Test
    public void test_RS_iso_1() {
        this.isotest(rs1$, rs2$);
    }

    private void isotest(String[] rs1$2, String[] rs2$2) {
        ResultSetRewindable rs1 = ResultSetFactory.makeRewindable(BuilderResultSet.build(SSE.parseItem(StrUtils.strjoinNL(rs1$))));
        ResultSetRewindable rs2 = ResultSetFactory.makeRewindable(BuilderResultSet.build(SSE.parseItem(StrUtils.strjoinNL(rs2$))));
        Assert.assertTrue((boolean)ResultSetCompare.isomorphic(rs1, rs2));
        rs1.reset();
        rs2.reset();
        Assert.assertTrue((boolean)ResultSetCompare.equalsByTerm(rs1, rs2));
        Assert.assertTrue((boolean)ResultSetCompare.equalsByValue(rs1, rs2));
    }

    @Test
    public void preserve_bnodes_1() {
        TestResultSet.preserve_bnodes(ResultSetLang.RS_JSON, cxt, true);
        TestResultSet.preserve_bnodes(ResultSetLang.RS_JSON, ARQ.getContext(), false);
    }

    @Test
    public void preserve_bnodes_2() {
        TestResultSet.preserve_bnodes(ResultSetLang.RS_XML, cxt, true);
        TestResultSet.preserve_bnodes(ResultSetLang.RS_XML, ARQ.getContext(), false);
    }

    @Test
    public void preserve_bnodes_3() {
        TestResultSet.preserve_bnodes(ResultSetLang.RS_Thrift, cxt, true);
        TestResultSet.preserve_bnodes(ResultSetLang.RS_Thrift, ARQ.getContext(), true);
    }

    private static void preserve_bnodes(Lang sparqlresultlang, Context cxt, boolean same) {
        ResultSetRewindable rs1 = ResultSetFactory.makeRewindable(BuilderResultSet.build(SSE.parseItem(StrUtils.strjoinNL(rs1$))));
        ByteArrayOutputStream x = new ByteArrayOutputStream();
        ResultsWriter.create().context(cxt).lang(sparqlresultlang).write((OutputStream)x, (ResultSet)rs1);
        ByteArrayInputStream y = new ByteArrayInputStream(x.toByteArray());
        ResultSetRewindable rs2 = ResultSetFactory.copyResults(ResultsReader.create().context(cxt).lang(sparqlresultlang).read(y));
        rs1.reset();
        rs2.reset();
        if (same) {
            Assert.assertTrue((boolean)ResultSetCompare.equalsExact(rs1, rs2));
        } else {
            Assert.assertFalse((boolean)ResultSetCompare.equalsExact(rs1, rs2));
        }
    }

    private ResultSet make(String var, Node val) {
        Binding b = BindingFactory.binding(Var.alloc(var), val);
        ArrayList<String> vars = new ArrayList<String>();
        vars.add(var);
        QueryIterSingleton qIter = QueryIterSingleton.create(b, null);
        ResultSetStream rs = new ResultSetStream(vars, null, qIter);
        return rs;
    }

    private ResultSet make2(String var, Node val) {
        Binding b1 = BindingFactory.binding(Var.alloc(var), val);
        Binding b2 = BindingFactory.binding(Var.alloc(var), val);
        ArrayList<String> vars = new ArrayList<String>();
        vars.add(var);
        ArrayList<Binding> solutions = new ArrayList<Binding>();
        solutions.add(b1);
        solutions.add(b2);
        QueryIterator qIter = QueryIterPlainWrapper.create(solutions.iterator(), null);
        ResultSetStream rs = new ResultSetStream(vars, null, qIter);
        return rs;
    }

    private ResultSetRewindable makeRewindable(String var, Node val) {
        ResultSet rs = this.make(var, val);
        ResultSetRewindable rsw = ResultSetFactory.makeRewindable(rs);
        return rsw;
    }

    private ResultSetRewindable make2Rewindable(String var, Node val) {
        ResultSet rs = this.make2(var, val);
        ResultSetRewindable rsw = ResultSetFactory.makeRewindable(rs);
        return rsw;
    }

    private ResultSet make(String var1, Node val1, String var2, Node val2) {
        Binding b = BindingFactory.binding(Var.alloc(var1), val1, Var.alloc(var2), val2);
        ArrayList<String> vars = new ArrayList<String>();
        vars.add(var1);
        vars.add(var2);
        QueryIterSingleton qIter = QueryIterSingleton.create(b, null);
        ResultSetStream rs = new ResultSetStream(vars, null, qIter);
        return rs;
    }

    private ResultSetRewindable makeRewindable(String var1, Node val1, String var2, Node val2) {
        ResultSet rs = this.make(var1, val1, var2, val2);
        ResultSetRewindable rsw = ResultSetFactory.makeRewindable(rs);
        return rsw;
    }

    private ResultSetPeekable makePeekable(String var, Node val) {
        ResultSet rs = this.make(var, val);
        ResultSetPeekable rsp = ResultSetFactory.makePeekable(rs);
        return rsp;
    }

    private ResultSetPeekable make2Peekable(String var1, Node val1, String var2, Node val2) {
        ResultSet rs = this.make(var1, val1, var2, val2);
        ResultSetPeekable rsp = ResultSetFactory.makePeekable(rs);
        return rsp;
    }

    static {
        JenaSystem.init();
        DIR = "testing/ResultSet/";
        rs1$ = new String[]{"(resultset (?x ?y)", "   (row (?x _:b0) (?y _:b1))", "   (row (?x _:b2) (?y _:b3))", "   (row (?x _:b1) (?y _:b0))", ")"};
        rs2$ = new String[]{"(resultset (?x ?y)", "   (row (?x _:c1) (?y _:c0))", "   (row (?x _:c3) (?y _:c2))", "   (row (?x _:c2) (?y _:c3))", ")"};
        cxt = new Context();
        cxt.set(ARQ.inputGraphBNodeLabels, true);
        cxt.set(ARQ.outputGraphBNodeLabels, true);
    }
}

