/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ResultSet;
import org.apache.jena.riot.RiotException;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ResultSetStream;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.resultset.TSVInputIterator;
import org.apache.jena.sparql.util.NodeFactoryExtra;

public class TSVInput {
    private static Pattern pattern = Pattern.compile("\t");

    public static ResultSet fromTSV(InputStream in) {
        ArrayList<String> varNames;
        ArrayList<Var> vars;
        BufferedReader reader;
        block7: {
            reader = IO.asBufferedUTF8(in);
            vars = new ArrayList<Var>();
            varNames = new ArrayList<String>();
            String str2 = null;
            try {
                String[] tokens2;
                str2 = reader.readLine();
                if (str2 == null) {
                    throw new ARQException("TSV Results malformed, input is empty (no header row)");
                }
                if (str2.isEmpty()) break block7;
                for (String token : tokens2 = pattern.split(str2, -1)) {
                    Node v;
                    try {
                        v = NodeFactoryExtra.parseNode(token);
                        if (v == null || !v.isVariable()) {
                            throw new ResultSetException("TSV Results malformed, not a variable: " + token);
                        }
                    }
                    catch (RiotException ex) {
                        throw new ResultSetException("TSV Results malformed, variable names must begin with a ? in the header: " + token);
                    }
                    Var var = Var.alloc(v);
                    vars.add(var);
                    varNames.add(var.getName());
                }
            }
            catch (IOException ex) {
                throw new ARQException(ex);
            }
        }
        return new ResultSetStream(varNames, null, new TSVInputIterator(reader, vars));
    }

    public static boolean booleanFromTSV(InputStream in) {
        BufferedReader reader = IO.asBufferedUTF8(in);
        String str2 = null;
        try {
            str2 = reader.readLine();
            if (str2 == null) {
                throw new ARQException("TSV Boolean Results malformed, input is empty");
            }
            if (!(str2 = str2.trim()).equals("?_askResult")) {
                throw new ARQException("TSV Boolean Results malformed, did not get expected ?_askResult header row");
            }
            str2 = reader.readLine();
            if (str2 == null) {
                throw new ARQException("TSV Boolean Results malformed, unexpected end of input after header row");
            }
            if ((str2 = str2.trim()).equalsIgnoreCase("true") || str2.equalsIgnoreCase("yes")) {
                return true;
            }
            if (str2.equalsIgnoreCase("false") || str2.equalsIgnoreCase("no")) {
                return false;
            }
            throw new ARQException("TSV Boolean Results malformed, expected one of - true yes false no - but got " + str2);
        }
        catch (IOException ex) {
            throw new ARQException(ex);
        }
    }
}

