/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.pfunction.library;

import java.util.ArrayList;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.core.Var;
import org.junit.Assert;
import org.junit.Test;

public class TestStrSplit {
    private static final String prologue = "PREFIX apf: <http://jena.apache.org/ARQ/property#>\n";
    private QueryExecution qe;

    @Test
    public void shouldThrowQBEIfSubjectIsList() {
        this.assertQueryBuildException("SELECT ?x { (?x) apf:strSplit ('foo' ';') }");
    }

    @Test
    public void shouldThrowQBEIfObjectIsNotList() {
        this.assertQueryBuildException("SELECT ?x { ?x apf:strSplit 'foo' }");
    }

    @Test
    public void shouldThrowQBEIfWrongNumberOfArgsInObjectList() {
        this.assertQueryBuildException("SELECT ?x { ?x apf:strSplit () }");
        this.assertQueryBuildException("SELECT ?x { ?x apf:strSplit ('foo') }");
        this.assertQueryBuildException("SELECT ?x { ?x apf:strSplit ('foo' ';' 'i') }");
    }

    @Test
    public void shouldNotErrorOnSimpleQuery() {
        this.query("SELECT ?x { ?x apf:strSplit ('foo' ';') }");
        this.qe.execSelect();
    }

    @Test
    public void literalInputNonMatchingRegex() {
        this.query("SELECT ?x { ?x apf:strSplit ('foo' ';') }");
        this.assertAllX("foo");
    }

    @Test
    public void emptyStringInputNonMatchingRegex() {
        this.query("SELECT ?x { ?x apf:strSplit ('' ';') }");
        this.assertAllX("");
    }

    @Test
    public void literalInputMatchingRegex() {
        this.query("SELECT ?x { ?x apf:strSplit ('foo;bar' ';') }");
        this.assertAllX("foo", "bar");
    }

    @Test
    public void boundVariableInput() {
        this.query("SELECT ?x { BIND ('foo;bar' AS ?input) ?x apf:strSplit (?input ';') }");
        this.assertAllX("foo", "bar");
    }

    @Test
    public void unboundVariableInput() {
        this.query("SELECT ?x { ?x apf:strSplit (?unbound ';') }");
        this.assertNoResults();
    }

    @Test
    public void boundVariableRegex() {
        this.query("SELECT ?x { BIND (';' AS ?regex) ?x apf:strSplit ('foo;bar' ?regex) }");
        this.assertAllX("foo", "bar");
    }

    @Test
    public void badInputNodeShouldHaveNoResults() {
        this.query("SELECT ?x { ?x apf:strSplit (<foo> ';') }");
        this.assertNoResults();
        this.query("SELECT ?x { ?x apf:strSplit (_:foo ';') }");
        this.assertNoResults();
    }

    @Test
    public void badRegexNodeShouldHaveNoResults() {
        this.query("SELECT ?x { ?x apf:strSplit ('foo;bar' ?unbound) }");
        this.assertNoResults();
        this.query("SELECT ?x { ?x apf:strSplit ('foo;bar' <;>) }");
        this.assertNoResults();
        this.query("SELECT ?x { ?x apf:strSplit ('foo;bar' _:foo) }");
        this.assertNoResults();
    }

    @Test
    public void literalSubjectShouldMatchIfInSplitResults() {
        this.query("ASK { 'foo' apf:strSplit ('foo;bar' ';') }");
        this.assertAsk(true);
        this.query("ASK { 'bar' apf:strSplit ('foo;bar' ';') }");
        this.assertAsk(true);
        this.query("ASK { 'zzz' apf:strSplit ('foo;bar' ';') }");
        this.assertAsk(false);
    }

    private void assertQueryBuildException(String selectQueryString) {
        try {
            this.query(selectQueryString);
            this.qe.execSelect();
            Assert.fail((String)"Expected QueryBuildException");
        }
        catch (QueryBuildException queryBuildException) {
            // empty catch block
        }
    }

    private void query(String queryString) {
        this.qe = QueryExecutionFactory.create(prologue + queryString, ModelFactory.createDefaultModel());
    }

    private void assertAllX(String ... literalValues) {
        ArrayList<Node> expectedNodes = new ArrayList<Node>();
        for (String value : literalValues) {
            expectedNodes.add(NodeFactory.createLiteral(value));
        }
        ResultSet rs = this.qe.execSelect();
        ArrayList<Node> actualNodes = new ArrayList<Node>();
        while (rs.hasNext()) {
            actualNodes.add(rs.nextBinding().get(Var.alloc("x")));
        }
        Assert.assertArrayEquals((Object[])expectedNodes.toArray(new Node[expectedNodes.size()]), (Object[])actualNodes.toArray(new Node[actualNodes.size()]));
    }

    private void assertNoResults() {
        Assert.assertFalse((boolean)this.qe.execSelect().hasNext());
    }

    private void assertAsk(boolean expected) {
        Assert.assertEquals((Object)expected, (Object)this.qe.execAsk());
    }
}

