/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.path;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathFactory;
import org.apache.jena.sparql.path.eval.PathEval;
import org.apache.jena.sparql.sse.SSE;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestPath2 {
    static String prefix = "http://example/";
    static String prefixes = "((: <" + prefix + ">))";
    static String gs = StrUtils.strjoinNL("(prefix " + prefixes, "  (graph", "     (:x :p :y)", "     (:y :p :z)", "     (:z :p :x)", "     (:x :p :a)", "     (:x :q :y1)", "     (:x :q :y2)", "     (:y1 :q :z)", "     (:y2 :q :z)", "     (:x :r :y1)", "     (:x :r :y2)", "     (:y1 :r :z)", "     (:y2 :r :z)", "     (:z :r :a1)", "     (:z :r :a2)", "     (:a1 :r :b)", "     (:a2 :r :b)", "))");
    static Graph graph = SSE.parseGraph(gs);
    static Node x = TestPath2.parse(":x");

    @BeforeClass
    public static void beforeClass() {
    }

    @AfterClass
    public static void afterClass() {
    }

    static Node parse(String str2) {
        return SSE.parseNode("<" + prefix + str2.substring(1) + ">");
    }

    @Test
    public void path_01() {
        this.test(x, "(path :p)", ":a", ":y");
    }

    @Test
    public void path_02() {
        this.test(x, "(alt :q :r)", ":y2", ":y1", ":y2", ":y1");
    }

    @Test
    public void path_03() {
        this.test(x, "(seq :p :p)", ":z");
    }

    @Test
    public void path_04() {
        this.test(x, "(seq :q :q)", ":z", ":z");
    }

    @Test
    public void path_05() {
        this.test(x, "(path? :p)", ":x", ":a", ":y");
    }

    @Test
    public void path_06() {
        this.test(x, "(path? :X)", ":x");
    }

    @Test
    public void path_07() {
        this.test(x, "(notoneof :p)", ":y2", ":y1", ":y2", ":y1");
    }

    @Test
    public void path_08() {
        this.test(x, "(notoneof :Z)", ":y2", ":y1", ":y2", ":y1", ":a", ":y");
    }

    @Test
    public void path_09() {
        this.test(x, "(notoneof (rev :p))", new String[0]);
    }

    @Test
    public void path_10() {
        this.test(x, "(notoneof (rev :Z))", ":z");
    }

    @Test
    public void path_11() {
        this.test(x, "(notoneof :q (rev :p))", ":y2", ":y1", ":a", ":y");
    }

    @Test
    public void path_12() {
        this.test(x, "(notoneof :q (rev :Z))", ":y2", ":y1", ":a", ":y", ":z");
    }

    @Test
    public void path_13() {
        this.test(x, "(mod 0 2 :q)", ":x", ":y2", ":z", ":y1", ":z");
    }

    @Test
    public void path_14() {
        this.test(x, "(mod 0 1 :q)", ":x", ":y2", ":y1");
    }

    @Test
    public void path_15() {
        this.test(x, "(mod 0 1 :r)", ":x", ":y2", ":y1");
    }

    @Test
    public void path_16() {
        this.test(x, "(mod 0 3 :r)", ":x", ":y2", ":z", ":a2", ":a1", ":y1", ":z", ":a2", ":a1");
    }

    @Test
    public void path_17() {
        this.test(x, "(mod 0 99 :r)", ":x", ":y2", ":z", ":a2", ":b", ":a1", ":b", ":y1", ":z", ":a2", ":b", ":a1", ":b");
    }

    @Test
    public void path_18() {
        this.test(x, "(mod 0 2 :q)", ":x", ":y2", ":z", ":y1", ":z");
    }

    @Test
    public void path_19() {
        this.test(x, "(pathN 2 :p)", ":z");
    }

    @Test
    public void path_20() {
        this.test(x, "(pathN 2 :q)", ":z", ":z");
    }

    @Test
    public void path_21() {
        this.test(x, "(distinct(pathN 2 :q))", ":z");
    }

    @Test
    public void path_30() {
        this.test(x, "(path* :p)", ":x", ":a", ":y", ":z");
    }

    @Test
    public void path_31() {
        this.test(x, "(pathN* :p)", ":x", ":a", ":y", ":z");
    }

    @Test
    public void path_32() {
        this.test(x, "(path+ :p)", ":a", ":y", ":z", ":x");
    }

    @Test
    public void path_33() {
        this.test(x, "(pathN+ :p)", ":a", ":y", ":z", ":x", ":a");
    }

    @Test
    public void path_34() {
        this.test(x, "(path+ :r)", ":y2", ":z", ":a2", ":b", ":a1", ":y1");
    }

    @Test
    public void path_35() {
        this.test(x, "(pathN+ :r)", ":y2", ":z", ":a2", ":b", ":a1", ":b", ":y1", ":z", ":a2", ":b", ":a1", ":b");
    }

    @Test
    public void path_36() {
        this.test(x, "(path* :r)", ":x", ":y2", ":z", ":a2", ":b", ":a1", ":y1");
    }

    @Test
    public void path_37() {
        this.test(x, "(pathN* :r)", ":x", ":y2", ":z", ":a2", ":b", ":a1", ":b", ":y1", ":z", ":a2", ":b", ":a1", ":b");
    }

    private void test(Node start, String pathStr, String ... results) {
        String ps = "(prefix " + prefixes + " " + pathStr + ")";
        Path path = SSE.parsePath(ps);
        List<Node> nodes1 = Iter.toList(PathEval.eval(graph, start, PathFactory.pathDistinct(path), ARQ.getContext()));
        List<Node> nodes2 = Iter.toList(PathEval.eval(graph, start, path, ARQ.getContext()));
        ArrayList<Node> expected = new ArrayList<Node>();
        for (String n : results) {
            expected.add(TestPath2.parse(n));
        }
        List<Node> expected1 = Iter.iter(expected).distinct().toList();
        TestPath2.assertSameArray(expected, nodes2);
        TestPath2.assertSameArray(expected1, nodes1);
    }

    private static void assertSameArray(List<Node> expected, List<Node> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        ArrayList<Node> x = new ArrayList<Node>(expected);
        for (Node n : actual) {
            if (!x.contains(n)) continue;
            x.remove(n);
        }
        if (x.size() != 0) {
            Assert.fail((String)("Different: Expected: " + expected + ", actual: " + actual));
        }
    }
}

