/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.path;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.ListUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathLib;
import org.apache.jena.sparql.path.PathParser;
import org.apache.jena.sparql.path.eval.PathEval;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.builders.BuilderPath;
import org.apache.jena.sparql.sse.writers.WriterPath;
import org.junit.Assert;
import org.junit.Test;

public class TestPath {
    static Graph graph1 = GraphFactory.createDefaultGraph();
    static Graph graph2 = GraphFactory.createDefaultGraph();
    static Graph graph3 = GraphFactory.createDefaultGraph();
    static Graph graph4 = GraphFactory.createDefaultGraph();
    static Graph graph5 = GraphFactory.createDefaultGraph();
    static Graph graph6 = GraphFactory.createDefaultGraph();
    static Graph graph7 = GraphFactory.createDefaultGraph();
    static Node n1 = NodeFactory.createURI("n1");
    static Node n2 = NodeFactory.createURI("n2");
    static Node n3 = NodeFactory.createURI("n3");
    static Node n4 = NodeFactory.createURI("n4");
    static Node n5 = NodeFactory.createURI("n5");
    static Node n6 = NodeFactory.createURI("n6");
    static Node p = NodeFactory.createURI("http://example/p");
    static Node q = NodeFactory.createURI("http://example/q");
    static PrefixMapping pmap = new PrefixMappingImpl();

    @Test
    public void parsePath_01() {
        this.parse(":p");
    }

    @Test
    public void parsePath_02() {
        this.parse("(:p)");
    }

    @Test
    public void parsePath_03() {
        this.parse("^:p");
    }

    @Test
    public void parsePath_04() {
        this.parse(":p*");
    }

    @Test
    public void parsePath_05() {
        this.parse(":p+");
    }

    @Test
    public void parsePath_06() {
        this.parse(":p?");
    }

    @Test
    public void parsePath_10() {
        this.parse(":p/:q");
    }

    @Test
    public void parsePath_11() {
        this.parse(":p|:q");
    }

    @Test
    public void parsePath_12() {
        this.parse(":p{1}");
    }

    @Test
    public void parsePath_13() {
        this.parse(":p{1,}");
    }

    @Test
    public void parsePath_14() {
        this.parse(":p{,1}");
    }

    @Test
    public void parsePath_15() {
        this.parse(":p{1,2}");
    }

    @Test
    public void parsePath_20() {
        this.parse(":p^:q");
    }

    @Test
    public void parsePath_21() {
        this.parse("^:p^:q");
    }

    @Test
    public void parsePath_22() {
        this.parse("^:p/:q");
    }

    @Test
    public void parsePath_23() {
        this.parse("^(:p/:q)");
    }

    @Test
    public void parsePath_24() {
        this.parse("^(:p^:q)");
    }

    @Test
    public void parsePath_25() {
        this.parse(":p^(:q/:r)");
    }

    @Test
    public void parsePath_30() {
        this.parse("!(:q|:r)");
    }

    @Test
    public void parsePath_31() {
        this.parse(":p/!:q/:r");
    }

    @Test
    public void parsePath_32() {
        this.parse("!:q/:r");
    }

    @Test
    public void parsePathErr_01() {
        this.parse("", false);
    }

    @Test
    public void parsePathErr_02() {
        this.parse("()", false);
    }

    @Test
    public void parsePathErr_03() {
        this.parse(":p :q", false);
    }

    @Test
    public void parseEquals_1() {
        TestPath.parse("(:p)", ":p");
    }

    @Test
    public void parseEquals_2() {
        TestPath.parse(":p/:q/:r", "(:p/:q)/:r");
    }

    @Test
    public void parseEquals_3() {
        TestPath.parse("^:p^:q^:r", "(^:p^:q)^:r");
    }

    @Test
    public void parseEquals_4() {
        TestPath.parse(":p/(:q/:r)", ":p/(:q/:r)");
    }

    @Test
    public void parseEquals_5() {
        TestPath.parse("(:p/:q)|:r", ":p/:q|:r");
    }

    @Test
    public void parseEquals_6() {
        TestPath.parse(":p|(:q/:r)", ":p|:q/:r");
    }

    @Test
    public void parseEquals_7() {
        TestPath.parse("^:p/:q", "(^:p)/:q");
    }

    @Test
    public void parseEquals_8() {
        TestPath.parse("!:q/:r", "(!:q)/:r");
    }

    @Test
    public void parseEquals_9() {
        TestPath.parse("!:q/:r", "(!:q)/:r");
    }

    @Test
    public void parsePathDistinct1() {
        TestPath.parse("distinct(:p)", "distinct(:p)");
    }

    @Test
    public void parsePathDistinct2() {
        TestPath.parse("distinct(:p*)", "distinct(:p*)");
    }

    @Test
    public void parsePathDistinct3() {
        TestPath.parse("distinct((:p)*)", "distinct(:p*)");
    }

    @Test
    public void parsePathDistinct4() {
        TestPath.parse(":p/distinct(:p*)/:q", ":p/distinct(:p*)/:q");
    }

    @Test
    public void parsePathDistinct5() {
        TestPath.parse(":p/distinct(:p)*/:q", ":p/distinct(:p)*/:q");
    }

    @Test
    public void parsePathShortest1() {
        TestPath.parse("shortest(:p)", "shortest(:p)");
    }

    @Test
    public void parsePathShortest2() {
        TestPath.parse("shortest(:p*)", "shortest(:p*)");
    }

    @Test
    public void parsePathShortest3() {
        TestPath.parse("shortest(:p+)", "shortest(:p+)");
    }

    @Test
    public void parsePathShortest4() {
        TestPath.parse("shortest((:p)*)", "shortest(:p*)");
    }

    @Test
    public void parsePathShortest5() {
        TestPath.parse(":p/shortest(:p*)/:q", ":p/shortest(:p*)/:q");
    }

    @Test
    public void parsePathShortest6() {
        TestPath.parse(":p/shortest(:p)*/:q", ":p/shortest(:p)*/:q");
    }

    private void parse(String string) {
        this.parse(string, true);
    }

    private void parse(String string, boolean expectLegal) {
        Prologue prologue = new Prologue(pmap);
        Path p = null;
        try {
            p = PathParser.parse(string, prologue);
            if (!expectLegal) {
                Assert.fail((String)("Expected error; " + string));
            }
        }
        catch (QueryParseException ex) {
            if (expectLegal) {
                Assert.fail((String)("Expected success: " + string + ": " + ex.getMessage()));
            }
            return;
        }
        String x = p.toString(prologue);
        Path p2 = PathParser.parse(x, prologue);
        Assert.assertEquals((Object)p, (Object)p2);
        String sse2 = WriterPath.asString(p, prologue);
        Item item = SSE.parseItem(sse2, pmap);
        p2 = BuilderPath.buildPath(item);
        Assert.assertEquals((Object)p, (Object)p2);
    }

    private static void parse(String path1, String path2) {
        Prologue prologue = new Prologue(pmap);
        Path p1 = PathParser.parse(path1, prologue);
        Path p2 = PathParser.parse(path2, prologue);
        Assert.assertEquals((Object)p1, (Object)p2);
    }

    @Test
    public void path_01() {
        TestPath.testOrdered(graph1, n1, ":p", n2);
    }

    @Test
    public void path_02() {
        TestPath.testOrdered(graph1, n1, ":p{0}", n1);
    }

    @Test
    public void path_03() {
        TestPath.testOrdered(graph1, n1, ":p{1}", n2);
    }

    @Test
    public void path_04() {
        TestPath.testOrdered(graph1, n1, ":p{2}", n3);
    }

    @Test
    public void path_05() {
        TestPath.testOrdered(graph1, n1, ":p{0,1}", n1, n2);
    }

    @Test
    public void path_06() {
        TestPath.testOrdered(graph1, n1, ":p{0,2}", n1, n2, n3);
    }

    @Test
    public void path_07() {
        TestPath.testOrdered(graph1, n1, ":p{1,2}", n2, n3);
    }

    @Test
    public void path_08() {
        TestPath.testOrdered(graph1, n1, ":p{9,9}", new Node[0]);
    }

    @Test
    public void path_09() {
        TestPath.testOrdered(graph1, n1, ":p{0,9}", n1, n2, n3, n4);
    }

    @Test
    public void path_10() {
        TestPath.testOrdered(graph1, n1, ":p*", n1, n2, n3, n4);
    }

    @Test
    public void path_11() {
        TestPath.testOrdered(graph1, n1, ":p+", n2, n3, n4);
    }

    @Test
    public void path_12() {
        TestPath.testOrdered(graph1, n1, ":p?", n1, n2);
    }

    @Test
    public void path_13() {
        TestPath.testOrdered(graph1, n1, ":p/:p", n3);
    }

    @Test
    public void path_14() {
        TestPath.testOrdered(graph1, n2, "^:p", n1);
    }

    @Test
    public void path_15() {
        TestPath.testOrdered(graph1, n2, "^:p^:p", new Node[0]);
    }

    @Test
    public void path_16() {
        TestPath.testOrdered(graph1, n4, "^:p^:p", n2);
    }

    @Test
    public void path_17() {
        TestPath.testOrdered(graph1, n4, "^(:p/:p)", n2);
    }

    @Test
    public void path_18() {
        TestPath.testOrdered(graph1, n2, "^:p/:p", n2);
    }

    @Test
    public void path_20() {
        TestPath.test(graph2, n1, ":p", n2, n3);
    }

    @Test
    public void path_21() {
        TestPath.test(graph2, n1, ":p/:q", n4, n4);
    }

    @Test
    public void path_22() {
        TestPath.test(graph2, n2, "^:p|:q", n1, n4);
    }

    @Test
    public void path_23() {
        TestPath.test(graph2, n2, "^(:p|^:q)*", n1, n2, n4);
    }

    @Test
    public void path_24() {
        TestPath.testReverseOrdered(graph1, n2, ":p", n1);
    }

    @Test
    public void path_25() {
        TestPath.testReverseOrdered(graph1, n3, ":p/:p", n1);
    }

    @Test
    public void path_30() {
        TestPath.test(graph1, n1, ":p*", n1, n2, n3, n4);
    }

    @Test
    public void path_31() {
        TestPath.test(graph2, n1, ":p*", n1, n2, n3);
    }

    @Test
    public void path_32() {
        TestPath.test(graph3, n1, ":p{*}", n1, n2, n3, n4, n4);
    }

    @Test
    public void path_33() {
        TestPath.test(graph3, n1, ":p*", n1, n2, n3, n4);
    }

    @Test
    public void path_34() {
        TestPath.test(graph3, n1, ":p+", n2, n3, n4);
    }

    private static List<Binding> eval(Graph graph, String start$, String pathStr, String finish$) {
        return TestPath.eval(graph, SSE.parseNode(start$, pmap), pathStr, SSE.parseNode(finish$, pmap));
    }

    private static List<Binding> eval(Graph graph, Node start, String pathStr, Node finish) {
        Path path = SSE.parsePath(pathStr, pmap);
        QueryIterator qIter = PathLib.execTriplePath(BindingFactory.root(), start, path, finish, new ExecutionContext(ARQ.getContext(), graph, null, null));
        return Iter.toList(qIter);
    }

    @Test
    public void path_35() {
        List<Binding> x = TestPath.eval(graph6, "?x", "(path+ :p)", "?y");
        Assert.assertEquals((long)4L, (long)x.size());
    }

    @Test
    public void path_36() {
        List<Binding> x = TestPath.eval(graph6, "?x", "(path+ :p)", "?x");
        Assert.assertEquals((long)2L, (long)x.size());
    }

    @Test
    public void path_37() {
        List<Binding> x = TestPath.eval(graph6, "?x", "(path* :p)", "?x");
        Assert.assertEquals((long)2L, (long)x.size());
        Node node1 = x.get(0).get(Var.alloc("x"));
        Node node2 = x.get(1).get(Var.alloc("x"));
        Assert.assertFalse((boolean)node1.equals(node2));
        Assert.assertTrue((node1.equals(n1) || node1.equals(n2) ? 1 : 0) != 0);
        Assert.assertTrue((node2.equals(n1) || node2.equals(n2) ? 1 : 0) != 0);
    }

    @Test
    public void path_38() {
        List<Binding> x = TestPath.eval(graph6, "?x", "(pathN+ :p)", "?x");
        Assert.assertEquals((long)2L, (long)x.size());
        Node node1 = x.get(0).get(Var.alloc("x"));
        Node node2 = x.get(1).get(Var.alloc("x"));
        Assert.assertFalse((boolean)node1.equals(node2));
        Assert.assertTrue((node1.equals(n1) || node1.equals(n2) ? 1 : 0) != 0);
        Assert.assertTrue((node2.equals(n1) || node2.equals(n2) ? 1 : 0) != 0);
    }

    @Test
    public void path_39() {
        List<Binding> x = TestPath.eval(graph6, "?x", "(pathN* :p)", "?x");
        Assert.assertEquals((long)2L, (long)x.size());
    }

    @Test
    public void path_50() {
        List<Binding> x = TestPath.eval(graph1, "?x", "(notoneof :DoesNotExist)", "<n4>");
        Assert.assertEquals((long)1L, (long)x.size());
    }

    @Test
    public void path_51() {
        List<Binding> x = TestPath.eval(graph1, "?x", "(notoneof :DoesNotExist)", "?z");
        Assert.assertEquals((long)3L, (long)x.size());
    }

    @Test
    public void path_52() {
        List<Binding> x = TestPath.eval(graph1, "<n1>", "(notoneof :DoesNotExist)", "?z");
        Assert.assertEquals((long)1L, (long)x.size());
    }

    private static void testOrdered(Graph graph, Node start, String string, Node ... expectedNodes) {
        TestPath.test(graph, start, string, expectedNodes, true, true);
    }

    private static void test(Graph graph, Node start, String string, Node ... expectedNodes) {
        TestPath.test(graph, start, string, expectedNodes, true, false);
    }

    private static void testReverseOrdered(Graph graph, Node start, String string, Node ... expectedNodes) {
        TestPath.test(graph, start, string, expectedNodes, false, true);
    }

    private static void test(Graph graph, Node start, String string, Node[] expectedNodes, boolean directionForward, boolean ordered) {
        Path p = PathParser.parse(string, pmap);
        Iterator<Node> resultsIter = directionForward ? PathEval.eval(graph, start, p, ARQ.getContext()) : PathEval.evalReverse(graph, start, p, ARQ.getContext());
        List<Node> results = Iter.toList(resultsIter);
        List<Node> expected = Arrays.asList(expectedNodes);
        Assert.assertTrue((String)("expected:" + expected + ", got:" + results), (boolean)ListUtils.equalsUnordered(expected, results));
        if (ordered) {
            Assert.assertEquals((String)"expected(ordered)", expected, results);
        }
    }

    static {
        pmap.setNsPrefixes(PrefixMapping.Standard);
        pmap.setNsPrefix("", "http://example/");
        graph1.add(new Triple(n1, p, n2));
        graph1.add(new Triple(n2, p, n3));
        graph1.add(new Triple(n3, p, n4));
        graph2.add(new Triple(n1, p, n2));
        graph2.add(new Triple(n1, p, n3));
        graph2.add(new Triple(n2, q, n4));
        graph2.add(new Triple(n3, q, n4));
        graph3.add(new Triple(n1, p, n2));
        graph3.add(new Triple(n1, p, n3));
        graph3.add(new Triple(n2, p, n4));
        graph3.add(new Triple(n3, p, n4));
        graph4.add(new Triple(n1, p, n2));
        graph4.add(new Triple(n2, p, n3));
        graph4.add(new Triple(n3, p, n4));
        graph4.add(new Triple(n2, q, n5));
        graph4.add(new Triple(n4, q, n6));
        graph5.add(new Triple(n1, p, n2));
        graph5.add(new Triple(n1, p, n3));
        graph5.add(new Triple(n2, q, n4));
        graph5.add(new Triple(n3, q, n5));
        graph6.add(new Triple(n1, p, n2));
        graph6.add(new Triple(n2, p, n1));
        graph7.add(new Triple(n1, p, n2));
        graph7.add(new Triple(n2, p, n1));
        graph7.add(new Triple(n2, p, n3));
    }
}

