/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.lib;

import java.math.BigDecimal;
import org.apache.jena.atlas.json.JsonBoolean;
import org.apache.jena.atlas.json.JsonNull;
import org.apache.jena.atlas.json.JsonNumber;
import org.apache.jena.atlas.json.JsonString;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.lib.RDFTerm2Json;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public class TestRDFTerm2Json {
    @Test
    public void n2j_1() {
        this.test("'abc'", new JsonString("abc"));
    }

    @Test
    public void n2j_2() {
        this.test("<http://jena.apache.org/>", new JsonString("http://jena.apache.org/"));
    }

    @Test
    public void n2j_3() {
        this.test("123", JsonNumber.value(123L));
    }

    @Test
    public void n2j_4() {
        this.test("123.0", JsonNumber.value(new BigDecimal("123.0")));
    }

    @Test
    public void n2j_5() {
        this.test("123e0", JsonNumber.value(123.0));
    }

    @Test
    public void n2j_6() {
        this.test("'123e0'^^xsd:float", JsonNumber.value(123.0));
    }

    @Test
    public void n2j_7() {
        this.test("true", new JsonBoolean(true));
    }

    @Test
    public void n2j_8() {
        this.test("'text'@en", new JsonString("text"));
    }

    @Test
    public void n2j_9() {
        Assert.assertEquals((Object)JsonNull.instance, (Object)RDFTerm2Json.fromNode(null));
    }

    private void test(String nodeStr, JsonValue expected) {
        Node n = SSE.parseNode(nodeStr);
        JsonValue jv = RDFTerm2Json.fromNode(n);
        Assert.assertEquals((Object)expected, (Object)jv);
    }
}

