/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.lang;

import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryFactory;
import org.junit.Test;

public class TestVarScope {
    private static void scope(String queryStr) {
        Query query2 = QueryFactory.create(queryStr);
    }

    @Test
    public void scope_01() {
        TestVarScope.scope("SELECT ?x { ?s ?p ?o }");
    }

    @Test
    public void scope_02() {
        TestVarScope.scope("SELECT ?s { ?s ?p ?o }");
    }

    @Test
    public void scope_03() {
        TestVarScope.scope("SELECT (?o+1 AS ?x) { ?s ?p ?o }");
    }

    @Test(expected=QueryException.class)
    public void scope_04() {
        TestVarScope.scope("SELECT (?o+1 AS ?o) { ?s ?p ?o }");
    }

    @Test(expected=QueryException.class)
    public void scope_05() {
        TestVarScope.scope("SELECT (?o+1 AS ?x) (?o+1 AS ?x) { ?s ?p ?o }");
    }

    @Test
    public void scope_06() {
        TestVarScope.scope("SELECT (?z+1 AS ?x) { ?s ?p ?o } GROUP BY (?o+5 AS ?z)");
    }

    @Test(expected=QueryException.class)
    public void scope_07() {
        TestVarScope.scope("SELECT (?o+1 AS ?x) { ?s ?p ?o } GROUP BY (?o+5 AS ?x)");
    }

    @Test
    public void scope_08() {
        TestVarScope.scope("SELECT (count(*) AS ?X) (?X+1 AS ?Z) { ?s ?p ?o }");
    }

    @Test
    public void scope_09() {
        TestVarScope.scope("SELECT (count(*) AS ?X) (?X+?o AS ?Z) { ?s ?p ?o } GROUP BY ?o");
    }

    @Test
    public void scope_10() {
        TestVarScope.scope("SELECT (?o+1 AS ?x) { ?s ?p ?o MINUS { ?s ?p ?x} } ");
    }

    @Test(expected=QueryException.class)
    public void scope_15() {
        TestVarScope.scope("SELECT (?o+1 AS ?x) { { SELECT (123 AS ?x) {?s ?p ?o } } } ");
    }

    @Test(expected=QueryException.class)
    public void scope_16() {
        TestVarScope.scope("SELECT (?o+1 AS ?o) { { SELECT (123 AS ?x) {?s ?p ?o } } } ");
    }

    @Test(expected=QueryException.class)
    public void scope_17() {
        TestVarScope.scope("SELECT (?o+1 AS ?o) { { SELECT (123 AS ?x) {?s ?p ?o FILTER(?x > 57)} } } ");
    }

    @Test
    public void scope_20() {
        TestVarScope.scope("SELECT ?x { ?x ?p ?o } GROUP BY ?x");
    }

    @Test(expected=QueryException.class)
    public void scope_21() {
        TestVarScope.scope("SELECT ?o { ?x ?p ?o } GROUP BY ?x");
    }

    @Test(expected=QueryException.class)
    public void scope_22() {
        TestVarScope.scope("SELECT * { ?s ?p ?o BIND(5 AS ?o) }");
    }

    @Test
    public void scope_23() {
        TestVarScope.scope("SELECT * { ?s ?p ?o { BIND(5 AS ?o) } }");
    }

    @Test(expected=QueryException.class)
    public void scope_24() {
        TestVarScope.scope("SELECT * { { ?s ?p ?o } BIND(5 AS ?o) }");
    }

    @Test
    public void scope_25() {
        TestVarScope.scope("SELECT * { { ?s ?p ?o } { BIND(5 AS ?o) } }");
    }

    @Test
    public void scope_26() {
        TestVarScope.scope("SELECT * { ?s ?p ?o OPTIONAL{?s ?p2 ?o2} BIND(?o2+5 AS ?z) }");
    }

    @Test(expected=QueryException.class)
    public void scope_27() {
        TestVarScope.scope("SELECT * { ?s ?p ?o OPTIONAL{?s ?p2 ?o2} BIND(5 AS ?o2) }");
    }

    @Test(expected=QueryException.class)
    public void scope_28() {
        TestVarScope.scope("SELECT * { { ?s ?p ?o OPTIONAL{?s ?p2 ?o2} } BIND(?o+5 AS ?o2) }");
    }

    @Test(expected=QueryException.class)
    public void scope_29() {
        TestVarScope.scope("SELECT * { ?s ?p ?o OPTIONAL{?s ?p2 ?o2} BIND(5 AS ?o) }");
    }

    @Test(expected=QueryException.class)
    public void scope_30() {
        TestVarScope.scope("SELECT * { { ?s ?p ?o } OPTIONAL{?s ?p2 ?o2} BIND(5 AS ?o) }");
    }

    @Test(expected=QueryException.class)
    public void scope_34() {
        TestVarScope.scope("SELECT * { { ?s ?p ?o } UNION {?s ?p2 ?o2} BIND(5 AS ?o) }");
    }

    @Test
    public void scope_35() {
        TestVarScope.scope("SELECT * { ?s1 ?p1 ?z { ?s ?p ?z } UNION { BIND(5 AS ?z) } }");
    }

    @Test(expected=QueryException.class)
    public void scope_50() {
        TestVarScope.scope("SELECT * { SELECT (?o+1 AS ?o) { ?s ?p ?o }}");
    }

    @Test
    public void scope_51() {
        TestVarScope.scope("SELECT ?y { { { SELECT (?x AS ?y) { ?s ?p ?x } } } UNION { { SELECT (?x AS ?y) { ?s ?p ?x } } }}");
    }

    @Test(expected=QueryException.class)
    public void scope_52() {
        TestVarScope.scope("SELECT ?y { { { SELECT (?o+1 AS ?x) (?o+1 AS ?x) { ?s ?p ?o } } UNION { ?s ?p ?x } }}");
    }

    @Test(expected=QueryException.class)
    public void scope_63() {
        TestVarScope.scope("SELECT * { { ?s ?p ?o } UNION { ?s ?p ?o1 BIND(5 AS ?o1) } }");
    }

    @Test(expected=QueryException.class)
    public void scope_64() {
        TestVarScope.scope("SELECT * { { { ?s ?p ?o1 BIND(5 AS ?o1) } } }");
    }

    @Test(expected=QueryException.class)
    public void scope_65() {
        TestVarScope.scope("SELECT ( (?x+1) AS ?x ) {}");
    }

    @Test(expected=QueryException.class)
    public void scope_66() {
        TestVarScope.scope("SELECT ( (?x+1) AS ?y)  (2 AS ?x) {}");
    }
}

