/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.lang;

import org.apache.jena.query.QueryParseException;
import org.apache.jena.sparql.lang.QueryParserBase;
import org.junit.Assert;
import org.junit.Test;

public class TestUnescape {
    @Test
    public void testEsc01() {
        this.execTest("x\\uabcd", "x\uabcd");
    }

    @Test
    public void testEsc02() {
        this.execTest("\\uabcdx", "\uabcdx");
    }

    @Test
    public void testEsc03() {
        this.execTest("1234\\uabcd1234", "1234\uabcd1234");
    }

    @Test
    public void testEsc04() {
        this.execTestFail("\\X");
    }

    @Test
    public void testEsc05() {
        this.execTestFail("\\Xz");
    }

    @Test
    public void testEsc06() {
        this.execTestFail("a\\X");
    }

    @Test
    public void testEscUni01() {
        this.execTestFail("\\uabck");
    }

    @Test
    public void testEscUni02() {
        this.execTestFail("\\uab");
    }

    @Test
    public void testEscUni03() {
        this.execTestFail("\\uabc");
    }

    @Test
    public void testEscUni04() {
        this.execTestFail("\\ua");
    }

    @Test
    public void testEscUni05() {
        this.execTestFail("\\u");
    }

    @Test
    public void testEscUni06() {
        this.execTestFail("\\");
    }

    @Test
    public void testEscUni07() {
        this.execTest("\\u0020", " ");
    }

    @Test
    public void testEscUni08() {
        this.execTest("\\uFFFF", "\uffff");
    }

    @Test
    public void testEscUni09() {
        this.execTest("\\u0000", "\u0000");
    }

    @Test
    public void testEscUni10() {
        this.execTestFail("\\U0000");
    }

    @Test
    public void testEscUni11() {
        this.execTestFail("\\U0000A");
    }

    @Test
    public void testEscUni12() {
        this.execTestFail("\\U0000AB");
    }

    @Test
    public void testEscUni13() {
        this.execTestFail("\\U0000ABC");
    }

    @Test
    public void testEscUni14() {
        this.execTest("\\U0000ABCD", "\uabcd");
    }

    @Test
    public void testEscUni15() {
        this.execTestFail("\\U0000");
    }

    @Test
    public void testEscUni16() {
        this.execTest("\\U00000000", "\u0000");
    }

    @Test
    public void testEscUni17() {
        this.execTest("x\\tx\\nx\\r", "x\tx\nx\r");
    }

    @Test
    public void testEscUni18() {
        this.execTest("x\\t\\n\\r", "x\t\n\r");
    }

    private void execTestFail(String input) {
        try {
            String s = QueryParserBase.unescapeStr(input);
            Assert.fail((String)("Unescaping succeeded on " + input + " producing <<" + s + ">>"));
        }
        catch (QueryParseException ex) {
            return;
        }
    }

    private void execTest(String input, String outcome) {
        String result = QueryParserBase.unescapeStr(input);
        Assert.assertEquals((String)("Unescaped string does not match (" + input + ")"), (Object)outcome, (Object)result);
    }
}

