/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import java.util.Arrays;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.graph.GraphUnionRead;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.builders.BuilderGraph;
import org.junit.Assert;
import org.junit.Test;

public class TestGraphUnionRead {
    private static String dataStr = StrUtils.strjoinNL("(dataset", "  (graph", "   (triple <http://example/s> <http://example/p> 'dft')", "   (triple <http://example/s> <http://example/p> <http://example/o>)", " )", " (graph <http://example/g1>", "   (triple <http://example/s> <http://example/p> 'g1')", "   (triple <http://example/s> <http://example/p> <http://example/o>)", " )", " (graph <http://example/g2>", "   (triple <http://example/s> <http://example/p> 'g2')", "   (triple <http://example/s> <http://example/p> <http://example/o>)", " )", " (graph <http://example/g3>", "   (triple <http://example/s> <http://example/p> 'g3')", "   (triple <http://example/s> <http://example/p> <http://example/o>)", " ))");
    private static DatasetGraph dsg = null;
    private static Node gn1;
    private static Node gn2;
    private static Node gn3;
    private static Node gn9;

    @Test
    public void gr_union_01() {
        List<Node> gnodes = TestGraphUnionRead.list(gn1, gn2);
        GraphUnionRead g = new GraphUnionRead(dsg, gnodes);
        long x = Iter.count(g.find(null, null, null));
        Assert.assertEquals((long)3L, (long)x);
    }

    @Test
    public void gr_union_02() {
        List<Node> gnodes = TestGraphUnionRead.list(gn1, gn2);
        GraphUnionRead g = new GraphUnionRead(dsg, gnodes);
        Node s = NodeFactory.createURI("http://example/s");
        long x = Iter.count(g.find(s, null, null));
        Assert.assertEquals((long)3L, (long)x);
    }

    @Test
    public void gr_union_03() {
        List<Node> gnodes = TestGraphUnionRead.list(gn1, gn2, gn9);
        GraphUnionRead g = new GraphUnionRead(dsg, gnodes);
        Node o = NodeFactory.createLiteral("g2");
        long x = Iter.count(g.find(null, null, o));
        Assert.assertEquals((long)1L, (long)x);
    }

    @Test
    public void gr_union_04() {
        List<Node> gnodes = TestGraphUnionRead.list(gn9);
        GraphUnionRead g = new GraphUnionRead(dsg, gnodes);
        long x = Iter.count(g.find(null, null, null));
        Assert.assertEquals((long)0L, (long)x);
    }

    @Test
    public void gr_union_05() {
        List<Node> gnodes = TestGraphUnionRead.list(new Node[0]);
        GraphUnionRead g = new GraphUnionRead(dsg, gnodes);
        long x = Iter.count(g.find(null, null, null));
        Assert.assertEquals((long)0L, (long)x);
    }

    @Test
    public void gr_union_06() {
        List<Node> gnodes = TestGraphUnionRead.list(gn1, gn1);
        GraphUnionRead g = new GraphUnionRead(dsg, gnodes);
        long x = Iter.count(g.find(null, null, null));
        Assert.assertEquals((long)2L, (long)x);
    }

    @Test
    public void gr_union_of_one_1() {
        List<Node> gnodes = TestGraphUnionRead.list(gn2);
        GraphUnionRead g = new GraphUnionRead(dsg, gnodes);
        long x1 = Iter.count(g.find(null, null, null));
        Assert.assertEquals((long)2L, (long)x1);
        Node o = NodeFactory.createLiteral("g2");
        long x2 = Iter.count(g.find(null, null, o));
        Assert.assertEquals((long)1L, (long)x2);
    }

    static List<Node> list(Node ... x) {
        return Arrays.asList(x);
    }

    static {
        Item item = SSE.parse(dataStr);
        dsg = BuilderGraph.buildDataset(item);
        gn1 = SSE.parseNode("<http://example/g1>");
        gn2 = SSE.parseNode("<http://example/g2>");
        gn3 = SSE.parseNode("<http://example/g3>");
        gn9 = SSE.parseNode("<http://example/g9>");
    }
}

