/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.jena.atlas.lib.Creator;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestDatasets {
    private static final String data = "INSERT DATA { <ex:default> <ex:default> <ex:default>.\nGRAPH <ex:from> { <ex:from> <ex:from> <ex:from> }\nGRAPH <ex:named> { <ex:named> <ex:named> <ex:named> }\nGRAPH <ex:other> { <ex:other> <ex:other> <ex:other> }\n}";
    private final Creator<Dataset> maker;
    private final Dataset ds;
    private final DatasetGraph dsg;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> data() {
        Creator<Dataset> datasetGeneralMaker = () -> DatasetFactory.createGeneral();
        Creator<Dataset> datasetTxnMemMaker = () -> DatasetFactory.createTxnMem();
        return Arrays.asList({"General", datasetGeneralMaker}, {"TxnMem", datasetTxnMemMaker});
    }

    public TestDatasets(String name, Creator<Dataset> maker) {
        this.maker = maker;
        this.ds = maker.create();
        this.dsg = this.ds.asDatasetGraph();
    }

    @Before
    public void setup() {
        UpdateRequest up = UpdateFactory.create(data);
        UpdateProcessor processor = UpdateExecutionFactory.create(up, this.dsg);
        processor.execute();
    }

    private void test(String query2, String[] expected, int expectedCount) {
        Query q = QueryFactory.create(query2);
        QueryExecution exec = QueryExecutionFactory.create(q, this.ds);
        ResultSet results = exec.execSelect();
        ArrayList<String> found = new ArrayList<String>();
        int count = 0;
        while (results.hasNext()) {
            ++count;
            QuerySolution sln = results.next();
            found.add(sln.get("s").toString());
        }
        boolean dumped = false;
        if (expectedCount != count) {
            System.out.println(query2);
            this.dump(expectedCount, count, expected, found);
            dumped = true;
        }
        Assert.assertEquals((long)expectedCount, (long)count);
        for (String e2 : expected) {
            if (found.contains(e2)) continue;
            if (!dumped) {
                System.out.println(query2);
                this.dump(expectedCount, count, expected, found);
                dumped = true;
            }
            Assert.fail((String)("Did not find expected result " + e2));
        }
    }

    private void dump(int expectedCount, int actualCount, String[] expected, List<String> actual) {
        if (expectedCount != actualCount) {
            System.out.println("Got incorrect number of results, expected " + expectedCount + " but got " + actualCount);
        } else {
            System.out.println("Did not find an expected result");
        }
        System.out.print("Expected: ");
        for (String e2 : expected) {
            System.out.print(e2 + " ");
        }
        System.out.println();
        System.out.print("Actual: ");
        for (String a : actual) {
            System.out.print(a + " ");
        }
        System.out.println();
    }

    @Test
    public void from_and_named_and_graph_uri_exists() {
        this.test("SELECT * FROM <ex:from> FROM NAMED <ex:named> { GRAPH <ex:named> { ?s ?p ?o } }", new String[]{"ex:named"}, 1);
    }

    @Test
    public void from_and_named_and_graph_uri_exists_not_in_list() {
        this.test("SELECT * FROM <ex:from> FROM NAMED <ex:named> { GRAPH <ex:other> { ?s ?p ?o } }", new String[0], 0);
    }

    @Test
    public void from_and_named_and_graph_uri_missing() {
        this.test("SELECT * FROM <ex:from> FROM NAMED <ex:named> { GRAPH <ex:missing> { ?s ?p ?o } }", new String[0], 0);
    }

    @Test
    public void from_and_named_and_graph_var() {
        this.test("SELECT * FROM <ex:from> FROM NAMED <ex:named> { GRAPH ?g { ?s ?p ?o } }", new String[]{"ex:named"}, 1);
    }

    @Test
    public void from_and_named_and_graphs_var() {
        this.test("SELECT * FROM <ex:from> FROM NAMED <ex:named> FROM NAMED <ex:other> { GRAPH ?g { ?s ?p ?o } }", new String[]{"ex:named", "ex:other"}, 2);
    }

    @Test
    public void from_and_graph_uri_exists() {
        this.test("SELECT * FROM <ex:from> { GRAPH <ex:named> { ?s ?p ?o } }", new String[0], 0);
    }

    @Test
    public void from_and_graph_uri_missing() {
        this.test("SELECT * FROM <ex:from> { GRAPH <ex:missing> { ?s ?p ?o } }", new String[0], 0);
    }

    @Test
    public void from_and_graph_var() {
        this.test("SELECT * FROM <ex:from> { GRAPH ?g { ?s ?p ?o } }", new String[0], 0);
    }

    @Test
    public void named_graph_var() {
        this.test("SELECT * FROM NAMED <ex:named> WHERE { GRAPH ?g { ?s ?p ?o } }", new String[]{"ex:named"}, 1);
    }

    @Test
    public void named_graphs_var() {
        this.test("SELECT * FROM NAMED <ex:named> FROM NAMED <ex:other> WHERE { GRAPH ?g { ?s ?p ?o } }", new String[]{"ex:named", "ex:other"}, 2);
    }

    @Test
    public void named_graph_uri_exists() {
        this.test("SELECT * FROM NAMED <ex:named> WHERE { GRAPH <ex:named> { ?s ?p ?o } }", new String[]{"ex:named"}, 1);
    }

    @Test
    public void named_graph_uri_missing() {
        this.test("SELECT * FROM NAMED <ex:named> WHERE { GRAPH <ex:missing> { ?s ?p ?o } }", new String[0], 0);
    }

    @Test
    public void from() {
        this.test("SELECT * FROM <ex:from> WHERE { ?s ?p ?o }", new String[]{"ex:from"}, 1);
    }

    @Test
    public void graph_var() {
        this.test("SELECT * WHERE { GRAPH ?g { ?s ?p ?o } }", new String[]{"ex:from", "ex:named", "ex:other"}, 3);
    }

    @Test
    public void graph_uri_exists() {
        this.test("SELECT * WHERE { GRAPH <ex:named> { ?s ?p ?o } }", new String[]{"ex:named"}, 1);
    }

    @Test
    public void graph_uri_missing() {
        this.test("SELECT * WHERE { GRAPH <ex:missing> { ?s ?p ?o } }", new String[0], 0);
    }

    @Test
    public void no_dataset() {
        this.test("SELECT * WHERE { ?s ?p ?o }", new String[]{"ex:default"}, 1);
    }
}

