/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.user;

import java.util.ArrayList;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Multiply;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.function.user.UserDefinedFunctionFactory;
import org.apache.jena.sparql.lang.sparql_11.ParseException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestUserDefinedFunctionFactory {
    @BeforeClass
    public static void setup() {
        UserDefinedFunctionFactory.getFactory().clear();
    }

    @AfterClass
    public static void teardown() {
        UserDefinedFunctionFactory.getFactory().clear();
    }

    @Test
    public void test_user_defined_function_factory_instance() {
        UserDefinedFunctionFactory factory = UserDefinedFunctionFactory.getFactory();
        Assert.assertNotNull((Object)factory);
    }

    @Test
    public void test_user_defined_function_factory_add_01() {
        E_Multiply e2 = new E_Multiply(new ExprVar("x"), new ExprVar("x"));
        UserDefinedFunctionFactory.getFactory().add("http://example/square", e2, new ArrayList<Var>(e2.getVarsMentioned()));
        Assert.assertTrue((boolean)UserDefinedFunctionFactory.getFactory().isRegistered("http://example/square"));
        Assert.assertEquals((Object)e2, (Object)UserDefinedFunctionFactory.getFactory().get("http://example/square").getBaseExpr());
    }

    @Test
    public void test_user_defined_function_factory_add_02() {
        E_Multiply e1 = new E_Multiply(new ExprVar("x"), new ExprVar("x"));
        E_Multiply e2 = new E_Multiply(new ExprVar("y"), new ExprVar("y"));
        UserDefinedFunctionFactory.getFactory().add("http://example/square", e1, new ArrayList<Var>(e1.getVarsMentioned()));
        Assert.assertTrue((boolean)UserDefinedFunctionFactory.getFactory().isRegistered("http://example/square"));
        Assert.assertEquals((Object)e1, (Object)UserDefinedFunctionFactory.getFactory().get("http://example/square").getBaseExpr());
        UserDefinedFunctionFactory.getFactory().add("http://example/square", e2, new ArrayList<Var>(e2.getVarsMentioned()));
        Assert.assertTrue((boolean)UserDefinedFunctionFactory.getFactory().isRegistered("http://example/square"));
        Assert.assertEquals((Object)e2, (Object)UserDefinedFunctionFactory.getFactory().get("http://example/square").getBaseExpr());
    }

    @Test
    public void test_user_defined_function_factory_add_03() throws ParseException {
        E_Multiply e2 = new E_Multiply(new ExprVar("x"), new ExprVar("x"));
        UserDefinedFunctionFactory.getFactory().add("http://example/square", "?x * ?x", new ArrayList<Var>(e2.getVarsMentioned()));
        Assert.assertTrue((boolean)UserDefinedFunctionFactory.getFactory().isRegistered("http://example/square"));
        Assert.assertEquals((Object)e2, (Object)UserDefinedFunctionFactory.getFactory().get("http://example/square").getBaseExpr());
    }
}

