/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.user;

import java.util.ArrayList;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.expr.E_Add;
import org.apache.jena.sparql.expr.E_Function;
import org.apache.jena.sparql.expr.E_Multiply;
import org.apache.jena.sparql.expr.E_Subtract;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprNode;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.LibTestExpr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.NodeValueBoolean;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDouble;
import org.apache.jena.sparql.expr.nodevalue.NodeValueInteger;
import org.apache.jena.sparql.function.user.UserDefinedFunction;
import org.apache.jena.sparql.function.user.UserDefinedFunctionDefinition;
import org.apache.jena.sparql.function.user.UserDefinedFunctionFactory;
import org.apache.jena.sparql.sse.builders.ExprBuildException;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFunctionExpansion {
    @BeforeClass
    public static void setup() {
        UserDefinedFunctionFactory.getFactory().clear();
        UserDefinedFunctionFactory.getFactory().setPreserveDependencies(false);
    }

    @AfterClass
    public static void teardown() {
        UserDefinedFunctionFactory.getFactory().clear();
        UserDefinedFunctionFactory.getFactory().setPreserveDependencies(false);
    }

    @Test
    public void test_function_expansion_01() {
        ExprVar e2 = new ExprVar("x");
        UserDefinedFunctionFactory.getFactory().add("http://example/simple", e2, new ArrayList<Var>(e2.getVarsMentioned()));
        UserDefinedFunction f = (UserDefinedFunction)UserDefinedFunctionFactory.getFactory().create("http://example/simple");
        f.build("http://example/simple", new ExprList(new NodeValueBoolean(true)));
        Expr actual = f.getActualExpr();
        Assert.assertFalse((boolean)e2.equals(actual));
        Assert.assertEquals((long)0L, (long)actual.getVarsMentioned().size());
        Assert.assertEquals((Object)new NodeValueBoolean(true), (Object)actual);
    }

    @Test
    public void test_function_expansion_02() {
        E_Multiply e2 = new E_Multiply(new ExprVar("x"), new ExprVar("x"));
        UserDefinedFunctionFactory.getFactory().add("http://example/square", e2, new ArrayList<Var>(e2.getVarsMentioned()));
        UserDefinedFunction f = (UserDefinedFunction)UserDefinedFunctionFactory.getFactory().create("http://example/square");
        f.build("http://example/square", new ExprList(new NodeValueInteger(3L)));
        Expr actual = f.getActualExpr();
        Assert.assertFalse((boolean)e2.equals(actual));
        Assert.assertEquals((long)0L, (long)actual.getVarsMentioned().size());
        Assert.assertEquals((Object)new E_Multiply(new NodeValueInteger(3L), new NodeValueInteger(3L)), (Object)actual);
    }

    @Test
    public void test_function_expansion_03() {
        E_Multiply e2 = new E_Multiply(new ExprVar("x"), new ExprVar("y"));
        ArrayList<Var> defArgs = new ArrayList<Var>();
        defArgs.add(Var.alloc("x"));
        defArgs.add(Var.alloc("y"));
        UserDefinedFunctionFactory.getFactory().add("http://example/square", e2, defArgs);
        UserDefinedFunction f = (UserDefinedFunction)UserDefinedFunctionFactory.getFactory().create("http://example/square");
        ExprList args = new ExprList();
        args.add(new NodeValueInteger(3L));
        args.add(new NodeValueInteger(4L));
        f.build("http://example/square", args);
        Expr actual = f.getActualExpr();
        Assert.assertFalse((boolean)e2.equals(actual));
        Assert.assertEquals((long)0L, (long)actual.getVarsMentioned().size());
        Assert.assertEquals((Object)new E_Multiply(new NodeValueInteger(3L), new NodeValueInteger(4L)), (Object)actual);
    }

    @Test
    public void test_function_expansion_04() {
        E_Multiply square = new E_Multiply(new ExprVar("x"), new ExprVar("x"));
        UserDefinedFunctionFactory.getFactory().add("http://example/square", square, new ArrayList<Var>(square.getVarsMentioned()));
        E_Multiply cube2 = new E_Multiply(new E_Function("http://example/square", new ExprList(new ExprVar("x"))), new ExprVar("x"));
        UserDefinedFunctionFactory.getFactory().add("http://example/cube", cube2, new ArrayList<Var>(cube2.getVarsMentioned()));
        UserDefinedFunctionDefinition def = UserDefinedFunctionFactory.getFactory().get("http://example/cube");
        Expr base = def.getBaseExpr();
        Assert.assertTrue((boolean)(base instanceof E_Multiply));
        E_Multiply m = (E_Multiply)base;
        Assert.assertTrue((boolean)(m.getArg1() instanceof E_Multiply));
        Assert.assertTrue((boolean)(m.getArg2() instanceof ExprVar));
        Assert.assertEquals((long)1L, (long)base.getVarsMentioned().size());
    }

    @Test
    public void test_function_expansion_05() {
        E_Multiply square = new E_Multiply(new ExprVar("x"), new ExprVar("x"));
        UserDefinedFunctionFactory.getFactory().add("http://example/square", square, new ArrayList<Var>(square.getVarsMentioned()));
        E_Multiply cube2 = new E_Multiply(new E_Function("http://example/square", new ExprList(new ExprVar("y"))), new ExprVar("y"));
        UserDefinedFunctionFactory.getFactory().add("http://example/cube", cube2, new ArrayList<Var>(cube2.getVarsMentioned()));
        UserDefinedFunctionDefinition def = UserDefinedFunctionFactory.getFactory().get("http://example/cube");
        Expr base = def.getBaseExpr();
        Assert.assertTrue((boolean)(base instanceof E_Multiply));
        E_Multiply m = (E_Multiply)base;
        Assert.assertTrue((boolean)(m.getArg1() instanceof E_Multiply));
        Assert.assertTrue((boolean)(m.getArg2() instanceof ExprVar));
        Assert.assertEquals((long)1L, (long)base.getVarsMentioned().size());
    }

    @Test
    public void test_function_expansion_06() {
        E_Subtract takeaway = new E_Subtract(new ExprVar("x"), new ExprVar("y"));
        ArrayList<Var> args = new ArrayList<Var>();
        args.add(Var.alloc("x"));
        args.add(Var.alloc("y"));
        UserDefinedFunctionFactory.getFactory().add("http://example/takeaway", takeaway, args);
        ExprList numArgs = new ExprList();
        numArgs.add(new NodeValueInteger(1L));
        numArgs.add(new NodeValueDouble(2.3));
        E_Function test = new E_Function("http://example/takeaway", numArgs);
        UserDefinedFunctionFactory.getFactory().add("http://example/test", test, new ArrayList<Var>());
        UserDefinedFunctionDefinition def = UserDefinedFunctionFactory.getFactory().get("http://example/test");
        Expr base = def.getBaseExpr();
        Assert.assertTrue((boolean)(base instanceof E_Subtract));
        E_Subtract subtract = (E_Subtract)base;
        Assert.assertTrue((boolean)(subtract.getArg1() instanceof NodeValueInteger));
        Assert.assertTrue((boolean)(subtract.getArg2() instanceof NodeValueDouble));
    }

    @Test
    public void test_function_expansion_07() {
        E_Subtract takeaway = new E_Subtract(new ExprVar("x"), new ExprVar("y"));
        ArrayList<Var> args = new ArrayList<Var>();
        args.add(Var.alloc("x"));
        args.add(Var.alloc("y"));
        UserDefinedFunctionFactory.getFactory().add("http://example/takeaway", takeaway, args);
        ExprList numArgs = new ExprList();
        numArgs.add(new NodeValueDouble(2.3));
        numArgs.add(new NodeValueInteger(1L));
        E_Function test = new E_Function("http://example/takeaway", numArgs);
        UserDefinedFunctionFactory.getFactory().add("http://example/test", test, new ArrayList<Var>());
        UserDefinedFunctionDefinition def = UserDefinedFunctionFactory.getFactory().get("http://example/test");
        Expr base = def.getBaseExpr();
        Assert.assertTrue((boolean)(base instanceof E_Subtract));
        E_Subtract subtract = (E_Subtract)base;
        Assert.assertTrue((boolean)(subtract.getArg1() instanceof NodeValueDouble));
        Assert.assertTrue((boolean)(subtract.getArg2() instanceof NodeValueInteger));
    }

    @Test
    public void test_function_expansion_08() {
        E_Subtract takeaway = new E_Subtract(new ExprVar("x"), new ExprVar("y"));
        ArrayList<Var> args = new ArrayList<Var>();
        args.add(Var.alloc("x"));
        args.add(Var.alloc("y"));
        UserDefinedFunctionFactory.getFactory().add("http://example/takeaway", takeaway, args);
        ExprList altArgs = new ExprList();
        altArgs.add(new ExprVar("a"));
        altArgs.add(new ExprVar("b"));
        ArrayList<Var> defArgs = new ArrayList<Var>();
        defArgs.add(Var.alloc("a"));
        defArgs.add(Var.alloc("b"));
        E_Function test = new E_Function("http://example/takeaway", altArgs);
        UserDefinedFunctionFactory.getFactory().add("http://example/test", test, defArgs);
        UserDefinedFunctionDefinition def = UserDefinedFunctionFactory.getFactory().get("http://example/test");
        Expr base = def.getBaseExpr();
        Assert.assertTrue((boolean)(base instanceof E_Subtract));
        E_Subtract subtract = (E_Subtract)base;
        Assert.assertTrue((boolean)(subtract.getArg1() instanceof ExprVar));
        Assert.assertTrue((boolean)(subtract.getArg2() instanceof ExprVar));
        Assert.assertEquals((Object)subtract.getArg1().getVarName(), (Object)"a");
        Assert.assertEquals((Object)subtract.getArg2().getVarName(), (Object)"b");
    }

    @Test
    public void test_function_expansion_09() {
        E_Subtract takeaway = new E_Subtract(new ExprVar("x"), new ExprVar("y"));
        ArrayList<Var> args = new ArrayList<Var>();
        args.add(Var.alloc("x"));
        args.add(Var.alloc("y"));
        UserDefinedFunctionFactory.getFactory().add("http://example/takeaway", takeaway, args);
        ExprList altArgs = new ExprList();
        altArgs.add(new ExprVar("b"));
        altArgs.add(new ExprVar("a"));
        ArrayList<Var> defArgs = new ArrayList<Var>();
        defArgs.add(Var.alloc("a"));
        defArgs.add(Var.alloc("b"));
        E_Function test = new E_Function("http://example/takeaway", altArgs);
        UserDefinedFunctionFactory.getFactory().add("http://example/test", test, defArgs);
        UserDefinedFunctionDefinition def = UserDefinedFunctionFactory.getFactory().get("http://example/test");
        Expr base = def.getBaseExpr();
        Assert.assertTrue((boolean)(base instanceof E_Subtract));
        E_Subtract subtract = (E_Subtract)base;
        Assert.assertTrue((boolean)(subtract.getArg1() instanceof ExprVar));
        Assert.assertTrue((boolean)(subtract.getArg2() instanceof ExprVar));
        Assert.assertEquals((Object)subtract.getArg1().getVarName(), (Object)"b");
        Assert.assertEquals((Object)subtract.getArg2().getVarName(), (Object)"a");
    }

    @Test
    public void test_function_expansion_10() {
        ExprVar single = new ExprVar("x");
        UserDefinedFunctionFactory.getFactory().add("http://example/single", single, new ArrayList<Var>(single.getVarsMentioned()));
        ArrayList<Var> args = new ArrayList<Var>();
        args.add(Var.alloc("x"));
        args.add(Var.alloc("y"));
        E_Add add = new E_Add(new E_Function("http://example/single", new ExprList(new ExprVar("x"))), new ExprVar("y"));
        UserDefinedFunctionFactory.getFactory().add("http://example/add", add, args);
        UserDefinedFunctionDefinition def = UserDefinedFunctionFactory.getFactory().get("http://example/add");
        Expr base = def.getBaseExpr();
        Assert.assertTrue((boolean)(base instanceof E_Add));
        E_Add actual = (E_Add)base;
        Assert.assertTrue((boolean)(actual.getArg1() instanceof ExprVar));
        Assert.assertTrue((boolean)(actual.getArg2() instanceof ExprVar));
        Assert.assertEquals((Object)"x", (Object)actual.getArg1().getVarName());
        Assert.assertEquals((Object)"y", (Object)actual.getArg2().getVarName());
    }

    @Test
    public void test_function_expansion_11() {
        ExprVar single = new ExprVar("x");
        UserDefinedFunctionFactory.getFactory().add("http://example/single", single, new ArrayList<Var>(single.getVarsMentioned()));
        ArrayList<Var> args = new ArrayList<Var>();
        args.add(Var.alloc("x"));
        args.add(Var.alloc("y"));
        E_Add add = new E_Add(new E_Function("http://example/single", new ExprList(new ExprVar("y"))), new ExprVar("y"));
        UserDefinedFunctionFactory.getFactory().add("http://example/add", add, args);
        UserDefinedFunctionDefinition def = UserDefinedFunctionFactory.getFactory().get("http://example/add");
        Expr base = def.getBaseExpr();
        Assert.assertTrue((boolean)(base instanceof E_Add));
        E_Add actual = (E_Add)base;
        Assert.assertTrue((boolean)(actual.getArg1() instanceof ExprVar));
        Assert.assertTrue((boolean)(actual.getArg2() instanceof ExprVar));
        Assert.assertEquals((Object)"y", (Object)actual.getArg1().getVarName());
        Assert.assertEquals((Object)"y", (Object)actual.getArg2().getVarName());
    }

    @Test
    public void test_function_expansion_12() {
        E_Subtract takeaway = new E_Subtract(new ExprVar("x"), new ExprVar("y"));
        ArrayList<Var> args = new ArrayList<Var>();
        args.add(Var.alloc("x"));
        args.add(Var.alloc("y"));
        UserDefinedFunctionFactory.getFactory().add("http://example/takeaway", takeaway, args);
        ExprList altArgs = new ExprList();
        altArgs.add(new ExprVar("a"));
        altArgs.add(new ExprVar("a"));
        ArrayList<Var> defArgs = new ArrayList<Var>();
        defArgs.add(Var.alloc("a"));
        defArgs.add(Var.alloc("b"));
        E_Function test = new E_Function("http://example/takeaway", altArgs);
        UserDefinedFunctionFactory.getFactory().add("http://example/test", test, defArgs);
        UserDefinedFunctionDefinition def = UserDefinedFunctionFactory.getFactory().get("http://example/test");
        Expr base = def.getBaseExpr();
        Assert.assertTrue((boolean)(base instanceof E_Subtract));
        E_Subtract subtract = (E_Subtract)base;
        Assert.assertTrue((boolean)(subtract.getArg1() instanceof ExprVar));
        Assert.assertTrue((boolean)(subtract.getArg2() instanceof ExprVar));
        Assert.assertEquals((Object)subtract.getArg1().getVarName(), (Object)"a");
        Assert.assertEquals((Object)subtract.getArg2().getVarName(), (Object)"a");
    }

    @Test
    public void test_function_expansion_13() {
        ExprNode square = new E_Multiply(new ExprVar("x"), new ExprVar("x"));
        UserDefinedFunctionFactory.getFactory().add("http://example/square", square, new ArrayList<Var>(square.getVarsMentioned()));
        E_Multiply cube2 = new E_Multiply(new E_Function("http://example/square", new ExprList(new ExprVar("x"))), new ExprVar("x"));
        UserDefinedFunctionFactory.getFactory().add("http://example/cube", cube2, new ArrayList<Var>(cube2.getVarsMentioned()));
        UserDefinedFunction f = (UserDefinedFunction)UserDefinedFunctionFactory.getFactory().create("http://example/cube");
        f.build("http://example/cube", new ExprList(new NodeValueInteger(2L)));
        Expr actual = f.getActualExpr();
        NodeValue result = actual.eval(BindingFactory.empty(), LibTestExpr.createTest());
        Assert.assertEquals((long)8L, (long)NodeFactoryExtra.nodeToInt(result.asNode()));
        square = new ExprVar("x");
        UserDefinedFunctionFactory.getFactory().add("http://example/square", square, new ArrayList<Var>(square.getVarsMentioned()));
        f.build("http://example/cube", new ExprList(new NodeValueInteger(2L)));
        actual = f.getActualExpr();
        result = actual.eval(BindingFactory.empty(), LibTestExpr.createTest());
        Assert.assertEquals((long)8L, (long)NodeFactoryExtra.nodeToInt(result.asNode()));
    }

    @Test(expected=ExprBuildException.class)
    public void test_function_expansion_bad_01() {
        ArrayList<Var> args = new ArrayList<Var>();
        args.add(Var.alloc("x"));
        args.add(Var.alloc("y"));
        E_Add add = new E_Add(new ExprVar("x"), new ExprVar("y"));
        UserDefinedFunctionFactory.getFactory().add("http://example/add", add, new ArrayList<Var>());
    }

    @Test(expected=ExprBuildException.class)
    public void test_function_expansion_bad_02() {
        ExprVar single = new ExprVar("x");
        UserDefinedFunctionFactory.getFactory().add("http://example/single", single, new ArrayList<Var>(single.getVarsMentioned()));
        E_Function test = new E_Function("http://example/single", new ExprList(new ExprVar("x")));
        UserDefinedFunctionFactory.getFactory().add("http://example/test", test, new ArrayList<Var>());
    }
}

