/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library;

import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.LibTestExpr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.sys.JenaSystem;
import org.junit.Assert;
import org.junit.Test;

public class TestFnFunctionsString {
    String hw_ka = "\uff76";
    String hw_ten = "\uff9f";

    @Test
    public void exprStrLen1() {
        LibTestExpr.test("fn:string-length('')", NodeValue.nvZERO);
    }

    @Test
    public void exprStrLen2() {
        LibTestExpr.test("fn:string-length('a')", NodeValue.nvONE);
    }

    @Test
    public void exprStrLen3() {
        LibTestExpr.test("fn:string-length('\ud801\udc08\ud801\udc4c\ud801\udc3b\ud801\udc2a\ud801\udc49\ud801\udc3f\ud801\udc3b\ud801\udc2e\ud801\udc3f\ud801\udc32')", NodeValue.makeInteger(10L));
    }

    @Test
    public void exprSubstring1() {
        LibTestExpr.test("fn:substring('',0)", NodeValue.makeString(""));
    }

    @Test
    public void exprSubstring2() {
        LibTestExpr.test("fn:substring('',1)", NodeValue.makeString(""));
    }

    @Test
    public void exprSubstring3() {
        LibTestExpr.test("fn:substring('',1,0)", NodeValue.makeString(""));
    }

    @Test
    public void exprSubstring4() {
        LibTestExpr.test("fn:substring('',1,1)", NodeValue.makeString(""));
    }

    @Test
    public void exprSubstring5() {
        LibTestExpr.test("fn:substring('abc',1)", NodeValue.makeString("abc"));
    }

    @Test
    public void exprSubstring6() {
        LibTestExpr.test("fn:substring('abc',2)", NodeValue.makeString("bc"));
    }

    @Test
    public void exprSubstring7() {
        LibTestExpr.test("fn:substring('a',1,1)", NodeValue.makeString("a"));
    }

    @Test
    public void exprSubstring8() {
        LibTestExpr.test("fn:substring('a',1,2)", NodeValue.makeString("a"));
    }

    @Test
    public void exprSubstring9() {
        LibTestExpr.test("fn:substring('a',0)", NodeValue.makeString(""));
    }

    @Test
    public void exprSubstring10() {
        LibTestExpr.test("fn:substring('abc',1.6,1.33)", NodeValue.makeString("b"));
    }

    @Test
    public void exprSubstring11() {
        LibTestExpr.test("fn:substring('abc',-1, -15.3)", NodeValue.makeString(""));
    }

    @Test
    public void exprSubstring12() {
        LibTestExpr.test("fn:substring('\ud801\udc08\ud801\udc4c\ud801\udc3b\ud801\udc2a\ud801\udc49\ud801\udc3f\ud801\udc3b\ud801\udc2e\ud801\udc3f\ud801\udc32', 1, 1)", NodeValue.makeString("\ud801\udc08"));
    }

    @Test
    public void exprStrStart0() {
        LibTestExpr.test("fn:starts-with('abc', '')", NodeValue.TRUE);
    }

    @Test
    public void exprStrStart1() {
        LibTestExpr.test("fn:starts-with('abc', 'a')", NodeValue.TRUE);
    }

    @Test
    public void exprStrStart2() {
        LibTestExpr.test("fn:starts-with('abc', 'ab')", NodeValue.TRUE);
    }

    @Test
    public void exprStrStart3() {
        LibTestExpr.test("fn:starts-with('abc', 'abc')", NodeValue.TRUE);
    }

    @Test
    public void exprStrStart4() {
        LibTestExpr.test("fn:starts-with('abc', 'abcd')", NodeValue.FALSE);
    }

    @Test
    public void exprStrEnds0() {
        LibTestExpr.test("fn:ends-with('abc', '')", NodeValue.TRUE);
    }

    @Test
    public void exprStrEnds1() {
        LibTestExpr.test("fn:ends-with('abc', 'c')", NodeValue.TRUE);
    }

    @Test
    public void exprStrEnds2() {
        LibTestExpr.test("fn:ends-with('abc', 'bc')", NodeValue.TRUE);
    }

    @Test
    public void exprStrEnds3() {
        LibTestExpr.test("fn:ends-with('abc', 'abc')", NodeValue.TRUE);
    }

    @Test
    public void exprStrEnds4() {
        LibTestExpr.test("fn:ends-with('abc', 'zabc')", NodeValue.FALSE);
    }

    @Test
    public void exprStrCase1() {
        LibTestExpr.test("fn:lower-case('aBc')", NodeValue.makeString("abc"));
    }

    @Test
    public void exprStrCase2() {
        LibTestExpr.test("fn:lower-case('abc')", NodeValue.makeString("abc"));
    }

    @Test
    public void exprStrCase3() {
        LibTestExpr.test("fn:upper-case('abc')", NodeValue.makeString("ABC"));
    }

    @Test
    public void exprStrCase4() {
        LibTestExpr.test("fn:upper-case('ABC')", NodeValue.makeString("ABC"));
    }

    @Test
    public void exprStrContains0() {
        LibTestExpr.test("fn:contains('abc', '')", NodeValue.TRUE);
    }

    @Test
    public void exprStrContains1() {
        LibTestExpr.test("fn:contains('abc', 'a')", NodeValue.TRUE);
    }

    @Test
    public void exprStrContains2() {
        LibTestExpr.test("fn:contains('abc', 'b')", NodeValue.TRUE);
    }

    @Test
    public void exprStrContains3() {
        LibTestExpr.test("fn:contains('abc', 'c')", NodeValue.TRUE);
    }

    @Test
    public void exprStrContains4() {
        LibTestExpr.test("fn:contains('abc', 'ab')", NodeValue.TRUE);
    }

    @Test
    public void exprStrContains5() {
        LibTestExpr.test("fn:contains('abc', 'bc')", NodeValue.TRUE);
    }

    @Test
    public void exprStrContains6() {
        LibTestExpr.test("fn:contains('abc', 'abc')", NodeValue.TRUE);
    }

    @Test
    public void exprStrContains7() {
        LibTestExpr.test("fn:contains('abc', 'Xc')", NodeValue.FALSE);
    }

    @Test
    public void exprStrContains8() {
        LibTestExpr.test("fn:contains('abc', 'Xa')", NodeValue.FALSE);
    }

    @Test
    public void exprStrNormalizeSpace0() {
        LibTestExpr.test("fn:normalize-space(' The    wealthy curled darlings                                         of    our    nation. ')", NodeValue.makeString("The wealthy curled darlings of our nation."));
    }

    @Test
    public void exprStrNormalizeSpace1() {
        LibTestExpr.test("fn:normalize-space('')", NodeValue.nvEmptyString);
    }

    @Test
    public void exprStrNormalizeSpace2() {
        LibTestExpr.test("fn:normalize-space('   Aaa     ')", NodeValue.makeString("Aaa"));
    }

    @Test
    public void exprStrNormalizeSpace3() {
        LibTestExpr.test("fn:normalize-space('A a   a    a a    ')", NodeValue.makeString("A a a a a"));
    }

    @Test
    public void exprStrNormalizeUnicode0() {
        LibTestExpr.test("fn:normalize-unicode('\u00c4ffin','nfd')", NodeValue.makeString("A\u0308ffin"));
    }

    @Test
    public void exprStrNormalizeUnicode1() {
        LibTestExpr.test("fn:normalize-unicode('\u00c4ffin','nfc')", NodeValue.makeString("\u00c4ffin"));
    }

    @Test
    public void exprStrNormalizeUnicode2() {
        LibTestExpr.test("fn:normalize-unicode('\u00c4\\uFB03n','nfd')", NodeValue.makeString("A\u0308\ufb03n"));
    }

    @Test
    public void exprStrNormalizeUnicode3() {
        LibTestExpr.test("fn:normalize-unicode('\u00c4\\uFB03n','nfc')", NodeValue.makeString("\u00c4\ufb03n"));
    }

    @Test
    public void exprStrNormalizeUnicode4() {
        LibTestExpr.test("fn:normalize-unicode('Henry IV','nfd')", NodeValue.makeString("Henry IV"));
    }

    @Test
    public void exprStrNormalizeUnicode5() {
        LibTestExpr.test("fn:normalize-unicode('Henry IV','nfc')", NodeValue.makeString("Henry IV"));
    }

    @Test
    public void exprStrNormalizeUnicode6() {
        LibTestExpr.test("fn:normalize-unicode('\u00c4ffin','nfkd')", NodeValue.makeString("A\u0308ffin"));
    }

    @Test
    public void exprStrNormalizeUnicode7() {
        LibTestExpr.test("fn:normalize-unicode('\u00c4ffin','nfkc')", NodeValue.makeString("\u00c4ffin"));
    }

    @Test
    public void exprStrNormalizeUnicode8() {
        LibTestExpr.test("fn:normalize-unicode('" + this.hw_ka + this.hw_ten + "','nfd')", NodeValue.makeString(this.hw_ka + this.hw_ten));
    }

    @Test
    public void exprStrNormalizeUnicode9() {
        LibTestExpr.test("fn:normalize-unicode('" + this.hw_ka + this.hw_ten + "','nfc')", NodeValue.makeString(this.hw_ka + this.hw_ten));
    }

    @Test
    public void exprStrNormalizeUnicode12() {
        LibTestExpr.test("fn:normalize-unicode('some word','')", NodeValue.makeString("some word"));
    }

    @Test
    public void exprStrNormalizeUnicode13() {
        LibTestExpr.test("fn:normalize-unicode('\u00c4ffin')", NodeValue.makeString("\u00c4ffin"));
    }

    @Test
    public void exprFnReplace01() {
        LibTestExpr.test("fn:replace('abc', 'b', 'Z')", NodeValue.makeString("aZc"));
    }

    @Test
    public void exprFnReplace02() {
        LibTestExpr.test("fn:replace('abc', 'b.', 'Z')", NodeValue.makeString("aZ"));
    }

    @Test
    public void exprFnReplace03() {
        LibTestExpr.test("fn:replace('abcbd', 'b.', 'Z')", NodeValue.makeString("aZZ"));
    }

    @Test
    public void exprFnReplace04() {
        LibTestExpr.test("fn:replace('abcbd'^^xsd:string, 'b.', 'Z')", NodeValue.makeNode("aZZ", XSDDatatype.XSDstring));
    }

    @Test
    public void exprFnReplace05() {
        LibTestExpr.test("fn:replace('abcbd'@en, 'b.', 'Z')", NodeValue.makeNode("aZZ", "en", (String)null));
    }

    @Test
    public void exprFnReplace06() {
        LibTestExpr.test("fn:replace('abcbd', 'B.', 'Z', 'i')", NodeValue.makeString("aZZ"));
    }

    @Test
    public void exprReplace15() {
        this.testEvalException("fn:replace('abc', '^(a){-9}', 'ABC')");
    }

    private void testEvalException(String exprStr) {
        Expr expr = ExprUtils.parse(exprStr);
        try {
            NodeValue r = expr.eval(null, LibTestExpr.createTest());
            Assert.fail((String)"No exception raised");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    static {
        JenaSystem.init();
    }
}

