/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library;

import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.LibTestExpr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.sys.JenaSystem;
import org.junit.Assert;
import org.junit.Test;

public class TestFnFunctionsFormat {
    private static String GroupSepFR;

    @Test
    public void formatNumber_01() {
        TestFnFunctionsFormat.testNumberFormat("fn:format-number(0,'#')", "0");
    }

    @Test
    public void formatNumber_02() {
        TestFnFunctionsFormat.testNumberFormat("fn:format-number(1234, '#')", "1234");
    }

    @Test
    public void formatNumber_03() {
        TestFnFunctionsFormat.testNumberFormat("fn:format-number(1234, '#,###')", "1,234");
    }

    @Test
    public void formatNumber_04() {
        TestFnFunctionsFormat.testNumberFormat("fn:format-number(1e3, '#,###,###.#')", "1,000");
    }

    @Test
    public void formatNumber_05() {
        TestFnFunctionsFormat.testNumberFormat("fn:format-number(10.5, '##.#')", "10.5");
    }

    @Test
    public void formatNumber_06() {
        TestFnFunctionsFormat.testNumberFormat("fn:format-number(-10.5, '##.##')", "-10.5");
    }

    @Test
    public void formatNumber_08() {
        TestFnFunctionsFormat.testNumberFormat("fn:format-number(123, 'NotAPattern')", "NotAPattern123");
    }

    @Test
    public void formatNumber_11() {
        TestFnFunctionsFormat.testNumberFormat("fn:format-number(0, '#', 'fr')", "0");
    }

    @Test
    public void formatNumber_12() {
        TestFnFunctionsFormat.testNumberFormat("fn:format-number(1234.5,'#,###.#', 'fr')", "1" + GroupSepFR + "234,5");
    }

    @Test
    public void formatNumber_13() {
        TestFnFunctionsFormat.testNumberFormat("fn:format-number(1234.5,'#,###.#', 'de')", "1.234,5");
    }

    @Test
    public void formatNumber_14() {
        TestFnFunctionsFormat.testNumberFormat("fn:format-number(12, '0,000.0', 'en')", "0,012.0");
    }

    @Test
    public void formatNumber_15() {
        TestFnFunctionsFormat.testNumberFormat("fn:format-number(0, '00,000', 'fr')", "00" + GroupSepFR + "000");
    }

    @Test(expected=ExprEvalException.class)
    public void formatNumber_20() {
        TestFnFunctionsFormat.testNumberFormat("fn:format-number('String', '#')", null);
    }

    @Test(expected=ExprEvalException.class)
    public void formatNumber_21() {
        TestFnFunctionsFormat.testNumberFormat("fn:format-number(123, <uri>)", null);
    }

    @Test(expected=ExprEvalException.class)
    public void formatNumber_22() {
        TestFnFunctionsFormat.testNumberFormat("fn:format-number(123, '###', 123)", null);
    }

    public void formatNumber_23() {
        TestFnFunctionsFormat.testNumberFormat("fn:format-number(123, '###', 'WhereAmI?')", null);
    }

    private static void testNumberFormat(String expression, String expected) {
        Expr expr = ExprUtils.parse(expression);
        NodeValue r = expr.eval(null, LibTestExpr.createTest());
        Assert.assertTrue((boolean)r.isString());
        Assert.assertEquals((Object)expected, (Object)r.getString());
    }

    static {
        JenaSystem.init();
        GroupSepFR = Character.toString(DecimalFormatSymbols.getInstance(Locale.FRENCH).getGroupingSeparator());
    }
}

