/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library;

import java.util.function.Predicate;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.LibTestExpr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.ExprUtils;
import org.junit.Assert;

public class LibTest {
    private static PrefixMapping pmap = ARQConstants.getGlobalPrefixMap();

    static void test(String string) {
        LibTest.test(string, "true");
    }

    static void test(String exprStr, NodeValue result) {
        Expr expr = ExprUtils.parse(exprStr);
        NodeValue r = expr.eval(null, LibTestExpr.createTest());
        Assert.assertEquals((Object)result, (Object)r);
    }

    static void test(String exprStr, String exprStrExpected) {
        Expr expr = ExprUtils.parse(exprStrExpected);
        NodeValue rExpected = expr.eval(null, LibTestExpr.createTest());
        LibTest.test(exprStr, rExpected);
    }

    static void test(String exprStr, Predicate<NodeValue> test) {
        Expr expr = ExprUtils.parse(exprStr);
        NodeValue r = expr.eval(null, LibTestExpr.createTest());
        Assert.assertTrue((String)exprStr, (boolean)test.test(r));
    }
}

