/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.graph.Node;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnvBase;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.sys.JenaSystem;
import org.junit.Assert;
import org.junit.Test;

public class TestTripleTermFunctions {
    private static PrefixMapping pmap;

    @Test
    public void tripleTermKW_Create1() {
        Node r = TestTripleTermFunctions.eval("triple(:s1, :p1, :o1)");
        Assert.assertNotNull((Object)r);
    }

    @Test(expected=ExprEvalException.class)
    public void tripleTermKW_Create2() {
        TestTripleTermFunctions.eval("triple(:s1, 'bc', :o1)");
    }

    @Test
    public void tripleTermKW_Access1() {
        TestTripleTermFunctions.test("subject(triple(:s1, :p1, :o1))", ":s1");
    }

    @Test
    public void tripleTermKW_Access2() {
        TestTripleTermFunctions.test("predicate(triple(:s1, :p1, :o1))", ":p1");
    }

    @Test
    public void tripleTermKW_Access3() {
        TestTripleTermFunctions.test("object(triple(:s1, :p1, :o1))", ":o1");
    }

    @Test
    public void tripleTermKW_Test1() {
        TestTripleTermFunctions.test("isTriple(triple(:s1, :p1, :o1))", "true");
    }

    @Test
    public void tripleTermKW_Test2() {
        TestTripleTermFunctions.test("isTriple(:x)", "false");
    }

    @Test
    public void tripleTermURI_Create1() {
        Node r = TestTripleTermFunctions.eval("triple(:s1, :p1, :o1)");
        Assert.assertNotNull((Object)r);
    }

    @Test(expected=ExprEvalException.class)
    public void tripleTermURI_Create2() {
        TestTripleTermFunctions.eval("afn:triple(:s1, 'bc', :o1)");
    }

    @Test
    public void tripleTermURI_Access1() {
        TestTripleTermFunctions.test("afn:subject(afn:triple(:s1, :p1, :o1))", ":s1");
    }

    @Test
    public void tripleTermURI_Access2() {
        TestTripleTermFunctions.test("afn:predicate(afn:triple(:s1, :p1, :o1))", ":p1");
    }

    @Test
    public void tripleTermURI_Access3() {
        TestTripleTermFunctions.test("afn:object(afn:triple(:s1, :p1, :o1))", ":o1");
    }

    @Test
    public void tripleTermURI_Test1() {
        TestTripleTermFunctions.test("afn:isTriple(afn:triple(:s1, :p1, :o1))", "true");
    }

    @Test
    public void tripleTermURI_Test2() {
        TestTripleTermFunctions.test("afn:isTriple(:x)", "false");
    }

    private static Node eval(String string) {
        Expr expr = ExprUtils.parse(string, pmap);
        NodeValue nv = expr.eval(null, new FunctionEnvBase());
        return nv.getNode();
    }

    private static void test(String string, String result) {
        Node got = TestTripleTermFunctions.eval(string);
        Node expected = NodeFactoryExtra.parseNode(result);
        Assert.assertEquals((Object)expected, (Object)got);
    }

    static {
        JenaSystem.init();
        pmap = SSE.getPrefixMapRead();
    }
}

