/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.NodeUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestOrdering {
    NodeValue nvInt2 = NodeValue.makeNodeInteger(2L);
    NodeValue nvInt3 = NodeValue.makeNodeInteger("3");
    NodeValue nvInt03 = NodeValue.makeNodeInteger("03");
    NodeValue nvStr3 = NodeValue.makeNodeString("3");
    NodeValue nvStr03 = NodeValue.makeNodeString("03");
    NodeValue nvInt9 = NodeValue.makeNodeInteger(9L);
    NodeValue nvPosInt9 = NodeValue.makeNode("9", XSDDatatype.XSDpositiveInteger);
    NodeValue nvInt10 = NodeValue.makeNodeInteger(10L);
    NodeValue nvDouble9 = NodeValue.makeNodeDouble(9.0);
    NodeValue nvFloat8 = NodeValue.makeNode("8.0", XSDDatatype.XSDfloat);
    NodeValue nvByte10 = NodeValue.makeNode("10", XSDDatatype.XSDbyte);
    Node nInt2 = this.nvInt2.getNode();
    Node nInt3 = this.nvInt3.getNode();
    Node nInt03 = this.nvInt03.getNode();
    Node nStr3 = this.nvStr3.getNode();
    Node nStr03 = this.nvStr03.getNode();
    Node nInt9 = this.nvInt9.getNode();
    Node nPosInt9 = this.nvPosInt9.getNode();
    Node nInt10 = this.nvInt10.getNode();
    Node nDouble9 = this.nvDouble9.getNode();
    Node nFloat8 = this.nvFloat8.getNode();
    Node nByte10 = this.nvByte10.getNode();

    @Test
    public void testComp_2_3() {
        int x = NodeValue.compareAlways(this.nvInt2, this.nvInt3);
        Assert.assertTrue((String)"2 should be value-less than 3", (-1 == x ? 1 : 0) != 0);
        int y = NodeUtils.compareRDFTerms(this.nInt2, this.nInt3);
        Assert.assertTrue((String)"2 should be strict-less than 3", (-1 == y ? 1 : 0) != 0);
    }

    @Test
    public void testComp_3_str3() {
        int x = NodeValue.compareAlways(this.nvInt3, this.nvStr3);
        int y = NodeUtils.compareRDFTerms(this.nInt3, this.nStr3);
        Assert.assertTrue((String)"3 should be compareAlways greater than \"3\"", (1 == x ? 1 : 0) != 0);
        Assert.assertTrue((String)"3 should be syntactic-greater than to \"3\"", (1 == y ? 1 : 0) != 0);
    }

    @Test
    public void testComp_03_str3() {
        int x = NodeValue.compareAlways(this.nvInt03, this.nvStr3);
        int y = NodeUtils.compareRDFTerms(this.nInt03, this.nStr3);
        Assert.assertTrue((String)"03 (typed) should be compareAlways 'less than' than \"3\"", (-1 == x ? 1 : 0) != 0);
        Assert.assertTrue((String)"03 should be syntactic-less than to \"3\"", (-1 == y ? 1 : 0) != 0);
    }

    @Test
    public void testComp_int_double_1() {
        int x = NodeValue.compareAlways(this.nvInt10, this.nvDouble9);
        int y = NodeUtils.compareRDFTerms(this.nInt10, this.nDouble9);
        Assert.assertTrue((String)"Int 10 less than double 9", (1 == x ? 1 : 0) != 0);
        Assert.assertTrue((String)"Int 10 less than double 9 in syntactic compare", (-1 == y ? 1 : 0) != 0);
    }

    @Test
    public void testComp_byte_double_1() {
        int x = NodeValue.compareAlways(this.nvByte10, this.nvDouble9);
        int y = NodeUtils.compareRDFTerms(this.nByte10, this.nDouble9);
        Assert.assertTrue((String)"Byte 10 less than double 9", (1 == x ? 1 : 0) != 0);
        Assert.assertTrue((String)"Byte 10 greater than double 9 in non-value compare (dataype URIs compare)", (-1 == y ? 1 : 0) != 0);
    }

    @Test
    public void testComp_int_float_1() {
        int x = NodeValue.compareAlways(this.nvInt10, this.nvFloat8);
        int y = NodeUtils.compareRDFTerms(this.nInt10, this.nFloat8);
        Assert.assertTrue((String)"Int 10 less than float 8", (1 == x ? 1 : 0) != 0);
        Assert.assertTrue((String)"Int 10 less than float 8 in syntatic compare", (-1 == y ? 1 : 0) != 0);
    }

    @Test
    public void testComp_int_posint_1() {
        int x = NodeValue.compareAlways(this.nvInt9, this.nvPosInt9);
        Assert.assertTrue((String)"Int 9 should be not equals to positive integer 9", (0 != x ? 1 : 0) != 0);
    }

    @Test
    public void testComp_int_posint_2() {
        int x = NodeValue.compareAlways(this.nvInt10, this.nvPosInt9);
        Assert.assertTrue((String)"Int 10 not greater than positive integer 9", (1 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_xsd_string1() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode(NodeFactory.createLiteral("abc"));
        int x = NodeValue.compare(nv1, nv2 = NodeValue.makeNode(NodeFactory.createLiteral("abc", XSDDatatype.XSDstring)));
        Assert.assertTrue((0 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_xsd_string2() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode(NodeFactory.createLiteral("xyz"));
        int x = NodeValue.compare(nv1, nv2 = NodeValue.makeNode(NodeFactory.createLiteral("abc", XSDDatatype.XSDstring)));
        Assert.assertTrue((1 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_xsd_string3() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode(NodeFactory.createLiteral("xyz", XSDDatatype.XSDstring));
        int x = NodeValue.compare(nv1, nv2 = NodeValue.makeNode(NodeFactory.createLiteral("abc")));
        Assert.assertTrue((1 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_xsd_string4() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode(NodeFactory.createLiteral("abc"));
        int x = NodeValue.compare(nv1, nv2 = NodeValue.makeNode(NodeFactory.createLiteral("xyz", XSDDatatype.XSDstring)));
        Assert.assertTrue((-1 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_xsd_string5() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode(NodeFactory.createLiteral("abc", XSDDatatype.XSDstring));
        int x = NodeValue.compare(nv1, nv2 = NodeValue.makeNode(NodeFactory.createLiteral("xyz")));
        Assert.assertTrue((-1 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_lang1() {
        NodeValue nv1 = NodeValue.makeNode(NodeFactory.createLiteral("abc", "en"));
        NodeValue nv2 = NodeValue.makeNode(NodeFactory.createLiteral("abc"));
        int x = NodeUtils.compareRDFTerms(nv1.asNode(), nv2.asNode());
        Assert.assertTrue((String)"Lang tags should sort after plain literal", (1 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_lang2() {
        NodeValue nv1 = NodeValue.makeNode(NodeFactory.createLiteral("abc", "en"));
        NodeValue nv2 = NodeValue.makeNode(NodeFactory.createLiteral("abc", "EN"));
        int x = NodeUtils.compareRDFTerms(nv1.asNode(), nv2.asNode());
        Assert.assertTrue((String)"Lang tags should sort by case", (1 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_lang3() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode(NodeFactory.createLiteral("ABC", "en"));
        int x = NodeValue.compareAlways(nv1, nv2 = NodeValue.makeNode(NodeFactory.createLiteral("abc", "EN")));
        Assert.assertTrue((String)"Lang nodes should sort by lexical if tags value-same", (-1 == x ? 1 : 0) != 0);
        int y = NodeUtils.compareRDFTerms(nv1.asNode(), nv2.asNode());
        Assert.assertTrue((String)"Lang nodes should sort by case (syntactically)", (-1 == y ? 1 : 0) != 0);
    }

    @Test
    public void test_lang4() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode(NodeFactory.createLiteral("ABC", "en"));
        int x = NodeValue.compareAlways(nv1, nv2 = NodeValue.makeNode(NodeFactory.createLiteral("abc", "en")));
        Assert.assertTrue((String)"Lang nodes should sort by lexical if tags the same", (-1 == x ? 1 : 0) != 0);
        int y = NodeUtils.compareRDFTerms(nv1.asNode(), nv2.asNode());
        Assert.assertTrue((String)"Lang nodes should sort by lexical form if lang tags the same", (-1 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_lang5() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode(NodeFactory.createLiteral("abc"));
        int x = NodeValue.compareAlways(nv1, nv2 = NodeValue.makeNode(NodeFactory.createLiteral("xyz", "en")));
        Assert.assertTrue((String)"Lang nodes should sort by lexical form if one is plain", (-1 == x ? 1 : 0) != 0);
        int y = NodeUtils.compareRDFTerms(nv1.asNode(), nv2.asNode());
        Assert.assertTrue((-1 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_lang6() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode(NodeFactory.createLiteral("xyz"));
        int x = NodeValue.compareAlways(nv1, nv2 = NodeValue.makeNode(NodeFactory.createLiteral("abc", "en")));
        Assert.assertTrue((String)"Lang nodes should sort by lexical form if one is plain", (1 == x ? 1 : 0) != 0);
        int y = NodeUtils.compareRDFTerms(nv1.asNode(), nv2.asNode());
        Assert.assertTrue((1 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_lang7() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode(NodeFactory.createLiteral("abc", XSDDatatype.XSDstring));
        int x = NodeValue.compareAlways(nv1, nv2 = NodeValue.makeNode(NodeFactory.createLiteral("xyz", "en")));
        Assert.assertTrue((String)"Lang nodes should sort by lexical form if other is XSD string", (-1 == x ? 1 : 0) != 0);
        int y = NodeUtils.compareRDFTerms(nv1.asNode(), nv2.asNode());
        Assert.assertTrue((-1 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_lang8() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode(NodeFactory.createLiteral("xyz", XSDDatatype.XSDstring));
        int x = NodeValue.compareAlways(nv1, nv2 = NodeValue.makeNode(NodeFactory.createLiteral("abc", "en")));
        Assert.assertTrue((String)"Lang nodes should sort by lexical form if other is XSD string", (1 == x ? 1 : 0) != 0);
        int y = NodeUtils.compareRDFTerms(nv1.asNode(), nv2.asNode());
        Assert.assertTrue((1 == x ? 1 : 0) != 0);
    }

    @Test
    public void test_variable1() {
        Node y;
        Node x = NodeFactory.createVariable("x");
        int res = NodeUtils.compareRDFTerms(x, y = NodeFactory.createVariable("x"));
        Assert.assertTrue((String)"Variable nodes should sort by variable names", (0 == res ? 1 : 0) != 0);
    }

    @Test
    public void test_variable2() {
        Node y;
        Node x = NodeFactory.createVariable("x");
        int res = NodeUtils.compareRDFTerms(x, y = NodeFactory.createVariable("y"));
        Assert.assertTrue((String)"Variable nodes should sort by variable names", (-1 == res ? 1 : 0) != 0);
        res = NodeUtils.compareRDFTerms(y, x);
        Assert.assertTrue((String)"Variable nodes should sort by variable names", (1 == res ? 1 : 0) != 0);
    }

    @Test
    public void test_variable3() {
        Node y;
        Node x = NodeFactory.createVariable("x");
        int res = NodeUtils.compareRDFTerms(x, y = NodeFactory.createBlankNode());
        Assert.assertTrue((String)"Variable nodes should be less than blank nodes", (-1 == res ? 1 : 0) != 0);
        res = NodeUtils.compareRDFTerms(y, x);
        Assert.assertTrue((String)"Variable nodes should be less than blank nodes", (1 == res ? 1 : 0) != 0);
    }

    @Test
    public void test_variable4() {
        Node y;
        Node x = NodeFactory.createVariable("x");
        int res = NodeUtils.compareRDFTerms(x, y = NodeFactory.createURI("http://uri"));
        Assert.assertTrue((String)"Variable nodes should be less than URI nodes", (-1 == res ? 1 : 0) != 0);
        res = NodeUtils.compareRDFTerms(y, x);
        Assert.assertTrue((String)"Variable nodes should be less than URI nodes", (1 == res ? 1 : 0) != 0);
    }

    @Test
    public void test_variable5() {
        Node y;
        Node x = NodeFactory.createVariable("x");
        int res = NodeUtils.compareRDFTerms(x, y = NodeFactory.createLiteral("test"));
        Assert.assertTrue((String)"Variable nodes should be less than literal nodes", (-1 == res ? 1 : 0) != 0);
        res = NodeUtils.compareRDFTerms(y, x);
        Assert.assertTrue((String)"Variable nodes should be less than literal nodes", (1 == res ? 1 : 0) != 0);
    }

    @Test
    public void test_nodeTriple_1() {
        Node y;
        Node x = SSE.parseNode("<<:s :p 1>>");
        int res = NodeUtils.compareRDFTerms(x, y = SSE.parseNode("<<:s :p 2>>"));
        Assert.assertTrue((-1 == res ? 1 : 0) != 0);
        res = NodeUtils.compareRDFTerms(y, x);
        Assert.assertTrue((1 == res ? 1 : 0) != 0);
    }

    @Test
    public void test_nodeTriple_2() {
        Node y;
        Node x = SSE.parseNode("<<:s2 :p 1>>");
        int res = NodeUtils.compareRDFTerms(x, y = SSE.parseNode("<<:s1 :p 2>>"));
        Assert.assertTrue((1 == res ? 1 : 0) != 0);
        res = NodeUtils.compareRDFTerms(y, x);
        Assert.assertTrue((-1 == res ? 1 : 0) != 0);
    }

    @Test
    public void test_nodeTriple_3() {
        Node y;
        Node x = SSE.parseNode("<<:s :p 2>>");
        int res = NodeUtils.compareRDFTerms(x, y = SSE.parseNode("<<:s :p 2>>"));
        Assert.assertTrue((0 == res ? 1 : 0) != 0);
    }

    @Test
    public void test_nodeTriple_4() {
        Node y;
        Node x = SSE.parseNode("'abc'");
        int res = NodeUtils.compareRDFTerms(x, y = SSE.parseNode("<<:s :p 2>>"));
        Assert.assertTrue((-1 == res ? 1 : 0) != 0);
        res = NodeUtils.compareRDFTerms(y, x);
        Assert.assertTrue((1 == res ? 1 : 0) != 0);
    }

    @Test
    public void test_nodeTriple_5() {
        Node y;
        Node x = SSE.parseNode("<uri>");
        int res = NodeUtils.compareRDFTerms(x, y = SSE.parseNode("<<:s :p 2>>"));
        Assert.assertTrue((-1 == res ? 1 : 0) != 0);
        res = NodeUtils.compareRDFTerms(y, x);
        Assert.assertTrue((1 == res ? 1 : 0) != 0);
    }
}

